
<title><?php echo e(trans('home.courses')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.courses')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.courses')); ?></li>
                </ol>
            </div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('operations')): ?>
            <div class="btn btn-list">
                <a href="<?php echo e(route('courses.create')); ?>"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> <?php echo e(trans('home.publish/unpublish')); ?></button></a>
                <a class="mr-2" id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> <?php echo e(trans('home.delete')); ?></button></a>
            </div>
            <?php endif; ?>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.courses')); ?></h6>
                            <p class="text-muted card-sub-title"><?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                            <hr>
                        </div>
                        
                        <div class="table-responsive">
                        <table class="table text-center" id="exportexample">
                        <thead>
                            <tr>
                                <th><input type="checkbox" class="form-check-input" id="checkAll" /></th>
                                <th><?php echo e(trans('home.id')); ?></th>
                                <th><?php echo e(trans('home.name')); ?></th>
                                <th><?php echo e(trans('home.view_all') . ' ' . __('home.chapters')); ?></th>
                                <th><?php echo e(__('home.publish/unpublish')); ?></th>
                                <th><?php echo e(__('home.edit')); ?></th>
                                <th><?php echo e(__('home.delete')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr id="<?php echo e($course->id); ?>">
                                    <td> <input type="checkbox" name="checkbox" class="tableChecked form-check-input"
                                            value="<?php echo e($course->id); ?>" /> </td>
                                    <td><a href="<?php echo e(route('courses.edit', $course->id)); ?>"><?php echo e($course->id); ?></a></td>
                                    <td><?php echo e($course->{'name_' . $lang}); ?></td>
                                    <td><a href="<?php echo e(url('admin/courses/' . $course->id . '/chapters')); ?>"
                                            class="btn btn-info waves-effect waves-light "><?php echo e('( ' . count($course->chapters) . ' ) ' . __('home.chapters')); ?></a>
                                    </td>
                                    <td>
                                        <input class="btn_active" data-id="<?php echo e($course->id); ?>" type="checkbox"
                                            id="switch-<?php echo e($course->id); ?>" switch="success"
                                            <?php echo e($course->status == 1 ? 'checked' : ''); ?> />
                                        <label for="switch-<?php echo e($course->id); ?>" data-on-label="<?php echo e(trans('home.yes')); ?>"
                                            data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-info waves-effect waves-light "
                                            href="<?php echo e(route('courses.edit', $course->id)); ?>"><?php echo e(__('home.edit')); ?></a>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-danger waves-effect waves-light btn_delete" href="<?php echo e(route('courses.destroy', $course->id)); ?>"
                                            ><?php echo e(__('home.delete')); ?></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/courses/courses.blade.php ENDPATH**/ ?>