
<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_setting')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.edit_setting')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_setting')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                <?php echo Form::open(['method'=>'PATCH','url' => 'admin/settings/'.$settings->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                                    <div class="row">

                                        <div class="col-md-3 mb-3">
                                            <label for="helperText"><?php echo e(trans('home.default_lang')); ?></label>
                                            <select class="form-control select2" name="default_lang" required>
                                                <option value="en" <?php echo e(($settings->default_lang=="en")?'selected':''); ?>><?php echo e(trans('home.english')); ?></option>
                                                <option value="ar" <?php echo e(($settings->default_lang=="ar")?'selected':''); ?>><?php echo e(trans('home.arabic')); ?></option>
                                            </select>
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label class=""><?php echo e(trans('home.contact_email')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.contact_email')); ?>" name="contact_email" value="<?php echo e($settings->contact_email); ?>">
                                        </div>

                                        <div class="col-md-5 mb-3">
                                            <label class=""><?php echo e(trans('home.email')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.email')); ?>" name="email" value="<?php echo e($settings->email); ?>">
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label class=""><?php echo e(trans('home.telphone')); ?></label>
                                            <input type="mobile"  min="0" class="form-control" placeholder="<?php echo e(trans('home.telphone')); ?>" name="telphone" value="<?php echo e($settings->telphone); ?>">
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label class=""><?php echo e(trans('home.mobile')); ?></label>
                                            <input type="mobile"  min="0" class="form-control" placeholder="<?php echo e(trans('home.mobile')); ?>" name="mobile" value="<?php echo e($settings->mobile); ?>">
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label class=""><?php echo e(trans('home.date')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.date')); ?>" name="date" value="<?php echo e($settings->date); ?>">
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label class=""><?php echo e(trans('home.fax')); ?></label>
                                            <input type="fax"  min="0" class="form-control" placeholder="<?php echo e(trans('home.fax')); ?>" name="fax" value="<?php echo e($settings->fax); ?>">
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label class=""><?php echo e(trans('home.whatsapp')); ?></label>
                                            <input type="whatsapp"  min="0" class="form-control" placeholder="<?php echo e(trans('home.whatsapp')); ?>" name="whatsapp" value="<?php echo e($settings->whatsapp); ?>">
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label for="facebook"><?php echo e(trans('home.facebook')); ?></label>
                                            <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.facebook')); ?>" name="facebook" value="<?php echo e($settings->facebook); ?>">
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label for="twitter"><?php echo e(trans('home.twitter')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.twitter')); ?>" name="twitter" value="<?php echo e($settings->twitter); ?>">
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label for="instgram"><?php echo e(trans('home.instagram')); ?></label>
                                            <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.instagram')); ?>" name="instgram" value="<?php echo e($settings->instgram); ?>">
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label for="linkedin"><?php echo e(trans('home.linkedin')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.linkedin')); ?>" name="linkedin" value="<?php echo e($settings->linkedin); ?>">
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label class=""><?php echo e(trans('home.snapchat')); ?></label>
                                            <input type="text"  min="0" class="form-control" placeholder="<?php echo e(trans('home.snapchat')); ?>" name="snapchat" value="<?php echo e($settings->snapchat); ?>">
                                        </div>


                                        <div class="col-md-3 mb-3">
                                            <label for="tiktok"><?php echo e(trans('home.tiktok')); ?></label>
                                            <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.tiktok')); ?>" name="tiktok" value="<?php echo e($settings->tiktok); ?>">
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label for="youtube"><?php echo e(trans('home.youtube')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.youtube')); ?>" name="youtube" value="<?php echo e($settings->youtube); ?>">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="n_courses"><?php echo e(trans('home.n').' '.__('home.courses')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.n').' '.__('home.courses')); ?>" name="n_courses" value="<?php echo e($settings->n_courses); ?>">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="instructors"><?php echo e(trans('home.n').' '.__('home.instructors')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.n').' '.__('home.instructors')); ?>" name="n_instructors" value="<?php echo e($settings->n_instructors); ?>">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="n_courses"><?php echo e(trans('home.n').' '.__('home.Students Enrolled')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.n').' '.__('home.Students Enrolled')); ?>" name="n_reviews" value="<?php echo e($settings->n_reviews); ?>">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="n_categories"><?php echo e(trans('home.n').' '.__('home.categories')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.n').' '.__('home.courses')); ?>" name="n_categories" value="<?php echo e($settings->n_categories); ?>">
                                        </div>

                                        <div class="col-md-12 mb-3">
                                            <label><?php echo e(trans('home.map_view_riyadh')); ?></label>
                                            <textarea class="form-control" name="map_view_riyadh" type="text" placeholder="<?php echo e(trans('home.map_view_riyadh')); ?>"><?php echo e($settings->map_view_riyadh); ?></textarea>
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label><?php echo e(trans('home.map_url_riyadh')); ?></label>
                                            <textarea class="form-control" name="map_url_riyadh" type="text" placeholder="<?php echo e(trans('home.map_url_riyadh')); ?>"><?php echo e($settings->map_url_riyadh); ?></textarea>
                                        </div>

                                        <div class="col-md-12 mb-3 ">
                                            <iframe src="<?php echo e($settings->map_view_riyadh); ?>" width="100%" height="250" style="border:0;" allowfullscreen="" loading="lazy"referrerpolicy="no-referrer-when-downgrade"></iframe>
                                        </div>

                                        <hr>
                                        
                                        <div class="col-md-12 mb-3">
                                            <label><?php echo e(trans('home.map_view_jeddah')); ?></label>
                                            <textarea class="form-control" name="map_view_jeddah" type="text" placeholder="<?php echo e(trans('home.map_view_jeddah')); ?>"><?php echo e($settings->map_view_jeddah); ?></textarea>
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label><?php echo e(trans('home.map_url_jeddah')); ?></label>
                                            <textarea class="form-control" name="map_url_jeddah" type="text" placeholder="<?php echo e(trans('home.map_url_jeddah')); ?>"><?php echo e($settings->map_url_jeddah); ?></textarea>
                                        </div>

                                        <div class="col-md-12 mb-3 ">
                                            <iframe src="<?php echo e($settings->map_view_jeddah); ?>" width="100%" height="250" style="border:0;" allowfullscreen="" loading="lazy"referrerpolicy="no-referrer-when-downgrade"></iframe>
                                        </div>
                                        
                                        <hr>

                                        <div class="col-md-6 mb-3">
                                            <label for="gtm_script"><?php echo e(trans('home.gtm_script')); ?></label>
                                            <textarea class="form-control" placeholder="<?php echo e(trans('home.gtm_script')); ?>" name="gtm_script"> <?php echo $settings->gtm_script; ?></textarea>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="gtm_noscript"><?php echo e(trans('home.gtm_noscript')); ?></label>
                                            <textarea class="form-control" placeholder="<?php echo e(trans('home.gtm_noscript')); ?>" name="gtm_noscript"> <?php echo $settings->gtm_noscript; ?></textarea>
                                        </div>


                                    </div>
                                    <div class="row">
                                        <div class="form-group col-4">
                                            
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="publish_gtm_script" id="switch" switch="success" <?php echo e(($settings->publish_gtm_script== 1)? 'checked':''); ?>  />
                                                <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                                <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish_gtm_script')); ?></label>
                                            </div>
                                        </div>
                                        <div class="form-group col-4">
                                            
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="publish_contact_modal" id="switch1" switch="success" <?php echo e(($settings->publish_contact_modal == 1)? 'checked':''); ?>  />
                                                <label for="switch1" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                                <label class="form-check-label mx-3" for="switch1"> <?php echo e(trans('home.publish_contact_modal')); ?></label>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                        <a href="<?php echo e(url('/admin')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                    </div>


                                <?php echo Form::close(); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row --> 
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB2DM4_HwOA3s6WsWcyhRt5Q_NO9CoxZpU&callback=initMap2" async defer></script>
    <script>

        $('.lang').select2({
        });

    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/settings/setting.blade.php ENDPATH**/ ?>