
<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('home.settings')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sub-title',__('home.settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="col-lg-9">
        <!-- Start Instructor Profile  -->
        <div class="rbt-dashboard-content bg-color-white rbt-shadow-box">
            <div class="content">

                <div class="section-title">
                    <h4 class="rbt-title-style-3"><?php echo e(__('home.settings')); ?></h4>
                </div>
                <?php if(session()->has('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
                <div class="advance-tab-button mb--30">
                    <ul class="nav nav-tabs tab-button-style-2 justify-content-start"
                        id="settinsTab-4" role="tablist">
                        <li role="presentation">
                            <a href="#" class="tab-button active" id="profile-tab"
                               data-bs-toggle="tab" data-bs-target="#profile" role="tab"
                               aria-controls="profile" aria-selected="true">
                                <span class="title"><?php echo app('translator')->get('home.profile'); ?></span>
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#" class="tab-button" id="password-tab" data-bs-toggle="tab"
                               data-bs-target="#password" role="tab" aria-controls="password"
                               aria-selected="false">
                                <span class="title"><?php echo app('translator')->get('home.password'); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <div class="tab-pane fade active show" id="profile" role="tabpanel"
                         aria-labelledby="profile-tab">
                        <!-- Start Profile Row  -->
                        <form method="POST" class="rbt-profile-row rbt-default-form row row--15" action="<?php echo e(route('updateMyAccount')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                                <div class="rbt-form-group">
                                    <label for="firstname"><?php echo app('translator')->get('home.f_name'); ?></label>
                                    <input type="text" placeholder="<?php echo app('translator')->get('home.f_name'); ?>" name="f_name" value="<?php echo e($user->f_name); ?>">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                                <div class="rbt-form-group">
                                    <label for="lastname"><?php echo app('translator')->get('home.l_name'); ?></label>
                                    <input type="text" placeholder="<?php echo app('translator')->get('home.l_name'); ?>" name="l_name" value="<?php echo e($user->l_name); ?>">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                                <div class="rbt-form-group">
                                    <label for="email"><?php echo app('translator')->get('home.email'); ?></label>
                                    <input type="email" placeholder="<?php echo app('translator')->get('home.email'); ?>" name="email" value="<?php echo e($user->email); ?>">
                                </div>
                            </div>

                            <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                                <div class="rbt-form-group">
                                    <label for="phone"><?php echo app('translator')->get('home.phone'); ?></label>
                                    <input type="tel" name="phone"  value="<?php echo e($user->phone); ?>">
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="rbt-form-group">
                                    <label for="image"><?php echo app('translator')->get('home.image'); ?></label>
                                    <input type="file" name="image" >
                                </div>
                            </div>
                            <div class="col-sm-6 form-group mb-2">
                                <?php if($user->image): ?>
                                    <img alt="<?php echo e($user->name()); ?>" class="col-2 m-2"
                                         src="<?php echo e(URL::to('uploads/users/source')); ?>/<?php echo e($user->image); ?>">
                                <?php else: ?>
                                    <img alt="avatar" class="col-2 m-2"
                                         src="<?php echo e(URL::To('resources/assets/back/images/users/avatar-1.jpg')); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="col-12 mt--20">
                                <div class="rbt-form-group">
                                  <button type="submit" class="rbt-btn btn-gradient"><?php echo app('translator')->get('home.update_info'); ?></button>
                                </div>
                            </div>
                        </form>
                        <!-- End Profile Row  -->
                    </div>

                    <div class="tab-pane fade" id="password" role="tabpanel"
                         aria-labelledby="password-tab">
                        <!-- Start Profile Row  -->
                        <form method="POST" action="<?php echo e(route('updateMyAccountPassword')); ?>" class="rbt-profile-row rbt-default-form row row--15" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="col-12">
                                <div class="rbt-form-group">
                                    <label for="currentpassword"><?php echo app('translator')->get('home.current_password'); ?></label>
                                    <input id="currentpassword" type="password" name="Current Password"
                                           placeholder="<?php echo app('translator')->get('home.Current Password'); ?>" required>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="rbt-form-group">
                                    <label for="newpassword"><?php echo app('translator')->get('home.new_password'); ?></label>
                                    <input id="newpassword" type="password" name="newPassword" placeholder="<?php echo app('translator')->get('home.new_password'); ?>" required>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="rbt-form-group">
                                    <label for="retypenewpassword"><?php echo app('translator')->get('home.confirm_password'); ?></label>
                                    <input id="retypenewpassword" type="password" name="newPassword_confirmation" placeholder="<?php echo app('translator')->get('home.confirm_password'); ?>" required>
                                </div>
                            </div>
                            <div class="col-12 mt--10">
                                <div class="rbt-form-group">
                                    <button type="submit" class="rbt-btn btn-gradient"><?php echo app('translator')->get('home.rest_password'); ?></button>
                                </div>
                            </div>
                        </form>
                        <!-- End Profile Row  -->
                    </div>
                </div>
            </div>
        </div>
        <!-- End Instructor Profile  -->

    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('website.student.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/website/student/settings.blade.php ENDPATH**/ ?>