
<title><?php echo e(trans('home.trainings')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.trainings')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.trainings')); ?></li>
                </ol>
            </div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('operations')): ?>
            <div class="btn btn-list">
                <a href="<?php echo e(url('admin/trainings/create')); ?>"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> <?php echo e(trans('home.publish/unpublish')); ?></button></a>
                <a class="mr-2" id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> <?php echo e(trans('home.delete')); ?></button></a>
            </div>
            <?php endif; ?>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.trainings')); ?></h6>
                            <p class="text-muted card-sub-title"><?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                            <hr>
                        </div>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('trainings_excel')): ?>
                       
                        <form method="post" action="<?php echo e(route('trainings.import.excel')); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    
                                    <div class="input-group mb-1 d-flex justify-content-first">
                                        <div class="input-group-prepend"> 
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file col-3">
                                            <input type="file" class="custom-file-input" name="excelFile"  accept=".csv,.xlsx">
                                            <label class="custom-file-label"
                                                for="inputGroupFile01"><?php echo e(trans('home.choose_excel_file')); ?></label>
                                        </div>
                                        <button class="btn ripple btn-primary mr-5" type="submit"><i
                                        class="fas fa-plus-circle"></i>
                                        <?php echo e(trans('home.importExcel')); ?></button>
                                    </div>
                                        
                                    <?php $__errorArgs = ['excelFile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </form>
                        <?php endif; ?>
                        <div class="table-responsive">
                        <table class="table text-center" id="exportexample">
                        <thead>
                            <tr>
                                <th><input type="checkbox" class="form-check-input" id="checkAll" /></th>
                                <th><?php echo e(trans('home.id')); ?></th>
                                <th><?php echo e(trans('home.name')); ?></th>
                                <th><?php echo e(trans('home.category')); ?></th>
                                <th><?php echo e(trans('home.training_type')); ?></th>
                                <th><?php echo e(__('home.course')); ?></th>
                                <th><?php echo e(__('home.publish/unpublish')); ?></th>
                                <th><?php echo e(__('home.edit')); ?></th>
                                <!--<th><?php echo e(__('home.delete')); ?></th>-->
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $trainings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $training): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr id="<?php echo e($training->id); ?>">
                                    <td> <input type="checkbox" name="checkbox" class="tableChecked form-check-input"
                                            value="<?php echo e($training->id); ?>" /> </td>
                                    <td><a href="<?php echo e(route('courses.edit', $training->id)); ?>"><?php echo e($training->id); ?></a></td>
                                    <td><?php echo e($training->{'name_' . $lang}); ?></td>
                                    <td><?php echo e($training->category ? $training->category->{'name_' . $lang} : 'N/A'); ?></td>
                                    <td><?php echo e($training->type ? $training->type->{'name_' . $lang} : 'N/A'); ?></td>
                                    <td>
                                        <?php if($training->course): ?> 
                                            <a href="<?php echo e(url('admin/courses/' . $training->course->course_id )); ?>" 
                                                class="btn btn-info waves-effect waves-light "><?php echo e(__('home.course')); ?>

                                            </a>
                                        <?php else: ?>
                                            N/A
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <input class="btn_active" data-id="<?php echo e($training->id); ?>" type="checkbox"
                                            id="switch-<?php echo e($training->id); ?>" switch="success"
                                            <?php echo e($training->status == 1 ? 'checked' : ''); ?> />
                                        <label for="switch-<?php echo e($training->id); ?>" data-on-label="<?php echo e(trans('home.yes')); ?>"
                                            data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-info waves-effect waves-light "
                                            href="<?php echo e(route('trainings.edit', $training->id)); ?>"><?php echo e(__('home.edit')); ?></a>
                                    </td>
                                   
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/trainings/trainings.blade.php ENDPATH**/ ?>