<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_blog_item')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.blogItems')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/blog-items')); ?>"><?php echo e(trans('home.blogItems')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_blog_item')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    
    <?php if(session()->has('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session()->pull('success')); ?>

            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    <?php endif; ?>
    
    <?php echo Form::open(['method'=>'PATCH','url' => 'admin/blog-items/'.$blogItem->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title "><?php echo e(trans('home.edit_blog_category')); ?></h6>
                        </div>
                        <div class="row">

                            <div class="form-group col-md-3">
                                <label for="name_en"><?php echo e(trans('home.name_en')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.name_en')); ?>" name="name_en" value="<?php echo e($blogItem->name_en); ?>" required>
                            </div>

                            <div class="form-group col-md-3">
                                <label for="name_ar"><?php echo e(trans('home.name_ar')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.name_ar')); ?>" name="name_ar" value="<?php echo e($blogItem->name_ar); ?>">
                            </div>
                            

                            <div class="form-group col-md-2">
                                <label for="parent"><?php echo e(trans('home.blogCategory')); ?></label>
                                <select class="form-control select2" name="blogcategory_id">
                                    <?php $__currentLoopData = $blogCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blogCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($blogCategory->id); ?>" <?php echo e(($blogCategory->id == $blogItem->blogcategory_id)?'selected':''); ?>><?php echo e((app()->getLocale()=='en')? $blogCategory->name_en:$blogCategory->name_ar); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                                </select>
                            </div>
                            <div class="form-group col-md-2">
                                <label for="parent"><?php echo e(trans('home.BlogCourseCategory')); ?></label>
                                <select class="form-control select2" name="course_category_id">
                                    <?php $__currentLoopData = $blogCourseCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blogCourseCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($blogCourseCategory->id); ?>" <?php echo e(($blogCourseCategory->id == $blogItem->course_category_id)?'selected':''); ?>><?php echo e((app()->getLocale()=='en')? $blogCourseCategory->name_en:$blogCourseCategory->name_ar); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                                </select>
                            </div>
                            <div class="form-group col-md-3"> 
                                <label for="type"><?php echo e(trans('home.writers')); ?></label>
                                <select class="form-control select2 type" name="writer_id">
                                    <?php $__currentLoopData = $writers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $writer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value ="<?php echo e($writer->id); ?>"><?php echo e($writer->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-md-3">
                                <label for="code"><?php echo e(trans('home.date')); ?></label>
                                <div class="input-group">
                                    <input type='text' class="form-control" name="date" placeholder="<?php echo e(trans('home.date')); ?>" id="datepicker" value="<?php echo e($blogItem->date); ?>"  required readonly/>
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fas fa-calendar"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="mobile"><?php echo e(trans('home.mobile')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.mobile')); ?>" name="mobile" value="<?php echo e(old('mobile',$blogItem->mobile)); ?>">
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="whatsapp"><?php echo e(trans('home.whatsapp')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.whatsapp')); ?>" name="whatsapp" value="<?php echo e(old('whatsapp',$blogItem->whatsapp)); ?>">
                            </div>
                            
                            <div class="col-md-2">
                                <label><?php echo e(trans('home.image')); ?></label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-2">
                                <label for="alt_img"><?php echo e(trans('home.alt_img')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.alt_img')); ?>" name="alt_img" value="<?php echo e($blogItem->alt_img); ?>">
                            </div>

                            <?php if($blogItem->image): ?>
                                <div class="col-md-12">
                                    <img src="<?php echo e(url('uploads/blogitems/'.$blogItem->image)); ?>" width="200" height="150">
                                </div>
                            <?php endif; ?>

                            <div class="form-group col-md-6 ">
                                <label for="text_en"><?php echo e(trans('home.text_en')); ?></label>
                                <textarea class="form-control area1" name="text_en" placeholder="<?php echo e(trans('home.text_en')); ?>" ><?php echo $blogItem->text_en; ?></textarea>
                            </div>

                            <div class="form-group col-md-6 "> 
                                <label for="text_ar"><?php echo e(trans('home.text_ar')); ?></label>
                                <textarea class="form-control area1" name="text_ar" placeholder="<?php echo e(trans('home.text_ar')); ?>" ><?php echo $blogItem->text_ar; ?></textarea>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <p class="mt-4 mb-2"><?php echo e(trans('home.status')); ?></p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" value="1" class="custom-switch-input" <?php echo e(($blogItem->status == 1)? 'checked':''); ?>/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description"><?php echo e(trans('home.click_to_publish')); ?></span>
                                </label>
                            </div>

                            <div class="form-group col-md-4">
                                <p class="mt-4 mb-2"><?php echo e(trans('home.home')); ?></p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="home" value="1" class="custom-switch-input" <?php echo e(($blogItem->home == 1)? 'checked':''); ?>/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description"><?php echo e(trans('home.click_to_publish_in_home')); ?></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
       
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title "><?php echo e(trans('home.seo_block')); ?></h6>
                        </div>
                        
                        <div class="col-md-12 mb-3">
                            <label for="redirect_url"><?php echo e(trans('home.redirect_url')); ?></label>
                            <input type="text" class="form-control" value="<?php echo e(old('redirect_url',$blogItem->redirect_url)); ?>" placeholder="<?php echo e(trans('home.redirect_url')); ?>" name="redirect_url">
                        </div>

                        <div class="row">
                            <div class="form-group col-md-12">
                                <hr>
                                <span class="badge badge-success"><?php echo e(trans('home.en')); ?></span>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="link_en"><?php echo e(trans('home.slug')); ?></label>
                                <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_en" value="<?php echo e($blogItem->link_en); ?>">
                            </div>
                    
                            <div class="form-group col-md-5">
                                <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                <textarea class="form-control" name="meta_title_en" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e($blogItem->meta_title_en); ?></textarea>
                            </div>
                            
                            <div class="form-group col-md-5">
                                <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                <textarea class="form-control" name="meta_desc_en" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e($blogItem->meta_desc_en); ?></textarea>
                            </div>
                            
                            <div class="form-group col-md-12">
                                <hr>
                                <span class="badge badge-success"><?php echo e(trans('home.ar')); ?></span>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="link_ar"><?php echo e(trans('home.slug')); ?></label>
                                <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_ar" value="<?php echo e($blogItem->link_ar); ?>">
                            </div>
                            
                            <div class="form-group col-md-5">
                                <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                <textarea class="form-control" name="meta_title_ar" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e($blogItem->meta_title_ar); ?></textarea>
                            </div>
                            
                            <div class="form-group col-md-5">
                                <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                <textarea class="form-control" name="meta_desc_ar" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e($blogItem->meta_desc_ar); ?></textarea>
                            </div>
                            
                            <div class="form-group col-md-12">
                                <p class="mt-4 mb-2"><?php echo e(trans('home.meta_robots')); ?></p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="meta_robots" value="1" class="custom-switch-input" <?php echo e(($blogItem->meta_robots == 1)? 'checked':''); ?>>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description"><?php echo e(trans('home.click_to_index')); ?></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="image-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(url('/admin/blog-items')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="image-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    <?php echo Form::close(); ?>

                       
                        
    <!-- add Modal --> 
    <div class="modal fade text-left" id="addfAQ" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="myModalLabel34"><?php echo e(trans('home.add_faq')); ?></h3>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('storeBlogFaq')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="form-group col-md-6"> 
                                <label for="question_en"><?php echo e(trans('home.question_en')); ?></label>
                                <textarea class="form-control" placeholder="<?php echo e(trans('home.question_en')); ?>" name="question_en"></textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="answer_en"><?php echo e(trans('home.answer_en')); ?></label>
                                <textarea class="form-control" placeholder="<?php echo e(trans('home.answer_en')); ?>" name="answer_en"></textarea>
                            </div>

                            <div class="form-group col-md-6"> 
                                <label for="question_ar"><?php echo e(trans('home.question_ar')); ?></label>
                                <textarea class="form-control" placeholder="<?php echo e(trans('home.question_ar')); ?>" name="question_ar"></textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="answer_ar"><?php echo e(trans('home.answer_ar')); ?></label>
                                <textarea class="form-control" placeholder="<?php echo e(trans('home.answer_ar')); ?>" name="answer_ar"></textarea>
                            </div>
                            
                            <input type="hidden" name="blog_item_id" value="<?php echo e($blogItem->id); ?>"/>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><?php echo e(trans('home.save')); ?> </button>
                            </div>
                        </div>                             
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Modal -->
    <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="modal fade text-left" id="iconForm_<?php echo e($key); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title" id="myModalLabel34"><?php echo e(trans('home.edit_faq')); ?></h3>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="<?php echo e(route('updateBlogFaq')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div class="row">
                                <div class="form-group col-md-6"> 
                                    <label for="question_en"><?php echo e(trans('home.question_en')); ?></label>
                                    <textarea class="form-control" placeholder="<?php echo e(trans('home.question_en')); ?>" name="question_en"><?php echo e($question->question_en); ?></textarea>
                                </div>
    
                                <div class="form-group col-md-6">
                                    <label for="answer_en"><?php echo e(trans('home.answer_en')); ?></label>
                                    <textarea class="form-control" placeholder="<?php echo e(trans('home.answer_en')); ?>" name="answer_en"><?php echo e($question->answer_en); ?></textarea>
                                </div>
                                
                                
                                <div class="form-group col-md-6"> 
                                    <label for="question_ar"><?php echo e(trans('home.question_ar')); ?></label>
                                    <textarea class="form-control" placeholder="<?php echo e(trans('home.question_ar')); ?>" name="question_ar"><?php echo e($question->question_ar); ?></textarea>
                                </div>
    
                                <div class="form-group col-md-6">
                                    <label for="answer_ar"><?php echo e(trans('home.answer_ar')); ?></label>
                                    <textarea class="form-control" placeholder="<?php echo e(trans('home.answer_ar')); ?>" name="answer_ar"><?php echo e($question->answer_ar); ?></textarea>
                                </div> 

                                <input type="hidden" name="faq_id" value="<?php echo e($question->id); ?>"/>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><?php echo e(trans('home.save')); ?> </button>
                                </div>
                            </div>                             
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <script>

        $( "#datepicker" ).datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd'
        });
        
        $(document).ready(function(){
            $('.rmv').click(function () {
                var faq_id = $(this).data('faq_id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo e(route('removeBlogFaq')); ?>",
                    method:'POST',
                    data: {faq_id:faq_id},
                    success:function(data) {
                        location.reload();
                    }
                });
            });
        });
        
        
        
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/blogItems/editBlogItem.blade.php ENDPATH**/ ?>