<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.add_menu')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.menu_items')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/-items')); ?>"><?php echo e(trans('home.menu_items')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.add_menu')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    <?php echo Form::open(['route' => 'menu-items.store', 'data-toggle'=>'validator', 'files'=>'true']); ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.add_menu')); ?></h6>
                            <hr>
                        </div>
                        <div class="row">

                            <div class="form-group col-md-3">
                                <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>" required>
                            </div>

                            <div class="form-group col-md-3">
                                <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>" required>
                            </div>

                            <div class="form-group col-md-3"> 
                                <label for="parent"><?php echo e(trans('home.parent')); ?></label>
                                <select class="form-control select2 parent" name="parent">
                                    <option value ="0"><?php echo e(trans('home.no_parent')); ?></option>
                                    <?php $__currentLoopData = $menuParents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menuParent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($menuParent->id); ?>"><?php if(app()->getLocale() == 'en'): ?> <?php echo e($menuParent->name_en); ?> <?php else: ?> <?php echo e($menuParent->name_ar); ?> <?php endif; ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-md-3"> 
                                <fieldset class="form-group">
                                    <label for="order"><?php echo e(trans('home.order')); ?></label>
                                    <input type="number" min="1"  class="form-control" placeholder="<?php echo e(trans('home.order')); ?>" name="order" required>
                                </fieldset>
                            </div>

                            <div class="form-group col-md-12">
                                <div class="row"> 
                                    <div class="form-group col-md-4"> 
                                        <label for="menu"><?php echo e(trans('home.menu')); ?></label>
                                        <select class="form-control select2 menu" name="menu_id">
                                            <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($menu->id); ?>"><?php echo e((app()->getLocale() == 'en')?$menu->name_en:$menu->name_ar); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group col-md-4"> 
                                        <label for="menu_type"><?php echo e(trans('home.menu_type')); ?></label>
                                        <select class="form-control select2 menu_type" name="menu_type" required>
                                            <option></option>
                                            <option value="home"><?php echo e(trans('home.home')); ?></option>
                                            <option value="about-us"><?php echo e(trans('home.about-us')); ?></option>
                                            <option value="contact-us"><?php echo e(trans('home.contact-us')); ?></option>
                                            <option value="trainings"><?php echo e(trans('home.trainings')); ?></option>
                                            <option value="services"><?php echo e(trans('home.services')); ?></option>
                                            <option value="gallery-images"><?php echo e(trans('home.galleryImages')); ?></option>
                                            <option value="galleryVideos"><?php echo e(trans('home.galleryVideos')); ?></option>
                                            <option value="board-of-members"><?php echo e(trans('home.boardofmembers')); ?></option>
                                            <option value="pages"><?php echo e(trans('home.pages')); ?></option>
                                            <option value="faqs"><?php echo e(trans('home.faqs')); ?></option>
                                            <option value="blogs"><?php echo e(trans('home.blogs')); ?></option>
                                            <option value="blog-category"><?php echo e(trans('home.blog-category')); ?></option>
                                            <option value="blog-item"><?php echo e(trans('home.blog-item')); ?></option>
                                            <option value="link"><?php echo e(trans('home.link')); ?></option>
                                            <option value="main-item"><?php echo e(trans('home.main-item')); ?></option>
                                        </select>
                                    </div>

                                    <div class="form-group col-md-4"> 
                                        <div class="type_values">

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-12">
                                <p class="mt-4 mb-2"><?php echo e(trans('home.publish')); ?></p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" value="1" class="custom-switch-input">
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description"><?php echo e(trans('home.click_to_publish')); ?></span>
                                </label>
                            </div>                               
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">                    
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(url('/admin/menu-items')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    <?php echo Form::close(); ?>


</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $('.status').select2();
        $('.menu').select2();
        $('.menu_type').select2({
            'placeholder' : "<?php echo e(trans('home.choose_menu_type')); ?>",
        });
        $('.parent').select2();

        $('.menu_type').on('change',function(){
            var type = $('.menu_type option:selected').val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url:"<?php echo e(route('menuTypeValue')); ?>",
                method:'POST',
                data:{type:type},
                success:function(html)
                {
                    $('.type_values').html(html.html);
                    $('.type_value').select2();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/menuItems/addMenuItem.blade.php ENDPATH**/ ?>