
<?php $__env->startSection('title'); ?>
    <title><?php echo e($course->{'name_'.$lang}); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- rts lession details area start -->
    <div class="rts-lession-details-area-start">
        <?php if(isset($course_lesson)): ?>
            <div class="rts-lession-content-wrapper">
                <div class="rts-lession-left">
                    <!-- course content accordion area -->
                    <div class="course-content-wrapper-main">
                        <div class="accordion mt--30" id="accordionExample">

                            <?php $__currentLoopData = $course->course->chapters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingOne">
                                        <button class="accordion-button <?php if($chapter->id!=$course_lesson->chapter_id): ?> collapsed <?php endif; ?>" type="button" 
                                            data-bs-toggle="collapse" data-bs-target="#collapse_<?php echo e($chapter->id); ?>" aria-expanded="<?php echo e($chapter->id==$course_lesson->chapter_id? 'true':'false'); ?>" 
                                            aria-controls="collapse_<?php echo e($chapter->id); ?>">
                                            <span><?php echo e($chapter->{'name_'.$lang}); ?></span>
                                            <span><?php echo e($chapter->duration); ?></span>
                                        </button>
                                    </h2>
                                    <div id="collapse_<?php echo e($chapter->id); ?>" class="accordion-collapse collapse <?php if($chapter->id==$course_lesson->chapter_id): ?> show <?php endif; ?>" 
                                        aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <?php $__currentLoopData = $chapter->lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <!-- play single area start -->
                                            <a href="<?php echo e(url('user/lesson/'.$lesson->{'link_'.$lang} )); ?>" class="play-vedio-wrapper">
                                                    <div class="left">
                                                        <i class="fa-light fa-circle-play"></i>
                                                        <span><?php echo e($lesson->{'name_'.$lang}); ?></span>
                                                    </div>
                                                    <div class="right">
                                                        <span><?php echo e($lesson->duration); ?></span>
                                                    </div>
                                                </a>
                                                <!-- play single area end -->
                                                <?php $__currentLoopData = $lesson->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <!-- play single area start -->
                                                    <a href="<?php echo e(Helper::uploadedImagesPath('attachments',$attachment->path )); ?>" 
                                                        download="<?php echo e($attachment->{'name_'.$lang}); ?>.pdf"
                                                          class="play-vedio-wrapper">
                                                        <div class="left">
                                                            <i class="fa-light fa-download"></i>
                                                            <span><?php echo e($attachment->{'name_'.$lang}); ?></span>
                                                        </div>
                                                    </a>
                                                    <!-- play single area end -->
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($chapter->exame): ?>
                                                <a href="<?php echo e(url('user/exame/'.$chapter->exame->id )); ?>" class="play-vedio-wrapper">
                                                    <div class="left">
                                                        <i class="fa-light fa-circle-question"></i>
                                                        <span><?php echo e($chapter->exame->{'name_'.$lang}); ?></span>
                                                    </div>
                                                    <div class="right">
                                                        <span><?php echo e($chapter->exame->duration); ?></span>
                                                    </div>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingOne">
                                    <button class="accordion-button collapsed" type="button" 
                                        data-bs-toggle="collapse" data-bs-target="#collapse_certificate" aria-expanded="false" 
                                        aria-controls="collapse_certificate">
                                        <span><?php echo app('translator')->get('home.certificate'); ?></span>
                                    </button>
                                </h2>
                                <div id="collapse_certificate" class="accordion-collapse collapse" 
                                    aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        
                                        <?php if($order_course->progress==100): ?>
                                            <?php if($order_course->course->my_certificate): ?>
                                                <?php if($order_course->course->my_certificate->status==0): ?>
                                                    <a>
                                                        <div class="left">
                                                            <i class="fa-light fa-download"></i>
                                                            <span><?php echo e(__('home.your certificate has been blocked')); ?></span>
                                                        </div>
                                                    </a> 
                                                <?php else: ?>
                                                    <form method="post" action="<?php echo e(route('getMyCertificate')); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="course_id" value="<?php echo e($course->id); ?>">
                                                        <button type="submit"  class="play-vedio-wrapper">
                                                            <div class="left">
                                                                <i class="fa-light fa-download"></i>
                                                                <span><?php echo e(__('home.certificate').' : '.$course->{'name_'.$lang}); ?></span>
                                                            </div>
                                                        </button>
                                                    </form>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <form method="post" action="<?php echo e(route('getMyCertificate')); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="course_id" value="<?php echo e($course->id); ?>">
                                                    <button type="submit"  class="play-vedio-wrapper">
                                                        <div class="left">
                                                            <i class="fa-light fa-download"></i>
                                                            <span><?php echo e(__('home.certificate').' : '.$course->{'name_'.$lang}); ?></span>
                                                        </div>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <a>
                                                <div class="left">
                                                    <i class="fa-light fa-download"></i>
                                                    <span><?php echo e(__('home.you have to pass 100 of the course')); ?></span>
                                                </div>
                                            </a>    
                                        <?php endif; ?>                                           
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="mt-5">
                            <div class="progress" style="height: 3px;">
                                <div class="progress-bar" role="progressbar" aria-label="Example 1px high" style="width: <?php echo e($order_course->progress); ?>%;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span><?php echo e($order_course->progress.'/100'); ?></span>
                        </div>  
                        <!-- course content accordion area end -->
                    </div>
                </div>
                <div class="rts-lession-right">
                    <div class="lesson-top-bar">
                        <div class="left-area">
                            <div class="toggle-class" id="toggle-left-back">
                                <i class="fa-light fa-chevron-left"></i>
                            </div>
                            <span><?php echo e(__('home.course').' | '.$course->course->{'name_'.$lang}); ?></span>
                        </div>
                        <div class="right">
                            <a href="<?php echo e(url('user/my-courses')); ?>"><i class="fa-solid fa-x"></i></a>
                        </div>
                    </div>
                    <?php if($course?->type?->name_en=="Recorded"): ?>
                        <?php echo $course_lesson?->content_link_en; ?>

                    <?php elseif($course?->type?->name_en==="On Site"): ?>
                        <div class="row d-flex m-5 gap-5">
                            <h4 class="col-auto"><?php echo app('translator')->get('home.address'); ?> : <?php echo e($course_lesson->{'content_link_'.$lang}); ?></h4>
                            <h5 class="col-auto"><?php echo app('translator')->get('home.duration'); ?> : <?php echo e($course_lesson->duration); ?></h5>
                            <h5 class="col-auto"><?php echo app('translator')->get('home.date'); ?> : <?php echo e($course_lesson->date); ?></h5>
                            <h5 class="col-auto"><?php echo app('translator')->get('home.time'); ?> : <?php echo e(Carbon\Carbon::parse($course_lesson->time)->format('h:i A')); ?></h5>
                        </div>                      
                    <?php elseif($course?->type?->name_en==="Online"): ?>
                        <div class="text-center m-5">
                            <h4 class="col-auto"><?php echo app('translator')->get('home.Meeting Link'); ?> : <?php echo e($course_lesson->{'content_link_'.$lang}); ?></h4>
                            <h5 class="col-auto"><?php echo app('translator')->get('home.duration'); ?> : <?php echo e($course_lesson->duration); ?></h5>
                            <h5 class="col-auto"><?php echo app('translator')->get('home.date'); ?> : <?php echo e($course_lesson->date); ?></h5>
                            <h5 class="col-auto"><?php echo app('translator')->get('home.time'); ?> : <?php echo e(Carbon\Carbon::parse($course_lesson->time)->format('h:i A')); ?></h5>
                        </div>
                    <?php endif; ?>
                    <div class="lesson-bottom-area">
                        <h2 class="title mb--10"><?php echo e($course_lesson->{'name_'.$lang}); ?></h2>
                        <h5 class="title mb--10"><?php echo app('translator')->get('home.details'); ?></h5>
                        <p class="disc"><?php echo $course_lesson->{'text_'.$lang}; ?></p>
                    </div>
                    <div class="next-prev-area">
                        <?php if($prev_lesson): ?>
                        <a href="<?php echo e(url('user/lesson/'.$prev_lesson->{'link_'.$lang} )); ?>">
                            <div class="prev">
                                <i class="fa-sharp fa-solid fa-play"></i>
                                <?php echo app('translator')->get('home.prev'); ?>
                            </div>
                        </a>                        
                        <?php endif; ?>
                        <?php if($next_lesson): ?>
                            <a href="<?php echo e(url('user/lesson/'.$next_lesson->{'link_'.$lang} )); ?>">
                                <div class="next">
                                    <?php echo app('translator')->get('home.next'); ?>
                                    <i class="fa-sharp fa-solid fa-play"></i>
                                </div>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
        </div>
        <?php else: ?>
            <div class="row m-5 text-center justify-content-center">
                <h1><?php echo app('translator')->get('home.empty_course'); ?></h1>
                <a href="<?php echo e(url('user/my-courses')); ?>" class="rts-btn btn-border text-center">
                    <?php echo app('translator')->get('home.my_courses'); ?></a>
            </div>
        <?php endif; ?>
    </div>
    <!-- rts lession details area end -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="https://player.vimeo.com/api/player.js"></script>
<?php if(isset($course_lesson)): ?>
<script>
    $(document).ready(function() {
        var actionFlag = true;
        var iframe = document.querySelector('iframe');
        
        var player = new Vimeo.Player(iframe);
        
        player.on('timeupdate', function(data) {
            var duration = data.duration;
            var currentTime = data.seconds;
            var percentPlayed = (currentTime / duration) * 100;
            
            if (percentPlayed >= 80 &&actionFlag) {
                actionFlag=false;
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "<?php echo e(route('updateProgress')); ?>" ,
                    type: 'post',
                    data: {
                        course_lesson_id: '<?php echo e($course_lesson->id); ?>'
                    },
                    success: function(data) {
                        console.log(data);
                    }
                });
            }
        });
    });
</script>
<?php endif; ?>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/userboard/lesson_details.blade.php ENDPATH**/ ?>