<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_about')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.about')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/about')); ?>"><?php echo e(trans('home.about')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_about')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    <?php echo Form::open(['method'=>'PATCH','route' => 'admin.about.update', 'data-toggle'=>'validator', 'files'=>'true']); ?>


        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title "><?php echo e(trans('home.edit_about')); ?></h6>
                            <hr>
                        </div>
                        
                        <div class="row">
                            <div class="form-group col-md-3"> 
                                <label for="title_en"><?php echo e(trans('home.title_en')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.title_en')); ?>" name="title_en" value="<?php echo e($about->title_en); ?>">
                            </div>

                            <div class="form-group col-md-3 ">     
                                <label for="title_ar"><?php echo e(trans('home.title_ar')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.title_ar')); ?>" name="title_ar" value="<?php echo e($about->title_ar); ?>">
                            </div>

                            <div class="form-group col-md-3">
                                <label><?php echo e(trans('home.image')); ?></label>
                                <div class="input-group ">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-2"> 
                                <label for="alt_img"><?php echo e(trans('home.alt_img')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.alt_img')); ?>" name="alt_img" value="<?php echo e($about->alt_img); ?>">
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label><?php echo e(trans('home.banner')); ?></label>
                                <div class="input-group ">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="banner">
                                        <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_banner')); ?></label>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-2"> 
                                <label for="alt_banner"><?php echo e(trans('home.alt_banner')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.alt_banner')); ?>" name="alt_banner" value="<?php echo e($about->alt_banner); ?>">
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label><?php echo e(trans('home.profile_file')); ?></label>
                                <div class="input-group ">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="profile">
                                        <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_profile')); ?></label>
                                    </div>
                                </div>
                            </div>

                           
                            <div class="form-group col-md-6">
                                <?php if($about->image): ?>
                                    <img src="<?php echo e(url('uploads/aboutStrucs/'.$about->image)); ?>" width="150">
                                <?php endif; ?>
                            </div>
                            
                            <div class="form-group col-md-6">
                                <?php if($about->banner): ?>
                                    <img src="<?php echo e(url('uploads/aboutStrucs/.$about->banner')); ?>" width="150">
                                <?php endif; ?>
                            </div>
                            <br>
                            
                            <div class="form-group col-md-6 ">    
                                <label for="text_en"><?php echo e(trans('home.text_en')); ?></label>
                                <textarea class="form-control area1" placeholder="<?php echo e(trans('home.text_en')); ?>" name="text_en"><?php echo $about->text_en; ?></textarea>
                            </div>

                            <div class="form-group col-md-6 ">    
                                <label for="text_ar"><?php echo e(trans('home.text_ar')); ?></label>
                                <textarea class="form-control area1" placeholder="<?php echo e(trans('home.text_ar')); ?>" name="text_ar"><?php echo $about->text_ar; ?></textarea>
                            </div>
                            
                            

                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
        <!-- Row-->
        <div class="row" id="why-us" <?php if($about->why_us_title_en): ?> style="display:block;" <?php else: ?> style="display:none;" <?php endif; ?>> 
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title "><?php echo e(trans('home.why_us')); ?></h6>
                        </div>
                        
                        <div class="row">
                            <div class="form-group col-md-6"> 
                                <label for="why_us_title_en"><?php echo e(trans('home.why_us_title_en')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.why_us_title_en')); ?>" name="why_us_title_en" value="<?php echo e($about->why_us_title_en); ?>">
                            </div>

                            <div class="form-group col-md-6 ">     
                                <label for="why_us_title_ar"><?php echo e(trans('home.why_us_title_ar')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.why_us_title_ar')); ?>" name="why_us_title_ar" value="<?php echo e($about->why_us_title_ar); ?>">
                            </div>
                            

                            <div class="form-group col-md-6 ">    
                                <fieldset class="form-group">
                                    <label for="why_us_text_en"><?php echo e(trans('home.why_us_text_en')); ?></label>
                                    <textarea class="form-control area1" placeholder="<?php echo e(trans('home.why_us_text_en')); ?>" name="why_us_text_en"><?php echo $about->why_us_text_en; ?></textarea>
                                </fieldset>
                            </div>

                            <div class="form-group col-md-6 ">    
                                <fieldset class="form-group">
                                    <label for="why_us_text_ar"><?php echo e(trans('home.why_us_text_ar')); ?></label>
                                    <textarea class="form-control area1" placeholder="<?php echo e(trans('home.why_us_text_ar')); ?>" name="why_us_text_ar"><?php echo $about->why_us_text_ar; ?></textarea>
                                </fieldset>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(url('/admin')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    <?php echo Form::close(); ?>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        //////////// dispaly why us section /////////
        $(".show-why-us").click(function(){
            if($(".show-why-us").is(':checked') ){
                $("#why-us").removeAttr( "style" );
            }else{
                $("#why-us").css({'display': 'none'});
            }
        });
    </script>    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/about/editAbout.blade.php ENDPATH**/ ?>