
<title><?php echo e(trans('home.course_subscribers_requests')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.course_subscribers_requests')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.course_subscribers_requests')); ?></li>
                </ol>
            </div>

            
        </div>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>
        
        
        
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.course_subscribers_statistics')); ?></h6>
                            <br>
                        </div>
                        
                            <div class="row d-flex justify-content-start">
        						<div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-success-transparent rounded-circle text-success">
        									    <i class="far fa-registered"></i>
        									</div>
        									<p class="mb-1 text-muted"><?php echo e(trans('home.registered_count')); ?></p>
        									<h3 class="mb-0"><?php echo e($registered_count); ?></h3>
        								</div>
        							</div>
        						</div>
        					    <div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-primary-transparent rounded-circle text-primary">
        										<i class="fas fa-university"></i>
        									</div>
        									<p class="mb-1 text-muted"><?php echo e(trans('home.university_count')); ?></p>
        									<h3 class="mb-0"><?php echo e($university_count); ?></h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-info-transparent rounded-circle text-info">
        										<i class="fas fa-graduation-cap"></i>
        									</div>
        									<p class="mb-1 text-muted"><?php echo e(trans('home.diploma_count')); ?></p>
        									<h3 class="mb-0"><?php echo e($diploma_count); ?></h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-secondary-transparent rounded-circle text-secondary">
        										<i class="fas fa-award"></i>
        									</div>
        									<p class="mb-1 text-muted"><?php echo e(trans('home.secondary_count')); ?></p>
        									<h3 class="mb-0"><?php echo e($secondary_count); ?></h3>
        								</div>
        							</div>
        						</div>
					        </div>
                        </div>
                    </div>
                </div>
            </div>
        
        

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.course_subscribers_requests')); ?></h6>
                            <p class="text-muted card-sub-title">
                                <?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                        </div>
                        <div class="table-responsive">
                            
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                        <th><?php echo e(trans('home.id')); ?></th>
                                        <th class="wd-50p" ><?php echo e(trans('home.name')); ?></th>
                                        <th class="wd-50p"><?php echo e(trans('home.email')); ?></th>
                                        <th class="wd-10p"><?php echo e(trans('home.phone')); ?></th>
                                        <th class="wd-10p"><?php echo e(trans('home.qualification')); ?></th>
                                        <th class="wd-10p"><?php echo e(trans('home.job')); ?></th>
                                        <th class="wd-10p"><?php echo e(trans('home.course')); ?></th>
                                        <th class="wd-10p"><?php echo e(trans('home.created_at')); ?></th>
                                        
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $course_subscribers_requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course_subscribers_request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($course_subscribers_request->id); ?>">
                                            <td> <input type="checkbox" name="checkbox" class="tableChecked" value="<?php echo e($course_subscribers_request->id); ?>" /> </td>
                                            <td><a href="javascript::void(0)"><?php echo e($course_subscribers_request->id); ?></a>  </td>
                                            <td ><a href="javascript::void(0)"><?php echo e($course_subscribers_request->full_name); ?></a>  </td>
                                            <td><a href="javascript::void(0)"><?php echo e($course_subscribers_request->email); ?></a>  </td>
                                            <td><a href="javascript::void(0)"><?php echo e($course_subscribers_request->phone); ?></a>  </td>
                                            <td><a href="javascript::void(0)"><?php echo e(__('home.'.$course_subscribers_request->qualification)); ?></a>  </td>
                                            <td><a href="javascript::void(0)"><?php echo e($course_subscribers_request->job); ?></a>  </td>
                                            <td><a href="javascript::void(0)"><?php echo e($course_subscribers_request->training->{'name_'.$lang} ?? ''); ?></a>  </td>
                                            <td><a href="javascript::void(0)"><?php echo e($course_subscribers_request->created_at); ?></a>  </td>
                                            
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>    
                            </table>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function(){
        $('#btn_active_marketing_program').click(function(){
            var id = [];
            $('.tableChecked:checked').each(function(i){
                id[i] = $(this).val();
            });
            
            if(id.length === 0) //tell you if the array is empty
            {
                alert("Please Select at least one checkbox");
            }
            else
            {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo url('admin/marketing_program_requests_change_status')?>", 
                    method:'POST',
                    data:{id:id},
                    success:function(data)
                    {
                        // console.log(data);
                        location.reload();
                    }
                });
            }
        });
    });
</script>
    

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/partners/course_subscribers_requests.blade.php ENDPATH**/ ?>