<?php if($home_slider): ?>
    <div class="rbt-banner-area rbt-banner-1 variation-2 height-750">
        <div class="container">
            <div class="row justify-content-between align-items-center">
                <div class="col-lg-8">
                    <div class="content">
                        <div class="inner">
                            <div class="rbt-new-badge rbt-new-badge-one">
                                <span class="rbt-new-badge-icon">🏆</span> <?php echo e(__('home.The Leader in Online Learning')); ?>

                            </div>
                            <h1 class="title">
                                <span class="color-primary">
                                    <span class="header-caption">
                                        <span class="cd-headline rotate-1">
                                            <span class="cd-words-wrapper" style='width:fit-content !important'>
                                                <b class="is-visible theme-gradient"><?php echo e(__('home.Online')); ?></b>
                                                <b class="is-hidden theme-gradient"><?php echo e(__('home.Learning')); ?></b>
                                                <b class="is-hidden theme-gradient"><?php echo e(__('home.Courses')); ?></b>
                                            </span>
                                        </span>
                                    </span>
                                </span>
                               <?php echo $home_slider->title; ?>

                            </h1>
                            <p class="description">
                            <?php echo $home_slider->text; ?> 
                            </p>
                            <div class="slider-btn">
                                <a class="rbt-btn btn-gradient-animated hover-icon-reverse" href="<?php echo e(LaravelLocalization::localizeUrl('/courses')); ?>">
                                    <span class="icon-reverse-wrapper">
                                        <span class="btn-text"><?php echo e(__('home.View Course')); ?></span>
                                        <span class="btn-icon"><i class="feather-arrow-right"></i></span>
                                        <span class="btn-icon"><i class="feather-arrow-right"></i></span>
                                    </span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Cards -->
                <div class="col-lg-4">
                    <div class="content">
                        <div class="banner-card pb--60 swiper rbt-dot-bottom-center banner-swiper-active">
                            <div class="swiper-wrapper">
                                <?php $__currentLoopData = $headerCourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $headerCourse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <!-- Start Single Category  -->
                        <div class="swiper-slide">
                            <div class="single-slide">
                                <div class="rbt-card variation-01 rbt-hover">
                                    <div class="rbt-card-img">
                                        <a    href="<?php echo e($headerCourse->publish ? LaravelLocalization::localizeUrl('course/' . $headerCourse->{'link_'.$lang}) : '#'); ?>" class="thumbnail">
                                            <img src="<?php echo e(isset($headerCourse->image) ? Helper::uploadedImagesPath('courses/source', $headerCourse->image) : Helper::imageFilesPath('noimage.png')); ?>" alt="course">
                                        </a>
                                    </div>
                                    <div class="rbt-card-body">
                                        <div class="rbt-card-top">
                                            <div class="rbt-review">
                                                
                                            </div>
                                            <div class="rbt-bookmark-btn">
                                                <form action="<?php echo e(route('addWishlist')); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="course_id" value="<?php echo e($headerCourse->id); ?>">
                                                    <button type="submit" class="rbt-round-btn" title="Bookmark">
                                                        <i class="feather-bookmark"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </div>

                                        <h4 class="rbt-card-title">
                                                    <a href="<?php echo e($headerCourse->publish ? LaravelLocalization::localizeUrl('course/' . $headerCourse->{'link_'.$lang}) : '#'); ?>">
                                                        <h5 class="title"><?php echo e($headerCourse->{'name_' . $lang}); ?></h5>
                                                    </a>
                                                </h4>
        
                                                <ul class="rbt-meta">
                                                    <li><i class="feather-book"></i>
                                                        <?php echo e($headerCourse->category->{'name_' . $lang} ?? ''); ?>

                                                    </li>
                                                    <li>
                                                        <p class=' mb-3 rounded d-inline-block p-2 border 'style=' background: #f379241f;  color: #f37924;   border: 1px solid #f379245c !important; font-size: 13px;  padding: 3px 6px !important;'>
                                                           <i class="feather-user-plus"></i>
                                                            <?php echo e($headerCourse->type->{'name_'.$lang}); ?> 
                                                        </p>
                                                         
                                                    </li>
                                                </ul>
                                                
                                                <div class="leasson-students">
                                                    <div class="lesson">
                                                        <i class="feather-clock"></i>
                                                        <span><?php echo e(intval($headerCourse->duration).' '.__('home.hours')); ?></span>
                                                    </div>
                                                    <div class="lesson">
                                                        <i class="feather-calendar"></i>
                                                        <span>  <?php echo e(intval($headerCourse->overall_days).' '.__('home.days')); ?></span>
                                                    </div>
                                                </div>
                                        <div class="rbt-card-bottom">
                                            <div class="rbt-price">
                                                 <?php if($headerCourse->publish): ?>
                                                <?php if($headerCourse->discount): ?>
                                                <span class="off-price">
                                                <?php echo e($headerCourse->last_price() . ' ' . __('home.SAR')); ?>  
                                            </span>
                                                <span class="current-price">
                                                <?php echo e($headerCourse->price . ' ' . __('home.SAR')); ?> 
                                            </span>
                                                <?php if(isset($headerCourse->discount->end_date)): ?>
                                                <div class="clock-area">
                                                    <i class="ms-1 fa-light fa-clock"></i>
                                                    <?php
                                                    $end_date = \Carbon\Carbon::parse($headerCourse->discount->end_date);
                                                    $daysLeft = \Carbon\Carbon::now()->diffInDays($end_date);
                                                    ?>
                                                    <span class="text-danger"><?php echo e($daysLeft); ?> <?php echo app('translator')->get('home.Day left at this price!'); ?></span>
                                                </div>
                                                <?php endif; ?>
                                                <?php else: ?>
                                                <div class="current-price">
                                                    <?php echo e($headerCourse->last_price() . ' ' . __('home.SAR')); ?>

                                                </div>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <span class="current-price">
                                                <?php echo e(__('home.soon')); ?>  
                                            </span>
                                            <?php endif; ?>
                                            </div>
                                            <a class="rbt-btn-link" href="<?php echo e(LaravelLocalization::localizeUrl('course/' . $headerCourse->{'link_'.$lang})); ?>"><?php echo e(__('home.Learn_More')); ?><i class="feather-arrow-right"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <div class="rbt-swiper-pagination"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Banner Area -->  
<?php endif; ?><?php /**PATH /home/academybadertech/public_html/resources/views/website/home-partials/sliders.blade.php ENDPATH**/ ?>