
<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_chapter')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.chapters')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('chapters.index')); ?>"><?php echo e(trans('home.chapters')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_chapter')); ?></li>
            </ol>
        </div>
    </div>
        <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e(trans('home.edit')); ?></h4>
                    </div>
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                <?php echo Form::open(['method'=>'PATCH','url' => 'admin/chapters/'.$chapter->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                                    <div class="row">


                                        <div class="col-md-3 mb-3">
                                            <label for="name_en"><?php echo e(trans('home.name_en')); ?></label>
                                            <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.name_en')); ?>" value="<?php echo e($chapter->name_en); ?>" name="name_en" required>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="name_ar"><?php echo e(trans('home.name_ar')); ?></label>
                                            <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.name_ar')); ?>" value="<?php echo e($chapter->name_ar); ?>" name="name_ar" required>
                                        </div>


                                        <div class="col-md-3 mb-3">
                                            <label for="level_id"><?php echo e(trans('home.course')); ?></label>
                                            <select class="form-control" data-trigger name="course_id">
                                                <option value="" ><?php echo e(trans('home.choose_course')); ?></option>
                                                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($course->id); ?>" <?php echo e($course->id==$chapter->course_id?'selected':''); ?>><?php echo e($course->{'name_'.$lang}); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="duration"><?php echo e(trans('home.duration')); ?></label>
                                            <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.duration')); ?>" name="duration" value="<?php echo e($chapter->duration); ?>" required>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="order"><?php echo e(trans('home.order')); ?></label>
                                            <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.order')); ?>" name="order" value="<?php echo e($chapter->order); ?>" required>
                                        </div>
                                   
                                    </div>

                                    <div class="row">
                                        <div class="form-group col-4">                                            
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch" switch="success" <?php echo e($chapter->status?'checked':''); ?>/>
                                                <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                                <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                            </div>
                                        </div>
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                        <a href="<?php echo e(url('/admin/courses')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                    </div>


                                <?php echo Form::close(); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/chapters/editChapter.blade.php ENDPATH**/ ?>