<?php

use Illuminate\Support\Facades\Route;

Route::get('allcontacts',function(){
    return view('website.allcontacts');
});

Route::post('edfapayCallback',function() {
    dd($_POST);
});
// Route::get('/savnskdfnv',function() {
//     \Artisan::call('optimize:clear');
//     return 'ok';
// });

Route::group(['middleware'=>['auth','web','LangRedirection','localeSessionRedirect', 'localizationRedirect', 'localeViewPath'],'prefix' => LaravelLocalization::setLocale()] ,function () {

    Route::post('/prepare-checkout', 'PaymentController@prepareCheckout')->name('repare-checkout');
    Route::get('/checkout-call-back/{training}/{type}', 'PaymentController@checkoutCallback')->name('checkout-call-back');


    Route::get('/ziad', function () {
        return view('website.student.dashboard');
    })->name('ziad');
    Route::get('profile','UserBoardController@profile')->name('profile');
    Route::get('check-out','CheckoutController@checkOut')->name('check-out');
    Route::post('updateProgress','UserBoardController@updateProgress')->name('updateProgress');
    Route::post('getMyCertificate','UserBoardController@getMyCertificate')->name('getMyCertificate');
    Route::post('submitExame/{exame_id}','UserBoardController@submitExame')->name('submitExame');
    
    Route::post('addWishlist','UserBoardController@addWishlist')->name('addWishlist');
    Route::post('addToCart','UserBoardController@addToCart')->name('addToCart');
    Route::post('cartDelete','UserBoardController@cartDelete')->name('cartDelete');
    
    Route::get('cart','UserBoardController@cart')->name('cart');
    Route::get('wishlist','UserBoardController@wishlist')->name('wishlist');
    Route::get('orders','UserBoardController@myOrders')->name('orders');
    Route::post('wishlistDelete','UserBoardController@wishlistDelete')->name('wishlistDelete');

    Route::group(['prefix'=>'user'],function(){
        Route::get('settings','UserBoardController@settings')->name('settings');
        Route::post('updateMyAccount','UserBoardController@updateMyAccount')->name('updateMyAccount');
        Route::post('updateMyAccountPassword','UserBoardController@updateMyAccountPassword')->name('updateMyAccountPassword');

        Route::get('dashboard','UserBoardController@dashboard')->name('dashboard');
        Route::get('my-courses','UserBoardController@myCourses')->name('myCourses');
        Route::get('my-wishlist','UserBoardController@myWishlist')->name('myWishlist');
        Route::get('notification','UserBoardController@notification')->name('notification');
        Route::get('my-quizes','UserBoardController@myQuizes')->name('myQuizes');
        Route::get('certificates','UserBoardController@certificates')->name('certificates');
        Route::get('course/{course}','UserBoardController@watchCourse')->name('watchCourse');
        Route::get('lesson/{lesson}','UserBoardController@watchLesson')->name('watchLesson');
        Route::get('exame/{exame}','UserBoardController@getExame')->name('getExame');
        
        Route::get('my-webinars','UserBoardController@myWebinars')->name('myWebinars');
        Route::get('watch-webinar/{link}','UserBoardController@watchWebinar')->name('watchWebinar');
    });
});


// web site routes
Route::group(['middleware'=>['web','localeSessionRedirect','LangRedirection', 'localizationRedirect', 'localeViewPath'],
    'prefix' => LaravelLocalization::setLocale() ],function(){
        $lang = \LaravelLocalization::getCurrentLocale();
    Route::get('/sitemap.xml','SiteMapController@index');
    Route::get('/services-sitemap.xml','SiteMapController@services');
    Route::get('/courses-sitemap.xml','SiteMapController@courses');
    Route::get('/categories-sitemap.xml','SiteMapController@categories');
    Route::get('/serviceCategories-sitemap.xml','SiteMapController@serviceCategories');
    Route::get('/fields-sitemap.xml','SiteMapController@fields');
    Route::get('/blogs-sitemap.xml','SiteMapController@blogs');
    Route::get('/news-sitemap.xml','SiteMapController@news');
    
    
    Route::get('/robots.txt', function () {
            return response(file_get_contents(public_path('robots.txt')), 200)
                ->header('Content-Type', 'text/plain');
        });

    Route::get('/lang/{lang}', 'AdminController@setlang');

    Route::get('/','WebsiteController@home')->name('home');


    Route::get('/courses','WebsiteController@getCourses')->name('courses');
    Route::get('/course/{course}','WebsiteController@getCourse')->name('course.show');
    Route::get('/categories','WebsiteController@getCategories');
    Route::get('/webinars','WebsiteController@webinarsPage');
    
    Route::get('/category/{link}','WebsiteController@getCategoryCourses');
    Route::get('category/{link}/blogs','WebsiteController@getCategoryBlogs');
    // Route::get('blogs/{link}','WebsiteController@getCategoryBlogs');
    Route::get('category/{link}/news','WebsiteController@getCategoryNews');
    Route::get('news/{link}','WebsiteController@getCategoryNews');
    Route::get('category/{link}/services','WebsiteController@getCategoryServices');
    Route::get('services/{link}','WebsiteController@getCategoryServices');

    Route::get('searchAutoComplete','WebsiteController@autoCompletesearch');
    Route::get('searchResult','WebsiteController@searchResult');
    
    Route::get('about-us','WebsiteController@aboutUs')->name('about-us');
    Route::get('companies-requests','WebsiteController@companiesRequests');
    Route::get('contact-us','WebsiteController@contactUs')->name('contact-us');
    Route::post('save/contact-us','WebsiteController@saveContactUs');
    Route::post('save/company-request','WebsiteController@saveCompanyRequest');
    Route::post('/save-course-subscriber-form', 'WebsiteController@saveCourseSubscriberRequest')->name('save_course_subscriber_request');
    Route::post('/save-webinar-subscriber-form', 'WebsiteController@saveWebinarSubscriberRequest')->name('save_webinar_subscriber_request');
    Route::get('page/{link}','WebsiteController@getPage');


    Route::get('levels/{link}','WebsiteController@getServiceDetails');
    Route::get('blogs/{link}','WebsiteController@getBlogPage');
    Route::get('new/{link}','WebsiteController@getNewsPage');
    Route::get('brand/{link}','WebsiteController@getBrandPage');
    Route::get('about-writer/{id}','WebsiteController@getWriter')->name('writer.details');
    Route::get('all-services/{category?}','WebsiteController@getservices')->name('front.services');
    Route::get('galleryImages','WebsiteController@getGalleryImages');
    Route::get('blogs','WebsiteController@getBlogs');
    Route::get('news/{link?}','WebsiteController@getNews');
    Route::get('brands','WebsiteController@getBrands');
    Route::get('galleryVideos','WebsiteController@getGalleryVideos');
    Route::post('save/comment','WebsiteController@saveComment');



    Route::get('products','WebsiteController@getProjects');
    Route::get('developer/{link}/projects','WebsiteController@getDeveloperProjects');
    Route::get('category/{link}/projects','WebsiteController@getCategoryProjects');
    Route::get('recommended/projects','WebsiteController@getRecommendedProjects');
    Route::get('project/{link}','WebsiteController@getProductDetails');
    Route::get('search-for','WebsiteController@projectsSearchResults');
    Route::post('save-career-application','WebsiteController@saveCareerApplication');

    Route::get('searchAutoComplete2','WebsiteController@autoCompletesearch2')->name('auto-complete');
    Route::post('save/training-applications','WebsiteController@saveTrainingApplications');

    Route::get('/validate-certificate','WebsiteController@validateCertificate');
    Route::post('/checkCertificate','WebsiteController@checkCertificate')->name('checkCertificate');
    Route::get('/certificate/{certificateCode}','WebsiteController@viewCertificate');
});


Route::get('paymob_txn_response_callback','PlaceOrderController@payMobCallback');
Route::group(['middleware'=>['web','auth','localeSessionRedirect','LangRedirection', 'localizationRedirect', 'localeViewPath']],function(){
    
    Route::post('placeOrder','PlaceOrderController@placeOrder')->name('placeOrder');
    Route::get('order/{id}/completed','PlaceOrderController@orderComplete');
    Route::get('order-checkOut','UserBoardController@checkOut');
});



Route::group(['middleware'=>['admin','web','localeSessionRedirect','LangRedirection', 'localizationRedirect', 'localeViewPath'],'prefix'=>LaravelLocalization::setLocale()],function(){
    Route::prefix('admin/')->group(function() {

        Route::get('/certificate_serial', 'StudentController@certificate_serial');
        Route::get('/', 'AdminController@admin')->name('admin');
        Route::get('/wad-requests', 'AdminController@wadRequest')->name('admin_wad_requests');

        Route::get('instructor-survey/{id}', 'TrainingController@getInstructorSurvey')->name('get.instructor.survey');
        Route::post('submit-instructor-survey', 'TrainingController@submitInstructorSurvey')->name('submit_instructor_survay');
        Route::resource('/categories', 'CategoryController');
        Route::get('/marketing-program-requests', 'AdminController@marketingProgramRequest')->name('admin_marketing_program_requests');
        
        Route::get('/companies-requests', 'AdminController@CompanyRequest')->name('admin_companies_requests');
        
        Route::get('/course-subscribers-requests', 'AdminController@CourseSubscriberRequest')->name('admin_course_subscribers_requests');
        Route::get('/webinar-subscribers-requests', 'AdminController@WebinarSubscriberRequest')->name('admin_webinar_subscribers_requests');
        
        
        Route::get('translations', 'AdminController@translations');
        Route::get('/switch-theme', 'AdminController@switchTheme');
        Route::post('{name}/up/{ids}','AdminController@updatestatus');
        Route::post('getRegions','AdminController@getRegions');
        Route::post('getAreas','AdminController@getAreas');
        Route::resource('/writers', 'WriterController');
        Route::resource('pages', 'PageController');
        Route::resource('menus', 'MenuController');
        Route::resource('menu-items', 'MenuItemController');
        Route::post('menuTypeValue', 'MenuItemController@menuTypeValue')->name('menuTypeValue');
        Route::resource('sliders', 'SliderController');
        Route::resource('home-sliders', 'HomeSliderController');
        Route::resource('services', 'ServiceController');
        Route::post('services/uploadImages', 'ServiceController@uploadImages');
        Route::post('services/removeUploadImages', 'ServiceController@removeUploadImages');
        Route::post('services/deleteImege', 'ServiceController@deleteImege');
        Route::post('services/storeFaq', 'ServiceController@storeFaq')->name('storeServiceFaq');
        Route::post('services/updateFaq', 'ServiceController@updateFaq')->name('updateServiceFaq');
        Route::post('services/removeFaq', 'ServiceController@removeFaq')->name('removeServiceFaq');
        Route::get('editAbout','AboutController@editAbout')->name('admin.editAbout');
        Route::PATCH('about/update','AboutController@update')->name('admin.about.update');
        Route::get('editWhyChooseUs','WhyChooseUsController@editWhyChooseUs')->name('admin.editWhyChooseUs');
        Route::PATCH('whyChooseUs/update','WhyChooseUsController@update')->name('admin.whyChooseUs.update');
        Route::post('menuTypeValue', 'MenuItemController@menuTypeValue')->name('menuTypeValue');
        Route::resource('aboutStrucs', 'AboutStrucController');
        Route::resource('whyChooseUsStruct', 'WhyChooseUsStructController');
        Route::resource('contact-us-messages', 'ContactusController');
        Route::resource('seo-assistant', 'SeoAssistantContoller');
        Route::resource('pages', 'PageController');
        Route::resource('service-categories', 'ServiceCategoryController');
        
        Route::resource('blog-categories', 'BlogCategoryController');
        Route::resource('blog-items', 'BlogItemController');
        Route::post('blog-items/storeFaq', 'BlogItemController@storeFaq')->name('storeBlogFaq');
        Route::post('blog-items/updateFaq', 'BlogItemController@updateFaq')->name('updateBlogFaq');
        Route::post('blog-items/removeFaq', 'BlogItemController@removeFaq')->name('removeBlogFaq');
        
        Route::resource('news-categories', 'NewsCategoryController');
        Route::resource('news-items', 'NewsItemController');
        Route::post('news-items/storeFaq', 'NewsItemController@storeFaq')->name('storeNewsFaq');
        Route::post('news-items/updateFaq', 'NewsItemController@updateFaq')->name('updateNewsFaq');
        Route::post('news-items/removeFaq', 'NewsItemController@removeFaq')->name('removeNewsFaq');
        
        Route::resource('gallery-images', 'GalleryImageController');
        Route::post('gallery-images/deleteImege', 'GalleryImageController@deleteImege');
        Route::post('gallery-images/reorder','GalleryImageController@reorderImeges');
        Route::get('gallery-image/create-pluck','GalleryImageController@createPluck');
        Route::post('gallery-images/uploadImages','GalleryImageController@uploadImages');
        Route::post('gallery-images/removeUploadImages','GalleryImageController@removeUploadImages');
        Route::post('gallery-images/storePluck','GalleryImageController@storePluck');
        Route::resource('testimonials', 'TestimonialController');
        Route::resource('teams', 'TeamController');
        Route::resource('news-letters', 'NewsLetterController');
        Route::resource('gallery-videos', 'GalleryVideoController');
        Route::post('gallery-videos/reorder','GalleryVideoController@reorderVideos');
        Route::resource('brands', 'BrandController');
        Route::resource('partners_front', 'PartnerFrontController');
        Route::resource('faqs', 'FaqController');
        Route::get('editFaq', 'FaqController@editFaq');
        Route::post('storeGeneralFaq', 'FaqController@storeFaq')->name('storeGeneralFaq');
        Route::post('updateGeneralFaq', 'FaqController@updateGeneralFaq')->name('updateGeneralFaq');
        Route::post('removeGeneralFaq', 'FaqController@removeGeneralFaq')->name('removeGeneralFaq');


        Route::resource('fields', 'TrainingFieldController');
        Route::resource('center_halls', 'HallController');
        Route::resource('centers', 'CenterController');

        Route::post('delete_responsible_question', 'CenterController@delete_responsible_question')->name('delete_responsible_question');
        Route::post('viewresponsible', 'CenterController@viewresponsible')->name('viewresponsible.show');
        Route::post('editresponsible', 'CenterController@editresponsible')->name('editresponsible.show');
        Route::post('updateResponsible', 'CenterController@updateResponsible')->name('updateResponsible');

        Route::post('centers-import-excel', 'CenterController@importExcel')->name('center.import.excel');
        Route::resource('countries', 'CountryController');
        Route::resource('regions', 'RegionController');
        Route::resource('areas', 'AreaController');
        // --------------------  course features -------------------
        Route::get('/course-features', 'CourseFeaturesController@index');
        Route::patch('/course-features', 'CourseFeaturesController@update');
        Route::post('/course-features-update-item', 'CourseFeaturesController@updateCourseFeatureItem')->name('updateCourseFeatureItem');
        Route::post('/course-features-remove-item', 'CourseFeaturesController@removeCourseFeature')->name('removeCourseFeature');
        
        // --------------------  Chapters -------------------
        Route::resource('/chapters', 'ChapterController');
        Route::get('/chapters/{course_id}/lessons', 'ChapterController@chapter_lessons');
        
        Route::get('/courses/{course_id}/chapters', 'CourseController@course_chapters');
        Route::post('/courses/getChapters', 'CourseController@getChapters')->name('getChapters');
        
//------------------------ Courses & Lessons --------------------
        Route::resource('courses', 'CourseController');
        Route::resource('lessons', 'LessonController');
        Route::resource('/attachments', 'AttachmentController');
        Route::post('addFaq', 'LessonController@addFaq')->name('addFaq');
        Route::post('editquestion', 'LessonController@editquestion')->name('editquestion.show');
        Route::post('updateFaq', 'LessonController@updateFaq')->name('updateFaq');
        Route::post('removeFaq', 'LessonController@removeFaq')->name('removeFaq');
//------------------------ Exams & Questions --------------------
        Route::resource('exames', 'ExameController');
        Route::resource('questions', 'ExameQuestionsController');
        Route::post('delete_answer_question', 'ExameQuestionsController@delete_answer_question')->name('delete_answer_question');
        Route::post('editanswer', 'ExameQuestionsController@editanswer')->name('editanswer.show');
        Route::post('updateAnswer', 'ExameQuestionsController@updateAnswer')->name('updateAnswer');
        Route::get('exame-results','ExameController@exame_results')->name('exame_results');
        Route::get('exame-results/{training_id}','ExameController@exame_results_details')->name('exame_results_details');
//------------------------ Parters --------------------
        Route::resource('partners', 'PartnerController');


        Route::get('partners_requests', 'PartnerController@partners_requests')->name('partners_requests');
        Route::delete('partners_requests/{id}', 'PartnerController@destroy');
        Route::delete('partners-centers-delete/{id}', 'PartnerController@destroyPartner')->name('partners_centers_delete');
        Route::post('partners_requests_change_status', 'PartnerController@partners_requests_change_status');
        Route::post('partners_training_edit_requests_change_status', 'PartnerController@partners_training_edit_requests_change_status');

        Route::post('get-request-data','PartnerController@getRequestData');
        Route::get('partners-training-requests', 'PartnerController@partners_training_requests')->name('partners_training_requests');
        Route::delete('partners-training-requests/{id}', 'PartnerController@destroyTrainingRequest');
        Route::post('partner_training_request_details', 'PartnerController@partner_training_request_details')->name('partner_training_request_details');
        Route::post('my_training_request_details', 'PartnerController@my_training_request_details')->name('my_training_request_details');
        Route::post('partners_training_requests_change_status', 'PartnerController@partners_training_requests_change_status');


        // partner see and save its requests for training
        Route::post('save_partners_training_request', 'PartnerController@save_partners_training_request')->name('save_partners_training_request');
        Route::post('edit_partners_training_request', 'PartnerController@edit_partners_training_request')->name('edit_partners_training_request');
        Route::get('my-training-request', 'PartnerController@my_training_request')->name('my_training_request');


        Route::get('assign_partner_to_center', 'PartnerController@assign_partner_to_center')->name('assign_partner_to_center');
        Route::post('assign_partner_to_center_action', 'PartnerController@assign_partner_to_center_action')->name('assign_partner_to_center_action');

//------------------------ students --------------------
        Route::resource('students', 'StudentController');
        Route::get('assign_student', 'StudentController@assign_student')->name('assign_student');
        Route::post('assign_student', 'StudentController@assign_student_store')->name('assign_student.store');
        Route::get('un_assign_student', 'StudentController@un_assign_student')->name('un_assign_student');
        Route::post('un_assign_student_remove', 'StudentController@un_assign_student_remove')->name('un_assign_student.delete');
        Route::get('students_per_training', 'StudentController@students_per_training')->name('students_per_training');
        Route::post('change_view_certificate', 'StudentController@change_view_certificate')->name('change_view_certificate');
        Route::post('generate_certificates', 'StudentController@generate_certificates')->name('generate_certificates');

//------------------------ students Requests --------------------
        Route::resource('student_requests', 'StudentRequestController');
        Route::post('student_requests_accept', 'StudentRequestController@student_requests_accept')->name('student_requests.accept');

//------------------------ instructors --------------------
        Route::resource('teachers', 'TeacherController');
        Route::resource('instructors', 'InstructorController');
        Route::get('instructors-filter/{center_id?}', 'InstructorController@index')->name('instructors.index');
        Route::get('assign_instructor', 'InstructorController@assign_instructor')->name('assign_instructor');
        Route::post('assign_instructor', 'InstructorController@assign_instructor_store')->name('assign_instructor.store');
        Route::get('un_assign_instructor', 'InstructorController@un_assign_instructor')->name('un_assign_instructor');
        Route::post('un_assign_instructor_remove', 'InstructorController@un_assign_instructor_remove')->name('un_assign_instructor.delete');
        Route::get('instructors_per_training', 'InstructorController@instructors_per_training')->name('instructors_per_training');
//------------------------ schedules --------------------
        Route::post('viewtrainings', 'StudentController@viewTrainings')->name('viewtrainings.show');
        Route::post('viewtrainings2', 'StudentController@viewTrainings2')->name('viewtrainings2.show');
        Route::get('schedule_students/{training_id?}', 'StudentController@schedule_students')->name('schedule_students');
        Route::get('schedule_centers/{center_id?}', 'CenterController@schedule_centers')->name('schedule_centers');
        Route::get('schedule_users/{type?}', 'UserController@schedule_users')->name('schedule_users');
//------------------------ attendance --------------------
        Route::resource('attendances', 'TrainingAttendanceController');
        Route::post('attend_students', 'TrainingAttendanceController@attend_students')->name('attend_students');
        
        Route::get('attendance-sheet/{training_id}', 'TrainingAttendanceController@attendanceSheet')->name('attendanceSheet');
        
        Route::post('delete_attend', 'TrainingAttendanceController@delete_attend')->name('delete_attend');
        Route::post('attendance_details', 'TrainingAttendanceController@attendance_details')->name('attendance_details');
        Route::post('attendance_attachments', 'TrainingAttendanceController@attendance_attachments')->name('attendance_attachments');
        Route::post('attachment_change_rate', 'TrainingAttendanceController@attachmentChangeRate')->name('attachment_change_rate');
        Route::delete('delete_attendance_attachments/{id}', 'TrainingAttendanceController@delete_attendance_attachment')->name('delete_attendance_attachment');
        
        Route::post('/export-attendance','TrainingAttendanceController@export_attendance')->name('export-attendance');

        Route::resource('surveys_results', 'SurveyResultController');
        Route::get('surveys_results/{id}/{training_id}', 'SurveyResultController@show')->name('surveys_results.showResults');
        Route::resource('surveys', 'SurveyController');
        Route::post('updateSurveyQuestion', 'SurveyController@updateSurveyQuestion')->name('updateSurveyQuestion');
        Route::post('removeSurveyQuestion', 'SurveyController@removeSurveyQuestion')->name('removeSurveyQuestion');

        Route::resource('settings', 'SettingController');
        Route::resource('configrations', 'ConfigrationController');
        Route::resource('users', 'UserController');
        Route::resource('roles', 'RoleController');
        Route::resource('permissions', 'PermissionController');
  
        Route::resource('course_attachments', 'CourseAttachmentController');
        Route::get('course_attachments/index/{id}', 'CourseAttachmentController@index')->name('course_attachments.index');
        Route::get('course_attachments/create/{id}', 'CourseAttachmentController@create')->name('course_attachments.create');
        Route::resource('course_lessons', 'CourseLessonController');
        Route::get('course_lessons/index/{id}', 'CourseLessonController@index')->name('course_lessons.index');
        Route::get('course_lessons/create/{id}', 'CourseLessonController@create')->name('course_lessons.create');
        Route::resource('course_videos', 'CourseVideoController');
        Route::get('course_videos/index/{id}', 'CourseVideoController@index')->name('course_images.index');
        Route::get('course_videos/create/{id}', 'CourseVideoController@create')->name('course_images.create');
        Route::resource('course_images', 'CourseImageController');
        Route::get('course_images/index/{id}', 'CourseImageController@index')->name('course_images.index');
        Route::get('course_images/create/{id}', 'CourseImageController@create')->name('course_images.create');
        Route::resource('course_tools', 'CourseToolController');
        Route::get('course_tools/index/{id}', 'CourseToolController@index')->name('course_tools.index');
        Route::get('course_tools/create/{id}', 'CourseToolController@create')->name('course_tools.create');
        Route::resource('course_elements', 'CourseElementController');
        Route::get('course_elements/index/{id}', 'CourseElementController@index')->name('course_elements.index');
        Route::get('course_elements/create/{id}', 'CourseElementController@create')->name('course_elements.create');
        Route::resource('course_requirements', 'CourseRequirementController');
        Route::get('course_requirements/index/{id}', 'CourseRequirementController@index')->name('course_requirements.index');
        Route::get('course_requirements/create/{id}', 'CourseRequirementController@create')->name('course_requirements.create');
        Route::resource('surveys', 'SurveyController');
        Route::resource('examquestions', 'ExamQuestionController');
        Route::resource('examcategories', 'ExamCategoryController');

        Route::post('student-import-excel', 'StudentController@importExcel')->name('student.import.excel');
        Route::post('trainings-import-excel', 'TrainingController@importExcel')->name('trainings.import.excel');
        Route::post('courses-import-excel', 'CourseController@importExcel')->name('courses.import.excel');
        
        Route::post('surveys-import-excel', 'SurveyResultController@importExcel')->name('surveys.import.excel');
        
        Route::resource('trainings', 'TrainingController');
        
        Route::post('getCenterHalls','TrainingController@getCenterHalls');
        Route::post('getHallDetails','TrainingController@getHallDetails');
        
        // --------------------  Webinars -------------------
        Route::resource('/webinars', 'EventController');
        
        // Reports
        Route::get('all-reports','ReportController@allReports')->name('all_reports');
        Route::get('job-seekers-reports','ReportController@jobSeekersReports')->name('job_seekers_reports');
        
        Route::get('center-report','ReportController@centerReportView');
        Route::post('center-report-stats','ReportController@centerReportStatistics');
        Route::post('center-report-result','ReportController@centerReportResult');
        
        Route::get('course-report','ReportController@courseReportView');
        Route::post('course-report-stats','ReportController@courseReportStatistics');
        Route::post('course-report-result','ReportController@courseReportResult');
        
        // messages
        Route::get('messages','MessageController@index')->name('messages');
        Route::post('send-whatsapp-messages','MessageController@sendWhatsappMessages')->name('sendWhatsappMessages');
        Route::post('send-sms-messages','MessageController@sendSMSMessages')->name('sendSMSMessages');
        Route::post('send-emails','MessageController@sendEmails')->name('sendEmails');
        
        Route::post('student_generate_certificates2', 'StudentController@generate_certificates_for_students_monitor')->name('student_generate_certificates2');
        
        Route::prefix('/crm')->group(function() {
            
            Route::prefix('/crm-employess')->group(function() {
                Route::get('targets','CrmTargetController@index');
                Route::get('targets/create','CrmTargetController@create');
                Route::get('targets/{target}','CrmTargetController@show');
                Route::get('targets/{target}/delete','CrmTargetController@delete');
                Route::post('targets/store','CrmTargetController@store')->name('targets.store');
                Route::post('targets/{target}/update','CrmTargetController@update')->name('targets.update');
                
                Route::get('/','CrmEmployeeController@index');
                Route::get('create','CrmEmployeeController@create');
                Route::get('show/{user}','CrmEmployeeController@show');
                Route::post('store','CrmEmployeeController@store');
                Route::post('{user}/update','CrmEmployeeController@update')->name('targets.update');
                Route::Delete('{user}','CrmEmployeeController@delete');
                
                
            });
            
            
            
            
            Route::get('/','CrmController@crmHome')->name('crmHome');
            
            // admin tasks to employee
            Route::get('/add-employee-task','CrmController@add_employee_task')->name('add_employee_task');
            Route::post('/store-employee-task','CrmController@store_employee_task')->name('store_employee_task');
            Route::get('/employee-tasks','CrmController@employee_tasks')->name('employee_tasks');
            
            
            //----------------single CLient
            Route::get('clients','CrmController@clients')->name('crm_clients');
            Route::get('clients/{client}','CrmController@client_details');
            Route::get('clients/{client}/edit','CrmController@client_edit');
            Route::post('clients/{client}/update','CrmController@client_update')->name('client_update');
            Route::post('clients/meeting/result','CrmController@save_meeting_result')->name('save_meeting_result');
            Route::post('clients/delete/{clients}','CrmController@client_delete')->name('client_delete');
            
            Route::get('my_tasks','CrmController@my_tasks');
            Route::get('my_tasks/{task}/completed','CrmController@make_task_comlpeted')->name('make_task_comlpeted');
            Route::post('delay_task','CrmController@delay_task')->name('delay_task');
            Route::get('my-meetings','CrmController@my_meetings');
            
            Route::get('financial','CrmController@financial');
            
            Route::post('clients/{client}/send_sms','CrmController@send_sms');
            
            Route::post('clients/{client}/save_payment','CrmController@save_payment')->name('save_payment');
            Route::post('clients/send_sms/delete','CrmController@delete_crm_sms')->name('delete_crm_sms');
            Route::get('add-client/single','CrmController@addsingleClient');
            Route::get('add-clientToCompany','CrmController@addClientCompany');
            Route::post('add-client/single','CrmController@store_single_Client')->name('store_single_Client');
            Route::get('client-training/{crm_company_training}/delete','CrmController@delete_training')->name('delete_training');
            
            
            
            //----------------single company
            Route::get('companies','CrmController@companies');
            Route::post('add-company/single','CrmController@store_single_Company')->name('store_single_Company');
            Route::get('companies/{company}','CrmController@company_details')->name('company_details');
            Route::get('add-company/single','CrmController@addsingleCompany');
            Route::get('companies/{company}/edit','CrmController@company_edit');
            Route::post('companies/{company}/update','CrmController@company_update')->name('company_update');
            
            //----------------add cleint to company
            Route::get('add-company-client/{company}','CrmController@addCompanyClient');
            Route::post('add-company-client','CrmController@store_company_Client')->name('store_company_Client');
            
            Route::get('reports','CrmController@get_report_options');
            Route::get('report/{type}','CrmController@get_reports');
            Route::get('reports/details','CrmController@get_report_detials');
            
            
            //----------------invoices
            Route::get('invoice/{invoice}','CrmController@invoice_details')->name('invoice_details');
            Route::post('invoice-store','CrmController@invoice_store')->name('invoice_store');
            Route::get('delete_invoice/{invoice}','CrmController@delete_invoice')->name('delete_invoice');
            Route::get('delete_invoice_item/{invoice}','CrmController@delete_invoice_item')->name('delete_invoice_item');
            Route::post('edit-discount/{invoice}','CrmController@edit_discount')->name('edit_discount');
            
            //----------------import excel
            Route::post('import-clients','CrmController@import_clients')->name('crm_client.upload');
            Route::post('import-companies','CrmController@import_companies')->name('crm_company.upload');
        });
        
        
    });
});

    Route::post('/getRegions','WebsiteController@getRegions');
 Route::post('/getAreas','WebsiteController@getAreas');

Route::group(['middleware'=>['student','web','localeSessionRedirect', 'localizationRedirect', 'localeViewPath'],'prefix'=>LaravelLocalization::setLocale()],function(){
    Route::prefix('/student')->group(function() {

        Route::get('/', 'StudentBoardController@index')->name('index');
        // ---------------- student trainings ---------------
        Route::post('my_trainings', 'StudentBoardController@my_trainings')->name('my_trainings');    // return student trainings 
        Route::get('watch_training/{training_id}', 'StudentBoardController@watch_training')->name('watch_training');   // return student specific trainings
        Route::get('watch_course/{course_id}', 'StudentBoardController@watch_course')->name('watch_course');     // return student specific Course data
        Route::post('submit_exame', 'StudentBoardController@submit_exame')->name('submit_exame');         // submit exame
        Route::post('submit_survay', 'StudentBoardController@submit_survay')->name('submit_survay');         // submit survay
        Route::get('course/{course_code}/lesson/{lesson_id}', 'StudentBoardController@lesson_videos')->name('lesson_videos');         // watching videos of lessons
                   
        Route::get('training/{id}/attendance', 'StudentBoardController@attend_me');               // attend myself
        // ---------------- student register in training ---------------
        Route::post('register_training', 'StudentBoardController@register_training')->name('register_training');
        // ---------------- update student profiel  ---------------
        Route::post('update/accountSetting','StudentBoardController@updateAccountSetting');
        Route::post('student_generate_certificates', 'StudentBoardController@generate_certificates')->name('student_generate_certificates');
    });
});

    

Route::group(['middleware' => [ 'web', 'localeSessionRedirect', 'localizationRedirect','LangRedirection', 'localeViewPath'],'prefix' => LaravelLocalization::setLocale()], function() {
    Auth::routes();

    Route::get('/wad-form', 'WebsiteController@createWadRequests')->name('wad_form');
    Route::post('/save-wad-form', 'WebsiteController@saveWadRequest')->name('save_wad_request');
    
    Route::get('/job-seekers-training', 'WebsiteController@createMarketingProgramRequests')->name('marketing_program_form');
    Route::post('/save-marketing-program-form', 'WebsiteController@saveMarketingProgramRequest')->name('save_marketing_program_request');
    
    Route::get('/permission-denied', 'WebsiteController@un_active');
    
    Route::post('save/contact-us','WebsiteController@saveContactUs');
    Route::get('courses/{field_link}', 'WebsiteController@get_field_trainings')->name('courses.field');
    Route::get('get-trainings', 'WebsiteController@getTrainings');
    Route::get('training/{code}', 'WebsiteController@get_training_details');
    
    Route::get('certificate/{serial}', 'WebsiteController@getCertificate');
    Route::get('validate-certificate', 'WebsiteController@certificateValidation');
    Route::post('check-certificate', 'WebsiteController@checkCertificate');
    Route::get('{menu}',    'WebsiteController@menus');
    Route::post('/blogs-search','WebsiteController@blogSearch')->name('blogs_search');
    Route::get('/blogs-item/{id}','WebsiteController@getBlogItem')->name('getBlogItem');
    Route::post('/news-search','WebsiteController@newsSearch')->name('news_search');
    Route::get('/news-item/{id}','WebsiteController@getNewsItem')->name('getNewsItem');
    Route::get('/service/{link}','WebsiteController@getServiceItem')->name('getServiceItem');
    Route::get('company-survey/{id}', 'TrainingController@getCompanySurvey')->name('get.company.survey');
    Route::post('submit-company-survey', 'TrainingController@submitCompanySurvey')->name('submit_company_survay');
});


//////////// clearing cach and cache config///////
Route::get('/clear-cache', function() {
    $exitCode = Artisan::call('optimize:clear');
    return 'DONE'; //Return anything
});

Route::group(['middleware'=>['web','localeSessionRedirect', 'localizationRedirect','LangRedirection', 'localeViewPath'],'prefix' => LaravelLocalization::setLocale() ],function(){


    Route::get('webinars/{link}','WebsiteController@webinarDetails')->name('webinarDetails');
    Route::get('webinar-checkout/{link}','WebsiteController@webinarCheckout')->name('webinarCheckout');

    // Auth::routes();
    Route::get('{menu}', 'WebsiteController@menus');

    Route::post('save_NewsLetter',[WebsiteController::class,'save_NewsLetter'])->name('save_NewsLetter');
});



Route::get('languages',function(){abort(403);});
