@extends('layouts.app')
@section('title')
    <title>@lang('home.webinars')</title>
@endsection
@section('content')
    <!-- bread crumb area -->
    <div class="rts-bread-crumbarea-1 rts-section-gap bg_image">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-main-wrapper">
                        <h1 class="title">{{ __('home.webinars') }}</h1>
                        <!-- breadcrumb pagination area -->
                        <div class="pagination-wrapper">
                            <a href="{{ url('/') }}">@lang('home.home')</a>
                            <i class="fa-regular fa-chevron-right"></i>
                            <a class="active">{{ __('home.webinars') }}</a>
                        </div>
                        <!-- breadcrumb pagination area end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- rts blog area start -->
    @if (count($next_webinars) > 0)
        <div class="container">

            <div class="row">
                <div class="col-lg-12 m-3">
                    <div class="title-between-area">
                        <div class="title-area-left-style m-auto">
                            <h2 class="title"> @lang('home.Upcoming Webinars')</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container pb_md--100 pb_sm--80">
                <div class="infinite-scroll">
                    <div class="row g-5">
                    @foreach ($next_webinars as $next_webinar)
                        <div class="col-lg-4 col-md-6 col-sm-6 col-12">
                            <!-- single zoom meeting area start -->
                            <div class="single-zoom-meeting-area">
                                <a href="{{ LaravelLocalization::localizeUrl('webinars/' . $next_webinar->{'link_' . $lang}) }}"
                                    class="thumbnail">
                                    <img src="{{ isset($next_webinar->image) ? Helper::uploadedImagesPath('webinars/source', $next_webinar->image) : Helper::imageFilesPath('noimage.png') }}"
                                        alt="">
                                </a>
                                <div class="inner-content">
                                    <div class="head">
                                        <div class="single">
                                            <i class="fa-regular fa-calendar-lines-pen"></i>
                                            <span>{{ \Carbon\Carbon::parse($next_webinar->start_date)->format('F j, Y') }}</span>
                                        </div>
                                        {{--<div class="single">
                                            <i class="fa-light fa-clock"></i>
                                            <span>{{ \Carbon\Carbon::parse($next_webinar->start_date)->format(' g:i A') }}</span>
                                        </div>--}}
                                        @if($next_webinar->type)
                                            <div class="single">
                                                <i class="fa-light fa-clock"></i>
                                                <span>{{ trans('home.' . $next_webinar->type) }}</span>
                                            </div>
                                        @endif
                                    </div>
                                    <a
                                        href="{{ LaravelLocalization::localizeUrl('webinars/' . $next_webinar->{'link_' . $lang}) }}">
                                        <h5 class="title">{{ $next_webinar->{'name_'.$lang} }}</h5>
                                    </a>
                                    <div class="bottom">
                                        <div class="left">
                                            <span>@lang('home.price')</span>
                                        </div>
                                        <a>
                                            {{ $next_webinar->price == 0 ? __('home.free') : $next_webinar->price . ' ' . __('home.SAR') }}
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <!-- single zoom meeting area end -->
                        </div>
                    @endforeach
                    {{ $next_webinars->links() }}
                </div>
                </div>
            </div>
        </div>
    @else
        <div class="col-md-12 col-lg-12 col-xl-12 mb-3 text-center">
            <img  src="{{ Helper::imageFilesPath('no_data.png')}}"width="400" alt="no data image">
            <h4>{{trans('home.no data found in this page')}}</h4>
        </div>
    @endif
    @if (count($previous_webinars) > 0)
        <!-- rts blog area end -->
        <div class="container">

            <div class="row">
                <div class="col-lg-12 m-3">
                    <div class="title-between-area">
                        <div class="title-area-left-style m-auto">
                            <h2 class="title"> @lang('home.Previous Webinars')</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container pb_md--100 pb_sm--80">
                <div class="infinite-scroll">
                    <div class="row g-5">
                    @foreach ($previous_webinars as $previous_webinar)
                        <div class="col-lg-4 col-md-6 col-sm-6 col-12">
                            <!-- single zoom meeting area start -->
                            <div class="single-zoom-meeting-area">
                                <a href="{{ LaravelLocalization::localizeUrl('webinars/' . $previous_webinar->{'link_' . $lang}) }}"
                                    class="thumbnail">
                                    <img src="{{ isset($previous_webinar->image) ? Helper::uploadedImagesPath('webinars/source', $previous_webinar->image) : Helper::imageFilesPath('noimage.png') }}"
                                        alt="">
                                </a>
                                <div class="inner-content">
                                    <div class="head">
                                        <div class="single">
                                            <i class="fa-regular fa-calendar-lines-pen"></i>
                                            <span>{{ \Carbon\Carbon::parse($previous_webinar->start_date)->format('F j, Y') }}</span>
                                        </div>
                                        <div class="single">
                                            <i class="fa-light fa-clock"></i>
                                            <span>{{ \Carbon\Carbon::parse($previous_webinar->start_date)->format(' g:i A') }}</span>
                                        </div>
                                    </div>
                                    <a
                                        href="{{ LaravelLocalization::localizeUrl('webinars/' . $previous_webinar->{'link_' . $lang}) }}">
                                        <h5 class="title">{{ $previous_webinar->{'name_'.$lang} }}</h5>
                                    </a>
                                   {{-- <div class="bottom">
                                        <div class="left">
                                            <span>@lang('home.price')</span>
                                        </div>
                                        <a>
                                            {{ $previous_webinar->price == 0 ? __('home.free') : $previous_webinar->price . ' ' . __('home.SAR') }}
                                        </a>
                                    </div>--}}
                                </div>
                            </div>
                            <!-- single zoom meeting area end -->
                        </div>
                    @endforeach
                    {{ $previous_webinars->links() }}
                </div>
                </div>
            </div>
        </div>
        <!-- rts blog area end -->
    @endif
    <div class="rts-section-gap"></div>


@endsection

@section('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jscroll/2.4.1/jquery.jscroll.min.js"></script>
    <script>
        $(document).ready(function() {
            $('nav[aria-label="Pagination Navigation"]').hide();
    
            var $scrollContainer;
            if (window.innerWidth <= 767) {
                $scrollContainer = $('.infinite-scroll'); // Mobile: Scroll container
            } else {
                $scrollContainer = $(window); // Desktop: Window scroll
            }
    
            var jscrollInstance = $('.infinite-scroll').jscroll({
                autoTrigger: true,
                loadingMsg: '<div class="loading"><b>Loading...</b></div>',
                padding: 0,
                nextSelector: 'nav[aria-label="Pagination Navigation"] a[rel="next"]',
                contentSelector: '.infinite-scroll .row',
                callback: function() {
                    var $container = $('.infinite-scroll');
                    var scrollHeightBeforeAppend = $container[0].scrollHeight;
                    var currentScrollTop = $container.scrollTop();
    
                    $('nav[aria-label="Pagination Navigation"]').remove();
    
                    if ($('nav[aria-label="Pagination Navigation"] a[rel="next"]').length === 0) {
                        jscrollInstance.destroy();
                    }
    
                    // Adjust scroll position to account for newly appended content
                    var scrollHeightAfterAppend = $container[0].scrollHeight;
                    var newContentHeight = scrollHeightAfterAppend - scrollHeightBeforeAppend;

                    if (window.innerWidth <= 767) {
                        $container.scrollTop(currentScrollTop + newContentHeight);
                    }
                }
            });
        });
</script>
@endsection
