@extends('layouts.app')
@section('title')
    <title>{{$webinar->{'name_'.$lang} }}</title>
@endsection
@section('content')
  <!-- bread crumb area -->
  <div class="rts-bread-crumbarea-1 rts-section-gap bg_image">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-main-wrapper">
                        <h3 class="title animated fadeIn">{{$webinar->{'name_'.$lang} }}</h3>
                        <!-- breadcrumb pagination area -->
                        <div class="pagination-wrapper">
                            <a href="{{url('/')}}">@lang('home.home')</a>
                            <i class="fa-regular fa-chevron-right"></i>
                            <a href="{{url('webinars')}}" >{{__('home.webinars')}}</a>
                            <i class="fa-regular fa-chevron-right"></i>
                            <a class="active" >{{$webinar->{'name_'.$lang} }}</a>
                        </div>
                        <!-- breadcrumb pagination area end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
     <!-- rts blog area start -->
     
     <!-- blog details area start -->
     <div class="rts-blog-list-area rts-section-gap">
        <div class="container">
            <div class="row g-5">
                <!-- rts blo post area -->
                <div class="col-xl-8 col-md-12 col-sm-12 col-12">
                    <!-- single post -->
                    <div class="blog-single-post-listing details mb--0">
                        <div class="thumbnail w-75 m-auto">
                            <img src="{{ isset($webinar->image) ? Helper::uploadedImagesPath('webinars/source',$webinar->image) : Helper::imageFilesPath('noimage.png') }}" alt="{{$webinar->alt_img}}">
                        </div>
                        <div class="blog-listing-content">
                            <div class="user-info">
                                <!-- single info -->
                                @if($webinar->speaker)
                                    <div class="single">
                                        <i class="far fa-user-circle"></i>
                                        <span>@lang('home.by') {{$webinar->speaker}}</span>
                                    </div>
                                @endif
                                <!-- single infoe end -->
                                <!-- single info -->
                                <div class="single mx-0">
                                    <i class="far fa-clock"></i>
                                    <span>{{ \Carbon\Carbon::parse($webinar->start_date)->format('F j, Y  g:i A') }}</span>
                                    <span class="mx-2">:</span>
                                    <span>{{ \Carbon\Carbon::parse($webinar->end_date)->format('F j, Y g:i A') }}</span>
                                </div>
                                <!-- single infoe end -->
                            </div>
                            <p class="">{!! $webinar->{'text_'.$lang} !!}</p>
                        {{--    <p class="disc para-1">{!! $webinar->{'text_'.$lang} !!}</p>  --}}
                            
                        </div>
                    </div>
                    <!-- single post End-->
                </div>
                <!-- rts-blog post end area -->
                
                <div class="col-xl-4 col-md-12 col-sm-12 col-12 rts-sticky-column-item">
                   <div class="right-course-details mt-0">
                        <!-- contact-form -->
                        <div class="course-side-bar mb-4">
                            
                                <div class="price-area  mt-1">
                                    <h3 class="title">
                                        {{ trans('home.subscribe_webinar') }}
                                    </h3>
                                   
                                </div>
                           
                                 <form class='contact-page-form' method="POST" action="{{ route('save_course_subscriber_request') }}" id="webinar-subscribe-form">
                                    @csrf
                                    <div class="single-input">
                                        <input name="full_name" id="name" type="text" value="{{ old('full_name') }}" placeholder="{{ trans('home.name') }} *" required>
                                        @error('full_name')
                                            <div class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </div>
                                        @enderror
                                    </div>
                                    <div class="single-input">
                                        <input name="email" id="email" type="email" value="{{ old('email') }}" placeholder="{{ trans('home.email') }} *" required>
                                        @error('email')
                                            <div class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </div>
                                        @enderror
                                    </div>
                                    <div class="single-input">
                                        <input name="phone" id="phone" type="text" value="{{ old('phone') }}" placeholder="{{ trans('home.phone') }} *" required>
                                        @error('phone')
                                            <div class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </div>
                                        @enderror
                                    </div>
                                    <div class="single-input">
                                        <select class="form-select" name="qualification" id="qualification" type="text" required>
                                            <option value=''>{{ trans('home.qualification') }}</option>
                                            <option @selected(old('qualification') == 'university') value="university">{{trans('home.university')}}</option>
                                            <option @selected(old('qualification') == 'diploma') value="diploma">{{trans('home.diploma')}}</option>
                                            <option @selected(old('qualification') == 'secondary') value="secondary">{{trans('home.secondary')}}</option>
                                        </select>
                                        @error('qualification')
                                            <div class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </div>
                                        @enderror
                                    </div>
                                    
                                     <div class="single-input">
                                        <input name="job" id="job" type="text" value="{{ old('job') }}" placeholder="{{ trans('home.job') }}">
                                        @error('job')
                                            <div class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </div>
                                        @enderror
                                    </div>
                                    <input type="hidden" name="webinar_id" value="{{ $webinar->id }}">
                                
                                    <button type="submit" class="rts-btn btn-border  contactUs">{{ trans('home.register_now') }}</button>
                                </form>
                            </div>
                        
                        <div class="course-side-bar">
                            <div class="price-area text-center my-0 justify-content-center">
                                <h3 class="title text-center">
                                     <small class='px-2 text-muted '>{{ trans('home.price') }}  : </small> {{ $webinar->price == 0 ? __('home.free') : $webinar->price . ' ' . __('home.SAR') }}
                                </h3>
                            </div>
                        </div>
 
                        </div>
                        <!-- contact-form -->
                </div> 
                
                <!--rts blog wizered area -->
                {{--<div class="col-xl-4 col-md-12 col-sm-12 col-12 rts-sticky-column-item">
                    <div class="blog-sidebar theiaStickySidebar">
                        <!-- single wizered start -->
                        <div class="rts-single-wized Categories">
                            <div class="wized-header">
                                <h5 class="title">
                                    @lang('home.categories')
                                </h5>
                            </div>
                            <div class="wized-body">
                                <p>{!! $lang=="en"?$webinar->text_en_2:$webinar->text_ar_2 !!}</p>
                             
                            </div>
                        </div>
                    </div>
                </div>--}}
                <!-- rts- blog wizered end area -->
            </div>
        </div>
    </div>
    <!-- rts blog area end -->

@endsection

@section('script')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.6/dist/sweetalert2.all.min.js"></script>
<script>
     $(document).ready(function() {
        var registerdBefore = "{{ Session::has('registerd_before') }}";
        var requestSuccessMessage = "{{ Session::has('request_success_message') }}";

        $('#webinar-subscribe-form').submit(function(event) {
            event.preventDefault();
            var formData = $(this).serialize();

            $.ajax({
                type: 'POST',
                url: "{{ route('save_webinar_subscriber_request') }}",
                data: formData,
                success: function(response) {
                    if (response.status === 'error') {
                        Swal.fire({
                            icon: 'error',
                            title: '{{ trans("home.error") }}',
                            text: response.message
                        });
                    } else if (response.status === 'success') {
                        Swal.fire({
                            icon: 'success',
                            title: '{{ trans("home.registeration_success") }}',
                            text: response.message
                        }).then(() => {
                        window.location.reload(); // Reloads the page after the alert is closed
                    });
                    }
                },
                error: function(error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: error
                        // text: 'Something went wrong!'
                    });
                }
            });
        });
    });

</script>
@endsection
