@extends('layouts.app')
@section('meta')
   <title>{{$configration->app_name.' '}}|{{' '.__('home.trainings').' '.$training_field->{'name_'.$lang} }}</title>
@endsection

@section('content')
  <!--================= back wrapper Start Here =================-->
<div class="back-wrapper">
    <div class="back-wrapper-inner">
        <!--================= Back Breadcrumbs Section Start Here =================-->
        <div class="back-breadcrumbs">
            <div class="breadcrumbs-wrap">
                <img class="desktop" src="{{ Helper::imageFilesPath('breadcrumbs/1.png')}}" alt="Breadcrumbs">
                <img class="mobile" src="{{ Helper::imageFilesPath('breadcrumbs/1.png')}}" alt="Breadcrumbs">
                <div class="breadcrumbs-inner">
                    <div class="container">
                        <div class="breadcrumbs-text">
                            <h1 class="breadcrumbs-title">{{__('home.trainings').' '}}{{$training_field->{'name_'.$lang} }} </h1>
                            <div class="back-nav">
                                <ul>
                                    <li>
                                        <a href="{{LaravelLocalization::localizeUrl('/')}}">{{trans('home.home')}}</a>
                                    </li>
                                    <li>{{$training_field->{'name_'.$lang} }} </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--================= Back Breadcrumbs Section End Here =================-->
        <div class="back__course__area back__course__page_grid pt-120 pb-115">
        <div class="container">
            
          <div class="row">
       
                <div class="col-lg-12">
              <div class="row align-items-center justify-content-between back-vertical-middle shorting__course mb-50">
                <div class="col">
                  <div class="all__icons">
                    <div class="result-count">{{__('home.fields')}}</div>
                  </div>
                </div>
                <div class="col d-flex align-items-center justify-content-end">
                    
                  <select class="form-control" onchange="navigateToTraining()">
                    @foreach($menuTrainingFields as $menuTrainingField)
                        <option value="{{ url('field/'.$menuTrainingField->{'link_'.$lang}.'/trainings') }}" {{ ($menuTrainingField->id==$training_field->id?'selected':'') }}>
                            {{ $menuTrainingField->{'name_'.$lang} }}
                        </option>
                    @endforeach
                  </select>
                </div>
              </div>
                   @if(count($courses)>0)
                <div class="row">
                @foreach($courses as $course)
                    <div class="col-md-6 col-lg-4">
                  <div class="course__item mb-30">
                    <div class="course__thumb">
                      <a href="{{url('training/'.$course->code )}}">
                        <img src="{{Helper::uploadedImagesPath('courses/images',$course->image??'training-icon-5.jpg')}}" alt="{{$course->alt_img}}">
                      </a>
                    </div>
                    <div class="course__inner">
                      <span class="back-category cate-1">{{$training_field->{'name_'.$lang} }}</span>
                      <h3 class="back-course-title">
                        <a href="{{url('training/'.$course->code )}}">{{$course->{'name_'.$lang} }}</a>
                      </h3>
                      <div class="course__card-icon d-flex align-items-center">
                        <div class="course__card-icon--1">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-user">
                            <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                            <circle cx="12" cy="7" r="4"></circle>
                          </svg>
                        </div>

                      </div>
                    </div>
                  </div>
                </div>
                @endforeach
              </div>
                  <!--================= Pagination Section Start Here =================-->
                  <!-- Pagination -->
                    <ul class="back-pagination">
                        @if(!$courses->onFirstPage())
                            <li class="back-next">
                              <a href="{{ $courses->previousPageUrl()}}"> {{__('home.back_page')}}<i class="arrow_carrot-right"></i>
                              </a>
                            </li>
                        @endif
                        @foreach ($courses->getUrlRange(1, $courses->lastPage()) as $page => $url)

                            @if($page == $courses->currentPage())
                                <li style="background-color: a4b93a;color: white;"><a >{{ $page }}</a></li>
                            @else
                                <li><a  href="{{ $url }}">{{ $page }}</a></li>
                            @endif
                        @endforeach

                        @if($courses->hasMorePages())
                            <li class="back-next">
                                <a href="{{ $courses->nextPageUrl()}}"> {{__('home.next_page')}}<i class="arrow_carrot-left"></i></a>
                            </li>
                        @endif
                    </ul>
                        <!-- End Pagination -->
              <!--================= Pagination Section End Here =================-->
              @else
              <div class="breadcrumbs-inner">
                    <div class="container">
                        <div class="breadcrumbs-text">
                            <h1 class="breadcrumbs-title">{{__('home.empty_training')}}</h1>
                        </div>
                    </div>
                </div>
            @endif
            </div>
            
          </div>
        </div>
      </div>
        
        
        
    </div>
</div>  


@endsection

@section('script')

<script>
    function navigateToTraining() {
        var url = event.target.value;
        window.location.href = url;
    }
</script>
@endsection