@extends('website.student.layouts.master')
@section('title')
    <title>{{ __('home.Order History') }}</title>
@endsection

@section('sub-title', __('home.Order History') )

@section('content')
    <div class="col-lg-9">
        <!-- Start Enrole Course  -->
        <div class="rbt-dashboard-content bg-color-white rbt-shadow-box">
            <div class="content">
                <div class="section-title">
                    <h4 class="rbt-title-style-3">{{__('home.Order History')}}</h4>
                </div>

                <div class="rbt-dashboard-table table-responsive mobile-table-750">
                    <table class="rbt-table table table-borderless">
                        <thead>
                        <tr>
                            <th>{{__('home.Order ID')}}</th>
                            <th>{{__('home.Course Name')}}</th>
                            <th>{{__('home.Date')}}</th>
                            <th>{{__('home.Price')}}</th>
                            <th>{{__('home.Status')}}</th>
                        </tr>
                        </thead>

                        <tbody>
                        @forelse($orders as $order)
                        <tr>
                            <th>#{{$order->id}}</th>
                            <td>{{$order->orderCourses->first()->course->name_ar}}</td>
                            <td>{{$order->created_at}}</td>
                            <td>${{$order->total_price}}</td>
                           <td>
                                @if($order->status === 'unpaid')
                                    <span class="rbt-badge-5 bg-color-danger-opacity color-danger">{{$order->status}}</span>
                                @elseif($order->status === 'paid')
                                    <span class="rbt-badge-5 bg-color-success-opacity color-success">{{$order->status}}</span>
                                @endif
                            </td>

                        </tr>
                      
                        @empty
                            <tr>
                                <th colspan="4">#2045</th>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
        <!-- End Enrole Course  -->
    </div>

@endsection