@extends('layouts.app')
@section('title')
    <title>@lang('home.search_result')</title>
@endsection
@section('content')
  <!-- bread crumb area -->
    <div class="rts-bread-crumbarea-1 rts-section-gap bg_image">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-main-wrapper">
                        <h1 class="title">{{__('home.search_result')}}</h1>
                        <!-- breadcrumb pagination area -->
                        <div class="pagination-wrapper">
                            <a href="{{url('/')}}">@lang('home.home')</a>
                            <i class="fa-regular fa-chevron-right"></i>
                            <a class="active">{{__('home.search_result')}}</a>
                        </div>
                        <!-- breadcrumb pagination area end -->
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- course area start -->
    <div class="rts-course-default-area rts-section-gap">
        <div class="container">
                <div class="row g-5">
                    <div class="col-lg-12">
                        <!-- filter top-area  -->
                        <div class="filter-small-top-full">
                            <div class="right-filter">
                                <span>
                                    @lang('home.showing') {{ $courses->firstItem() }}-{{ $courses->lastItem() }} @lang('home.of') {{ $totalCourses }} @lang('home.results')
                                </span>
                                <ul class="nav nav-tabs" id="myTab" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true">
                                            <i class="fa-light fa-grid-2"></i>
                                            <span>@lang('home.grid')</span>
                                        </button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">
                                            <i class="fa-light fa-list"></i>
                                            <span> @lang('home.list')</span>
                                        </button>
                                    </li>
                                </ul>

                            </div>
                        </div>
                        <!-- filter top-area end -->
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                                <div class="row mt--20 g-5">
                                    @foreach ($courses as $course)
                                        <div class="col-lg-4 col-md-6 col-sm-12 col-12">
                                            <!-- single course style two -->
                                            <div class="single-course-style-three">
                                                <a    href="{{ LaravelLocalization::localizeUrl('course/' . $course->{'link_' . $lang}) }}" class="thumbnail">
                                                    <img src="{{ isset($course->image) ? Helper::uploadedImagesPath('courses', $course->image) : Helper::imageFilesPath('noimage.png') }}" alt="course">
                                                    <div class="tag-thumb">
                                                        <span>{{ $course->category->{'name_' . $lang} }}</span>
                                                    </div>
                                                </a>
                                                <div class="body-area">
                                                    <div class="course-top">
                                                        <div class="price">
                                                            {{ $course->last_price()==0?__('home.free'):$course->last_price() . ' ' . __('home.EGP') }}
                                                        </div>
                                                    </div>
                                                    <a href="{{ LaravelLocalization::localizeUrl('course/' . $course->{'link_' . $lang}) }}">
                                                        <h5 class="title">{{ $course->{'name_' . $lang} }}</h5>
                                                    </a>
                                                    <div class="teacher-stars row">
                                                        @foreach ($course->teachers() as $teacher)
                                                            <span class="teacher mx-2 col-auto">{{ $teacher->name }}</span>
                                                            @if (!$loop->last)
                                                                /
                                                            @endif
                                                        @endforeach
                                                        <ul class="stars col-auto">
                                                            @if ($course->rate != 0)
                                                                <span class="span">{{ $course->rate }}</span>
                                                            @endif
                                                            <?php $rate = intval($course->rate); ?>
                                                            @for ($i = 1; $i <= $rate; $i++)
                                                                <li><i class="fa-sharp fa-solid fa-star"></i></li>
                                                            @endfor
                                                            @for ($i = 1; $i <= 5 - $rate; $i++)
                                                                <li><i class="fa-sharp fa-regular fa-star"></i></li>
                                                            @endfor
                                                        </ul>
                                                    </div>
                                                    <div class="leasson-students">
                                                        <div class="lesson">
                                                            <i class="fa-light fa-calendar-lines-pen"></i>
                                                            <span>{{ $course->countLessons() }} @lang('home.lessons')</span>
                                                        </div>
                                                        <div class="lesson">
                                                            <i class="fa-light fa-calendar-lines-pen"></i>
                                                            <span> @lang('home.type'){{ ' : '.$course->type->{'name_'.$lang} }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="course-content-area">
                                                        <h5 class="heading-title">
                                                            <a    href="{{ LaravelLocalization::localizeUrl('course/' . $course->{'link_' . $lang}) }}">{{ $course->category->{'name_' . $lang} }}</a>
                                                        </h5>
                                                        <div class="tags-area-wrapper">
                                                            <div class="single-tag">
                                                                <span>{{$course->level->{'name_'.$lang} }}</span>
                                                            </div>
                                                            <div class="lesson-studente">
                                                                <div class="lesson">
                                                                    <i class="fa-light fa-calendar-lines-pen"></i>
                                                                    <span>{{ $course->countLessons() }} @lang('home.lessons')</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @if ($course->{'text_'.$lang})
                                                            <p class="desc">{{ substr(strip_tags($course->{'text_'.$lang}), 0, 150).'... ' }}</p>
                                                        @endif
                                                        <ul class="wrapper-list">
                                                            @foreach ($course->points() as $point)
                                                                <li><i class="fa-solid fa-check"></i>{{$point->{'text_'.$lang} }}</li>                                                        
                                                            @endforeach
                                                        </ul>
                                                        <div class="button-area">
                                                            <a href="avascript:void(0)" data-course_id="{{$course->id}}" class="rts-btn btn-primary addToCart">@lang('home.Add to Cart')</a>
                                                            <a href="javascript:void(0)" data-course_id="{{$course->id}}" class="addToWislist wishlist-btn"><i class="fa-thin fa-circle-heart"></i></a>
                                                        </div>
                                                        <div class="shape">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- single course style two end -->
                                        </div>                                    
                                    @endforeach
                                </div>


                                <div class="row mt--30">
                                    <div class="col-lg-12">
                                        <!-- rts-pagination-area -->
                                        <div class="rts-pagination-area-2">                                                
                                            <ul>                                            
                                                @if($courses->onFirstPage())
                                                    <li><i class="fa-solid fa-chevron-left"></i></li>
                                                @else
                                                    <li><a  href="{{ $courses->previousPageUrl() . '&' . http_build_query(request()->except('page')) }}"><i class="fa-solid fa-chevron-left"></i></a></li>
                                                @endif
                                                @foreach ($courses->getUrlRange(1, $courses->lastPage()) as $page => $url)
                                                    @php
                                                        $urlWithParams = $url . '&' . http_build_query(request()->except('page'));
                                                    @endphp
            
                                                    @if($page == $courses->currentPage())
                                                        <li class="active">{{ $page }}</li>
                                                    @else
                                                        <li><a href="{{ $urlWithParams }}">{{ $page }}</a></li>
                                                    @endif
                                                @endforeach
                                                
                                                @if($courses->hasMorePages())
                                                    <li><a href="{{ $courses->nextPageUrl() . '&' . http_build_query(request()->except('page')) }}"><i class="fa-solid fa-chevron-right"></i></a></li>
                                                @else
                                                    <li><i class="fa-solid fa-chevron-right"></i></li>
                                                @endif
                                            </ul>
                                        </div>
                                        <!-- rts-pagination-area end -->
                                    </div>
                                </div>
                            </div>


                            <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                                <div class="row g-5 mt--30">
                                    <div class="col-lg-12">
                                        @foreach ($courses as $course)
                                            <!-- rts single course -->
                                            <div class="rts-single-course course-list">
                                                <a    href="{{ LaravelLocalization::localizeUrl('course/' . $course->{'link_' . $lang}) }}" class="thumbnail">
                                                    <img src="{{ isset($course->image) ? Helper::uploadedImagesPath('courses', $course->image) : Helper::imageFilesPath('noimage.png') }}" alt="course">
                                                </a>
                                                <div class="information-inner">
                                                    <div class="tags-area-wrapper">
                                                        <div class="single-tag">
                                                            <span>{{ $course->category->{'name_' . $lang} }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="lesson-studente">
                                                        <div class="lesson">
                                                            <i class="fa-light fa-calendar-lines-pen"></i>
                                                            <span>{{ count($course->chapters) }} @lang('home.lessons')</span>
                                                        </div>
                                                    </div>
                                                    <a    href="{{ LaravelLocalization::localizeUrl('course/' . $course->{'link_' . $lang}) }}">
                                                        <h5 class="title">{{ $course->{'name_' . $lang} }}</h5>
                                                    </a>
                                                    <p class="teacher row">
                                                        @foreach ($course->teachers() as $teacher)
                                                            <span class="teacher mx-2 col-auto">{{ $teacher->name }}</span>
                                                            @if (!$loop->last)
                                                                /
                                                            @endif
                                                        @endforeach
                                                    </p>
                                                    <div class="rating-and-price">
                                                        <div class="rating-area">
                                                            <div class="stars col-auto">
                                                                <ul>
                                                                    @if ($course->rate != 0)
                                                                        <span class="span">{{ $course->rate }}</span>
                                                                    @endif
                                                                    <?php $rate = intval($course->rate); ?>
                                                                    @for ($i = 1; $i <= $rate; $i++)
                                                                        <li><i class="fa-sharp fa-solid fa-star"></i></li>
                                                                    @endfor
                                                                    @for ($i = 1; $i <= 5 - $rate; $i++)
                                                                        <li><i class="fa-sharp fa-regular fa-star"></i></li>
                                                                    @endfor
                                                                </ul>
                                                            </div>
                                                        </div>
                                                        <div class="price-area">
                                                            @if ($course->discount)
                                                                <div class="not price">
                                                                    {{ $course->price . ' ' . __('home.EGP') }}
                                                                </div>
                                                            @endif
                                                            <div class="price">
                                                                {{ $course->last_price()==0?__('home.free'):$course->last_price() . ' ' . __('home.EGP') }}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                            <!-- rts single course end -->
                                        @endforeach
                                    </div>
                                </div>
                                <div class="row mt--0">
                                    <div class="col-lg-12">
                                        <!-- rts-pagination-area -->
                                        <div class="rts-pagination-area-2">
                                            <ul>
                                                @if($courses->onFirstPage())
                                                    <li><i class="fa-solid fa-chevron-left"></i></li>
                                                @else
                                                    <li><a  href="{{ $courses->previousPageUrl() . '&' . http_build_query(request()->except('page')) }}"><i class="fa-solid fa-chevron-left"></i></a></li>
                                                @endif
                                                @foreach ($courses->getUrlRange(1, $courses->lastPage()) as $page => $url)
                                                    @php
                                                        $urlWithParams = $url . '&' . http_build_query(request()->except('page'));
                                                    @endphp
            
                                                    @if($page == $courses->currentPage())
                                                        <li class="active">{{ $page }}</li>
                                                    @else
                                                        <li><a href="{{ $urlWithParams }}">{{ $page }}</a></li>
                                                    @endif
                                                @endforeach
                                                
                                                @if($courses->hasMorePages())
                                                    <li><a href="{{ $courses->nextPageUrl() . '&' . http_build_query(request()->except('page')) }}"><i class="fa-solid fa-chevron-right"></i></a></li>
                                                @else
                                                    <li><i class="fa-solid fa-chevron-right"></i></li>
                                                @endif
                                            </ul>
                                        </div>
                                        <!-- rts-pagination-area end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- course area end -->

@endsection
@section ('script')
    <script>
        $('.autoCompleteProduct').on('change', function () {
            $('#filter_form').submit();
        });
        // Initialize autocomplete
        function auto() {
            var options2 = {
                url: function (phrase) {
                    return "{{ url('searchAutoComplete') }}";
                },
                ajaxSettings: {
                    dataType: "json",
                    method: "GET",
                    data: {
                        dataType: "json"
                    }
                },
                getValue: function (element) {
                    return element.name;
                },
                preparePostData: function (data) {
                    data.phrase = $('.autoComplete_courses').val();
                    return data;
                },
                list: {
                    match: {
                        enabled: true
                    }
                }
            };

            $('.autoComplete_courses').easyAutocomplete(options2);
        }

        $(document).ready(function() {
            auto();
        });
    </script>

@endsection