@extends('layouts.app')
@section('title')
    @php echo $metatags @endphp
{{--    <title>{{(app()->getLocale() == 'en')? $dish->name_en: $dish->name_ar}} {{trans('home.menu')}}</title>--}}
@endsection
@section('content')

    <!-- bread crumb area -->
    <div class="rts-bread-crumbarea-1 rts-section-gap bg_image">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-main-wrapper">
                        <h1 class="title">{{$news->{'name_'.$lang} }}</h1>
                        <!-- breadcrumb pagination area -->
                        <div class="pagination-wrapper">
                            <a    href="{{url('/')}}"> @lang('home.home') </a>
                            <i class="fa-regular fa-chevron-right"></i>
                            <a    class="active" href="javascript:void;">{{$news->{'name_'.$lang} }}
                            </a>
                        </div>
                        <!-- breadcrumb pagination area end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- bread crumb area end -->

    <!-- blog details area start -->
    <div class="rts-blog-list-area rts-section-gap">
        <div class="container">
            <div class="row g-5">
                <!-- rts blo post area -->
                <div class="@if(count($newsCategories) > 0 && count($newss) > 0) col-xl-8 @else col-xl-12 @endif col-md-12 col-sm-12 col-12">
                    <!-- single post -->
                    <div class="blog-single-post-listing details mb--0">
                        <div class="thumbnail">
                            <img src="{{ isset($news->image) ? Helper::uploadedImagesPath('newsitems',$news->image) : Helper::imageFilesPath('noimage.png') }}" alt="{{$news->alt_img}}">
                        </div>
                        <div class="blog-listing-content">
                            <div class="user-info">
                                <!-- single info -->
                                {{--<div class="single">
                                    <i class="far fa-user-circle"></i>
                                    <span>@lang('home.by') {{$news->writers->name ?? ''}}</span>
                                </div>
                                <!-- single infoe end -->
                                <!-- single info -->
                                <div class="single">
                                    <i class="far fa-clock"></i>
                                    <span>{{ \Carbon\Carbon::parse($news->date)->format('F j, Y') }}</span>
                                </div> --}}
                                <!-- single infoe end -->
                                <!-- single info -->
                                @if(isset($news?->Newscat))
                                <div class="single">
                                    <i class="far fa-tags"></i>
                                    <span>{{$news->Newscat?->{'name_'.$lang} ?? '' }}</span>
                                </div>
                                @endif
                                <!-- single infoe end -->
                            </div>
                            <h3 class="title animated fadeIn">{{$news->{'name_'.$lang} }}</h3>
                            <p class="disc para-1">{!! $news->{'text_'.$lang} !!}</p>
                             
                            <!-- quote area start -->
                            @isset($news->quotes)
                            @if(count($news->quotes) > 0)
                                @foreach ($news->quotes as $quote)
                                    <div class="rts-quote-area text-start reveal">
                                        <h5 class="title title-g">{{$quote->answer}}</h5>
                                        <p class="author-name">{{$quote->question}}</p>
                                    </div>
                                @endforeach
                            @endif
                            @endisset
                            <!-- quote area end -->
                    

                           {{-- <div class="replay-area-details">
                                <h4 class="title">{{ trans('home.Leave a Reply') }}</h4>
                                <form action="#">
                                    <div class="row g-4">
                                        <div class="col-lg-6">
                                            <input type="text" placeholder="{{ trans('home.first_name') }}" required>
                                        </div>
                                        <div class="col-lg-6">
                                            <input type="text" placeholder="{{ trans('home.last_name') }}" required>
                                        </div>
                                        <div class="col-12">
                                            <input type="text" placeholder="Select Topic" required>
                                            <textarea placeholder="{{ trans('home.your_comment') }}" required></textarea>
                                        </div>
                                    </div>
                                    <button type="submit" class="rts-btn btn-primary mt--20">{{ trans('home.submit') }}</button>
                                </form>
                            </div> --}}
                        </div>
                    </div>
                    <!-- single post End-->
                </div>
                <!-- rts-blog post end area -->
                
                <!--rts blog wizered area -->
                <div class="col-xl-4 col-md-12 col-sm-12 col-12 rts-sticky-column-item">
                    <div class="blog-sidebar theiaStickySidebar">
                        <!-- single wizered start -->
                        @if(count($newsCategories) > 0)
                            <div class="rts-single-wized Categories">
                                <div class="wized-header">
                                    <h5 class="title">
                                        @lang('home.categories')
                                    </h5>
                                </div>
                                <div class="wized-body">
                                    <!-- single categoris -->
                                    @foreach ($newsCategories as $newsCategory)
                                        <ul class="single-categories">
                                            <li><a    href="{{LaravelLocalization::localizeUrl('news/'.$newsCategory->{'link_'.$lang} )}}">{{$newsCategory->{'name_'.$lang} }} <i class="far fa-long-arrow-right"></i></a></li>
                                        </ul>
                                    @endforeach
                                    <!-- single categoris End -->
                                </div>
                            </div>
                        @endif
                        <!-- single wizered End -->
                        <!-- single wizered start -->
                        @if (count($newss)>0)
                            <div class="rts-single-wized Recent-post">
                                <div class="wized-header">
                                    <h5 class="title">
                                        @lang('home.related_news')
                                    </h5>
                                </div>
                                <div class="wized-body">
                                    <!-- recent-post -->
                                    @foreach ($newss as $new)
                                        <div class="recent-post-single">
                                            <div class="thumbnail">
                                                <a href="{{LaravelLocalization::localizeUrl('new/' . $new->{'link_'.$lang})}}"><img src="{{ isset($new->image) ? Helper::uploadedImagesPath('newsitems',$new->image) : Helper::imageFilesPath('noimage.png')}}" alt="news"></a>
                                            </div>
                                            <div class="content-area text-start">
                                                @if($news?->Newscat)
                                                <div class="user">
                                                    <i class="fal fa-clock"></i>
                                                    <span>{{$new->Newscat->{'name_'.$lang} }}</span>
                                                </div>
                                                @endif
                                                <a    class="post-title" href="{{LaravelLocalization::localizeUrl('new/' . $new->{'link_'.$lang})}}">
                                                    <h6 class="title">{{$new->{'name_'.$lang} }}</h6>
                                                </a>
                                            </div>
                                        </div>
                                    @endforeach
                                    <!-- recent-post End -->
                                </div>
                            </div>
                            <!-- single wizered End -->
                        @endif
                        
                    </div>
                </div>
                <!-- rts- blog wizered end area -->
            </div>
        </div>
    </div>
    <!-- blog details area end -->


@endsection
