<!DOCTYPE html>
<html lang="{{ LaravelLocalization::getCurrentLocale() }}" dir="{{LaravelLocalization::getCurrentLocaleDirection() }}">

<head>
    <!--================= Meta tag =================-->
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{$configration->app_name}}</title>
    <style>
        .back-wrapper {
            margin-top: -321px;
        }
        
        @media only screen and (max-width: 1100px) {
            .back-breadcrumbs:not(.back-breadcrumbs-blog-single) .breadcrumbs-wrap img {
                height: 100px !important;
            }
        }
        
        .breadcrumbs-wrap img {
            max-height: 100px !important;
        }
    </style>
    <!--================= Favicon =================-->
    <link rel="apple-touch-icon" href="{{Helper::uploadedImagesPath('settings',$configration->fav_icon)}}">
    <link rel="shortcut icon" type="image/x-icon" href="{{Helper::uploadedImagesPath('settings',$configration->fav_icon)}}">
    <!--================= Bootstrap v5 Css =================-->
    <link rel="stylesheet" type="text/css" href="{{ Helper::cssFilesPath('bootstrap.min.css')}}">
    <!--================= Back Menus Css =================-->
    <link rel="stylesheet" type="text/css" href="{{ Helper::cssFilesPath('back-menus.css')}}">
    <!--================= Animate Css =================-->
    <link rel="stylesheet" type="text/css" href="{{ Helper::cssFilesPath('animate.css')}}">
    <!--================= Owl Carousel Css =================-->
    <link rel="stylesheet" type="text/css" href="{{ Helper::cssFilesPath('owl.carousel.css')}}">
    <!--================= Elegant icon Css  =================-->
    <link rel="stylesheet" type="text/css" href="{{Helper::fontFilesPath('elegant-icon.css')}}">
    <!--================= Magnific Popup Css =================-->
    <link rel="stylesheet" type="text/css" href="{{ Helper::cssFilesPath('magnific-popup.css')}}">
    <!--================= Back Animations Css =================-->
    <link rel="stylesheet" type="text/css" href="{{ Helper::cssFilesPath('back-animations.css')}}">
    <!--================= Style Css =================-->
    <link rel="stylesheet" type="text/css" href="{{ Helper::cssFilesPath('style.css')}}?{{ time() }}">
    <!--================= Spacing Css =================-->
    <link rel="stylesheet" type="text/css" href="{{ Helper::cssFilesPath('back-spacing.css')}}?{{ time() }}">
    <!--================= Responsive Css =================-->
    <link rel="stylesheet" type="text/css" href="{{ Helper::cssFilesPath('responsive.css')}}?{{ time() }}">
    <!--================= RTL Css =================-->
    <link rel="stylesheet" type="text/css" href="{{ Helper::cssFilesPath('rtl.css')}}?{{ time() }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
    @yield('style')
    
    <!-- Google Tag Manager -->
    {!!($setting->gtm_script)?html_entity_decode($setting->gtm_script):''!!}
    <!-- End Google Tag Manager -->
    
    <!-- FACEBOOK PIXEL CODE -->
    {!!($setting->fb_pixel_script)?html_entity_decode($setting->fb_pixel_script):''!!}
    <!-- End FACEBOOK PIXEL CODE -->
</head>

<body>
    <!--================= Preloader Section Start Here =================-->
    <div id="back__preloader">
        <div id="back__circle_loader"></div>
        <div class="back__loader_logo"><img src="{{ Helper::imageFilesPath('favicon.ico')}}" alt="Preload"></div>
    </div>
    <!--================= Preloader Section End Here =================-->

    
    <!--================= back wrapper Start Here =================-->
    <div class="back-wrapper">
        <div class="back-wrapper-inner">
            <div class="back-wrapper">
    <div class="back-wrapper-inner">
        <!--================= Back Breadcrumbs Section Start Here =================-->
        <div class="back-breadcrumbs">
            <div class="breadcrumbs-wrap">
                <img class="desktop" src="{{ Helper::imageFilesPath('breadcrumbs/1.png')}}" alt="Breadcrumbs">
                <img class="mobile" src="{{ Helper::imageFilesPath('breadcrumbs/1.png')}}" alt="Breadcrumbs">
                <div class="breadcrumbs-inner">
                    <div class="container">
                        <div class="col-md-12 text-center wow fadeInUp mt-n3" data-wow-delay="300ms">
                        <!--<span class="defaultcolor">{{trans('home.wad Forum')}}</span>-->
                        <div class="heading-title bottom25 darkcolor">
                          
                        </div>
                        
                    </div>
                    </div>
                </div>
            </div>
        </div>
        <!--================= Back Breadcrumbs Section End Here =================-->
        </div>
    </div>
                <div class="container back-contact-page pt-120 pb-120">
        
        <div class="back__title__section text-center">
            <h3 class="back__subtitle wow fadeInUp text-right" data-wow-delay="0.5s">برنامج تدريبي مجاني للباحثين عن العمل <br>في مجال التسويق والمبيعات</h3>
            <h6 class="back__tittle wow fadeInUp text-slate" data-wow-delay="0.7s">
                لمن لدية الرغبة في زيادة فرصة التوظيف يرجى الإشتراك في دورة حضورية مجانا تحت مسمى
            <br><br>(أخصائي تسويق ومبيعات وخدمات مابعد البيع) <br><br>مدة أيام التدريب 5 - 7 أيام تدريبية <br><br> وقت التدريب صباحي<br><br><span style="font-weight:bold;color:black;"> الرجاء مراعاة الشروط التالية: <br><br> - سعودي الجنسية <br><br> - غير مشترك بالتأمينات الإجتماعية</span>
            </h6>
            <br>
            <h4 style="color:#a4b93a;">يرجى ملء البيانات وسنقوم بالتواصل معكم في أقرب وقت وإبلاغكم بكافة تفاصيل البرنامج التدريبي</h4>
        </div>
        
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        
        <div class="blog-form">
            <form class="getin_form" id="contact-form" action="{{route('save_marketing_program_request')}}" method="POST">
                @csrf
                <div class="row">
                  <div class="col-md-4 col-lg-4 pdl-5">
                    <div class="back-input">
                      <input id="name" type="text" name="full_name" placeholder="الأسم رباعي" required>
                    </div>
                  </div>
        
                  <div class="col-md-4 col-lg-4 pdl-5">
                    <div class="back-input">
                      <input id="email" type="email" name="email" placeholder="البريد الإلكتروني" required>
                    </div>
                  </div>
        
                  <!--<div class="col-md-6 col-lg-4 pdl-5">-->
                  <!--  <div class="back-input">-->
                  <!--    <input id="nationality" type="text" name="nationality" placeholder="الجنسية" required>-->
                  <!--  </div>-->
                  <!--</div>-->
        
                  <div class="col-md-4 col-lg-4 pdl-5">
                    <div class="back-input">
                      <input id="phone" type="text" name="phone" placeholder="الجوال" required>
                    </div>
                  </div>
        
                    <!--<div class="col-md-6 col-lg-4 pdl-5">-->
                    <!--    <div class="back-input">-->
                    <!--      <input id="phone" type="text" name="phone" placeholder="رقم الجوال">-->
                    <!--    </div>-->
                    <!--</div>-->
                    
                    <div class="col-md-4 col-lg-4 pdl-5">
                        <div class="back-input">
                          <input id="phone" type="text" name="age" placeholder="العمر" required>
                        </div>
                    </div>
                    
                    
                    
                    <div class="col-md-4 col-sm-12">
                        <div class="form-group">
                            <!--<label for="message1">مكان الحضور</label>-->
                            <select class="form-control select2" name="qualification" required>
                                <option value="">المؤهل العلمي</option>
                                <option @selected(old('qualification') == 'university') value="university">{{trans('home.university')}}</option>
                                <option @selected(old('qualification') == 'diploma') value="diploma">{{trans('home.diploma')}}</option>
                                <option @selected(old('qualification') == 'secondary') value="secondary">{{trans('home.secondary')}}</option>
                                <option @selected(old('qualification') == 'intermediate') value="intermediate">{{trans('home.intermediate')}}</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-4 col-lg-4 pdl-5 mt-3 mt-md-0">
                        <div class="back-input">
                          <input id="phone" type="text" name="specialization" placeholder="التخصص" required>
                        </div>
                    </div>
                    
                    <div class="col-md-4 col-sm-12">
                        <div class="form-group">
                            <!--<label for="message1">مكان الحضور</label>-->
                            <select class="form-control select2" name="location" required>
                                <option value="">مكان الحضور</option>
                                <option @selected(old('location') == 'gada') value="gada">{{trans('home.gada')}}</option>
                                <option @selected(old('location') == 'riyadh') value="riyadh">{{trans('home.riyadh')}}</option>
                                <option @selected(old('location') == 'other_region') value="other_region">{{trans('home.other_region')}}</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-12 mt-3 mt-md-0">
                        <div class="form-group">
                            <!--<label for="message1">النوع</label>-->
                            <select class="form-control select2" name="gender" required>
                                <option value="">الجنس</option>
                                <option @selected(old('gender') == 'male') value="male">{{trans('home.male')}}</option>
                                <option @selected(old('gender') == 'female') value="female">{{trans('home.female')}}</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-4 col-sm-12 mt-3 mt-md-0">
                        <div class="form-group">
                            <!--<label for="message1">حالة الإشتراك في التأمينات حاليا</label>-->
                            <select class="form-control select2" name="insurance_status" required>
                                <option value="">حالة الإشتراك في التأمينات الإجتماعية</option>
                                <option @selected(old('insurance_status') == 'subscribed') value="subscribed">{{trans('home.subscribed')}}</option>
                                <option @selected(old('insurance_status') == 'unsubscribed') value="unsubscribed">{{trans('home.unsubscribed')}}</option>
                            </select>
                        </div>
                    </div>
                    {{--<div class="col-md-4 col-sm-12">
                        <div class="form-group">
                            <label for="message1">تاريخ الحضور</label>
                            <select class="form-control select2" name="attendance_date" required>
                                <option>{{trans('home.choose_date')}}</option>
                                <option @selected(old('attendance_date') == '21/07/2024') value="21/07/2024">21/07/2024</option>
                                <option @selected(old('attendance_date') == '28/07/2024') value="28/07/2024">28/07/2024</option>
                                <option @selected(old('attendance_date') == '28/07/2024') value="28/07/2024">28/07/2024</option>
                            </select>
                        </div>
                    </div>--}}
                    
                    
                    
                    
                  
                </div>
              <div class="mx-auto col-lg-6 mt-5">
                <button type="submit" class="back-btn">إرسال</button>
              </div>
            </form>
        </div>
    </div>
       </div>
    </div>
    <!--================= Back Wrapper End Here =================-->


    <!--================= Scroll Top Start Here =================-->
    <div id="backscrollUp">
        <span aria-hidden="true" class="arrow_carrot-up"></span>
    </div>
    <!--================= Scroll Top End Here =================-->
     <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.all.min.js"></script>
    
        @if(session()->has('registerd_before'))
            <script>
                Swal.fire({
                    icon: 'error',
                    title: '{{ session()->pull("registerd_before") }}',
                });
            </script>
        @endif
        @if(session()->has('request_success_message'))
            <script>
                Swal.fire({
                    icon: 'success',
                    title: '{{ session()->pull("request_success_message") }}',
                });
            </script>
        @endif
    <!--================= Jquery latest version =================-->
    <script src="{{ Helper::jsFilesPath('jquery.min.js')}}"></script>
    <!--================= Modernizr js =================-->
    <script src="{{ Helper::jsFilesPath('modernizr-2.8.3.min.js')}}"></script>
    <!--================= Bootstrap js =================-->
    <script src="{{ Helper::jsFilesPath('bootstrap.min.js')}}"></script>
    <!--================= Owl Carousel js =================-->
    <script src="{{ Helper::jsFilesPath('owl.carousel.min.js')}}"></script>
    <!--================= magnific popup =================-->
    <script src="{{ Helper::jsFilesPath('jquery.magnific-popup.min.js')}}"></script>
    <!--================= Counter Up js =================-->
    <script src="{{ Helper::jsFilesPath('jquery.counterup.min.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('waypoints.min.js')}}"></script>
    <!--================= Wow js =================-->
    <script src="{{ Helper::jsFilesPath('wow.min.js')}}"></script>
    <!--================= Isotope pkgd min js =================-->
    <script src="{{ Helper::jsFilesPath('isotope.pkgd.min.js')}}"></script>
    <!--================= Imagesloaded.pkgd.min js =================-->
    <script src="{{ Helper::jsFilesPath('imagesloaded.pkgd.min.js')}}"></script>
    <!--================= Back menus js =================-->
    <script src="{{ Helper::jsFilesPath('back-menus.js')}}"></script>
    <!--================= Plugins js =================-->
    <script src="{{ Helper::jsFilesPath('plugins.js')}}"></script>
    <!--================= Main js =================-->
    <script src="{{ Helper::jsFilesPath('main.js')}}?{{ time() }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>
    
    
    <script>
    
      // pisticky Menu
      var header = $('.back-header');
      var win = $(window);
      win.on('scroll', function () {
        var scroll = win.scrollTop();
        if (scroll < 100) {
          header.removeClass("back-sticky");
          $(".header-logo img").attr('src', "{{Helper::uploadedImagesPath('settings',$configration->app_logo)}}");
        } else {
          header.addClass("back-sticky");
          $(".header-logo img").attr('src', "{{Helper::imageFilesPath('black_logo.png')}}");
        }
      });
  
        @if(Session::has('success'))
            <script>
                $.alert({
                    title: "{{trans('home.thank_you')}}",
                    content: "{{Session::get('success')}}",
                    buttons: {
                        ok: {
                            text: "{{trans('home.OK')}}",
                            btnClass: 'btn main-btn',
                        },
                    },
                    columnClass: 'col-md-6'
                });
            </script>
        @endif
        @php
            Session::forget('success')
        @endphp 
    </script>
    
    
    <!-- Google Tag Manager (noscript) -->
    {!!($setting->GTM_noscript)?html_entity_decode($setting->GTM_noscript):''!!}
    <!-- End Google Tag Manager (noscript) -->
    
    <!-- FACEBOOK PIXEL Manager (noscript) -->
    {!!($setting->fb_pixel_noscript)?html_entity_decode($setting->fb_pixel_noscript):''!!}
    <!-- End FACEBOOK PIXEL Manager (noscript) -->
    
</body>

</html>
