@extends('layouts.app')
@section('title')
    @php echo $metatags @endphp
@endsection
@section('content')

        <!-- bread crumb area -->
    <div class="rts-bread-crumbarea-1 rts-section-gap bg_image">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-main-wrapper">
                        <h1 class="title">@lang('home.images_gallery')</h1>
                        <!-- breadcrumb pagination area -->
                        <div class="pagination-wrapper">
                            <a    href="{{url('/')}}"> @lang('home.home') </a>
                            <i class="fa-regular fa-chevron-right"></i>
                            <a    class="active" href="javascript:void;">@lang('home.images_gallery')
                            </a>
                        </div>
                        <!-- breadcrumb pagination area end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- bread crumb area end -->
    
    <div class="rts-section-gap rts-gallery-area">
        <div class="container">
            <div class="content-center">
                <div class="infinite-scroll">
                    <div class="row g-5 mt--20">
                    @forelse($images as $image)
                        <div class="col-lg-4">
                          <div class="single-gallery-style-one">
                            <a href="{{Helper::uploadedImagesPath('galleryImages',$image->img)}}" data-fancybox="gallery-row1" data-caption="Gallery A #1" class="thumbnail">
                              <img src="{{ isset($image->img) ? Helper::uploadedImagesPath('galleryImages',$image->img) : Helper::imageFilesPath('noimage.png')}}" alt="blog">
                            </a>
                          </div>
                        </div>
                    @empty
                        <div class="col-md-12 col-lg-12 col-xl-12 mb-3 text-center">
                            <img  src="{{ Helper::imageFilesPath('no_data.png')}}"width="400" alt="no data image">
                             <h4>{{trans('home.no data found in this page')}}</h4>
                         </div>
                    @endforelse
                    {{ $images->links() }}
                  </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jscroll/2.4.1/jquery.jscroll.min.js"></script>
    <script>
        $(document).ready(function() {
            $('nav[aria-label="Pagination Navigation"]').hide();
    
            var $scrollContainer;
            if (window.innerWidth <= 767) {
                $scrollContainer = $('.infinite-scroll'); // Mobile: Scroll container
            } else {
                $scrollContainer = $(window); // Desktop: Window scroll
            }
    
            var jscrollInstance = $('.infinite-scroll').jscroll({
                autoTrigger: true,
                loadingMsg: '<div class="loading"><b>Loading...</b></div>',
                padding: 0,
                nextSelector: 'nav[aria-label="Pagination Navigation"] a[rel="next"]',
                contentSelector: '.infinite-scroll .row',
                callback: function() {
                    var $container = $('.infinite-scroll');
                    var scrollHeightBeforeAppend = $container[0].scrollHeight;
                    var currentScrollTop = $container.scrollTop();
    
                    $('nav[aria-label="Pagination Navigation"]').remove();
    
                    if ($('nav[aria-label="Pagination Navigation"] a[rel="next"]').length === 0) {
                        jscrollInstance.destroy();
                    }
    
                    // Adjust scroll position to account for newly appended content
                    var scrollHeightAfterAppend = $container[0].scrollHeight;
                    var newContentHeight = scrollHeightAfterAppend - scrollHeightBeforeAppend;
    
                    if (window.innerWidth <= 767) {
                        $container.scrollTop(currentScrollTop + newContentHeight);
                    }
                }
            });
        });
</script>
@endsection