@extends('layouts.app')
@section('title')
    @php echo $metatags @endphp
    @php echo $schema @endphp
@endsection

@section('content')
   <!-- Start breadcrumb Area -->
    <div class="rbt-breadcrumb-default ptb--100 ptb_md--50 ptb_sm--30 bg-gradient-1">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-inner text-center">
                        <h1 class="title">{{__('home.contact-us')}}</h1>
                        <ul class="page-list">
                            <li class="rbt-breadcrumb-item"><a href="{{url('/')}}">@lang('home.home')</a></li>
                            <li>
                                <div class="icon-right"><i class="feather-chevron-right"></i></div>
                            </li>
                            <li class="rbt-breadcrumb-item active">{{__('home.contact-us')}}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Breadcrumb Area -->



 <div class="rbt-conatct-area rbt-section-gap">
        <div class="container">
            <div class="row g-5">
            @if ($setting->mobile)
                <div class="col-lg-4 col-md-6 col-sm-6 col-12 sal-animate" data-sal="slide-up" data-sal-delay="150"
                    data-sal-duration="800">
                    <div class="rbt-address">
                        <div class="icon">
                            <i class="feather-headphones"></i>
                        </div>
                        <div class="inner">
                            <h4 class="title">{{trans('home.Contact Phone Number')}}</h4>
                            @if ($setting->mobile)
                            @endif
                            <p><a href="tel:{{ $setting->mobile }}">{{ $setting->mobile }}</a></p>
                            @if ($setting->telphone)
                                <p><a href="tel:{{ $setting->telphone }}">{{ $setting->telphone }}</a></p>
                            @endif
                        </div>
                    </div>
                </div>
            @endif
            @if ($setting->email)
                <div class="col-lg-4 col-md-6 col-sm-6 col-12 sal-animate" data-sal="slide-up" data-sal-delay="200"
                    data-sal-duration="800">
                    <div class="rbt-address">
                        <div class="icon">
                            <i class="feather-mail"></i>
                        </div>
                        <div class="inner">
                            <h4 class="title">{{trans('home.Our Email Address')}}</h4>
                            <p><a href="mailto:{{$setting->email}}">{{$setting->email}}</a></p>
                        </div>
                    </div>
                </div>
            @endif
            @if ($configration->address1)
                <div class="col-lg-4 col-md-6 col-sm-6 col-12 sal-animate" data-sal="slide-up" data-sal-delay="250"
                        data-sal-duration="800">
                        <div class="rbt-address">
                            <div class="icon">
                                <i class="feather-map-pin"></i>
                            </div>
                            <div class="inner">
                                <h4 class="title">{{trans('home.Our Location')}}</h4>
                                <p>{{$configration->address1}}</p>
                            </div>
                        </div>
                    </div>
            @endif
            </div>
        </div>
    </div>

    <div class="rbt-contact-address">
        <div class="container">
            <div class="row justify-content-center g-5">
                <div class="col-lg-8">
                    <div class="rbt-contact-form contact-form-style-1 max-width-auto">
                        
                        <form action="{{ LaravelLocalization::localizeUrl('save/contact-us') }}" id="contact-form"  method="POST">
                            @csrf
                            <div>
                                <div class="form-group">
                                    <input name="name"  type="text" placeholder="{{ __('home.name') }} *" value="{{ old('name') }}" >
                                    <span class="focus-border"></span>
                                </div>
                                @error('name')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            <div>
                                <div class="form-group">
                                    <input name="phone"  type="text" placeholder="{{ __('home.phone') }} *" value="{{ old('phone') }}">
                                    <span class="focus-border"></span>
                                   
                                </div>
                                @error('phone')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            <div>
                                <div class="form-group">
                                    <input name="email"  type="email" placeholder="{{ __('home.email') }} *" value="{{ old('email') }}">
                                    <span class="focus-border"></span>
                                </div>
                                @error('email')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            <div>
                                <div class="form-group">
                                    <textarea name="message" cols="30" rows="4" placeholder="{{ __('home.message') }} *" >{{ old('message') }}</textarea>
                                    <span class="focus-border"></span>
                                </div>
                                @error('message')
                                        <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-submit-group">
                                <button name="submit" type="submit" id="submit"
                                    class="rbt-btn btn-md btn-gradient hover-icon-reverse w-100">
                                    <span class="icon-reverse-wrapper">
                                        <span class="btn-text">{{ __('home.send_message') }}</span>
                                        <span class="btn-icon"><i class="feather-arrow-right"></i></span>
                                        <span class="btn-icon"><i class="feather-arrow-right"></i></span>
                                    </span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    

    <div class="rbt-separator-mid">
        <div class="container">
            <hr class="rbt-separator m-0">
        </div>
    </div>


@endsection









