@extends('layouts.app')
@section('title')
 <title>{{__('home.companies_requests')}}</title>
@endsection

@section('content')
    <!-- bread crumb area -->
    <div class="rts-bread-crumbarea-1 rts-section-gap bg_image">
        <div class="container"> 
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-main-wrapper">
                        <h1 class="title">{{__('home.companies_requests')}}</h1>
                        <!-- breadcrumb pagination area -->
                        <div class="pagination-wrapper">
                            <a href="{{url('/')}}">@lang('home.home')</a>
                            <i class="fa-regular fa-chevron-right"></i>
                            <a class="active" href="javascript:void;">{{__('home.companies_requests')}}</a>
                        </div>
                        <!-- breadcrumb pagination area end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    
    <div class="rts-contact-area rts-section-gapTop rts-section-gapBottom">
        <div class="container">
            <div class="row g-5 justify-content-center">
                <div class="col-xl-8">
                    <!-- contact left area start -->
                    <div class="contact-left-area-start">
                        <div class="title-area-left-style mb-3">
                            <div class="pre-title">
                                <img src="{{ Helper::imageFilesPath('banner/bulb.png') }}" alt="icon">
                                <span>@lang('home.courses')</span>
                            </div>
                            <h2 class="title">{{ trans('home.join_us_to_get_courses') }}</h2>
                        </div>
                        <form action="{{ LaravelLocalization::localizeUrl('save/company-request') }}" id="company-request-form" class="contact-page-form row mx-0" method="POST">
                            @csrf
                            <div class="single-input col-md-6">
                                <input name="name" id="name" type="text" value="{{ old('name') }}" placeholder="{{ __('home.company_name') }} *" required>
                                @error('name')
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </div>
                                @enderror
                            </div>
                            <div class="single-input col-md-6">
                                <input name="activity" id="activity" value="{{ old('activity') }}" type="text" placeholder="{{ __('home.company_activity') }} *" required>
                                @error('activity')
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </div>
                                @enderror
                            </div>
                            <div class="single-input col-md-6">
                                <input name="responsible_name" id="responsible_name" value="{{ old('responsible_name') }}" type="text" placeholder="{{ __('home.responsible_name') }} *" required>
                                @error('responsible_name')
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </div>
                                @enderror
                            </div>
                            <div class="single-input col-md-6">
                                <input name="responsible_job" id="responsible_job" value="{{ old('responsible_job') }}" type="text" placeholder="{{ __('home.responsible_job') }} *" required>
                                @error('responsible_job')
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </div>
                                @enderror
                            </div>
                            <div class="single-input col-md-6">
                                <input name="phone" id="phone" type="text" value="{{ old('phone') }}" placeholder="{{ __('home.phone') }} *" required>
                                @error('phone')
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </div>
                                @enderror
                            </div>
                            <div class="single-input col-md-6">
                                <input name="email" id="email" type="email" value="{{ old('email') }}" placeholder="{{ __('home.email') }} *" required>
                                @error('email')
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </div>
                                @enderror
                            </div>
                            
                            <div class="single-input">
                                <textarea name="message" id="message" cols="30" rows="4" placeholder="{{ __('home.message') }} *" required>{{ old('message') }}</textarea>
                                @error('message')
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </div>
                                @enderror
                            </div>
                            <button class="rts-btn btn-primary" type="submit">{{ __('home.send_message') }}</button>
                        </form>

                        {{--<div id="form-messages  " class="mt--20"></div>--}}
                    </div>
                    <!-- contact left area end -->
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.6/dist/sweetalert2.all.min.js"></script>
<script>
     $(document).ready(function() {
        var registerdBefore = "{{ Session::has('registerd_before') }}";
        var requestSuccessMessage = "{{ Session::has('request_success_message') }}";

        $('#company-request-form').submit(function(event) {
            event.preventDefault();
            var formData = $(this).serialize();

            $.ajax({
                type: 'POST',
                url: "{{ LaravelLocalization::localizeUrl('save/company-request') }}",
                data: formData,
                success: function(response) {
                    if (response.status === 'error') {
                        Swal.fire({
                            icon: 'error',
                            title: '{{ trans("home.error") }}',
                            text: response.message
                        });
                    } else if (response.status === 'success') {
                        Swal.fire({
                            icon: 'success',
                            title: '{{ trans("home.registeration_success") }}',
                            text: response.message
                        }).then(() => {
                        window.location.reload(); // Reloads the page after the alert is closed
                    });
                    }
                },
                error: function(error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: error
                        // text: 'Something went wrong!'
                    });
                }
            });
        });
    });

</script>
@endsection
