@extends('layouts.app')
@section('title')
    <title>@lang('home.checkout')</title>
@endsection
@section('content')

<div class='container my-5'>
    <div class='row'>
        <div class='col-md-8 mb-3 mb-md-0'>
            <div class='checkContent'>
                <form action="{{route('checkout-call-back',['training'=> $training,'type'=>$paymentBrand])}}" class="paymentWidgets" data-brands="{{ $paymentBrand }}"></form>
                
            </div>
        </div>
        <div class='col-md-4 mb-3 mb-md-0'>
            <div class='checkContent'>
                <h3>
                    {{__('home.total_amount')}}
                </h3>
                <p>
                    {{$training->price . ' ' . __('home.SAR')}}
                </p>
            </div>
        </div>
    </div>
</div>


@endsection

@section('style')
   <style>
        body {background-color:#f6f6f5;}
   </style>

@endsection
@section('script')

<script src="https://eu-test.oppwa.com/v1/paymentWidgets.js?checkoutId={{$responseData->id}}"
        integrity="{{$responseData->integrity}}" crossorigin="anonymous">
</script>

<script type="text/javascript"> 
    var wpwlOptions = {
        paymentTarget: "_top",
    }
</script>



@endsection
