@extends('layouts.app')
@section('title')
    <title>{{$category->{'name_'.$lang} }}</title>
    @php echo $metatags @endphp
@endsection
@section('content')
  <!-- bread crumb area -->
    <div class="rts-bread-crumbarea-1 rts-section-gap bg_image">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-main-wrapper">
                        <h1 class="title">{{__('home.courses')}}</h1>
                        <!-- breadcrumb pagination area -->
                        <div class="pagination-wrapper">
                            <a href="{{url('/')}}">@lang('home.home')</a>
                            <i class="fa-regular fa-chevron-right"></i>
                            <a class="active">{{__('home.courses')}}</a>
                        </div>
                        <!-- breadcrumb pagination area end -->
                    </div>
                </div>
            </div>
        </div>
    </div>


        @if(count($courses) > 0)
    <!-- course area start -->
    <div class="rts-course-default-area rts-section-gap">
        <div class="container">
            <form id="filter_form">
                <div class="row g-5">
                    <div class="col-lg-3">
                        @php
                            $levels_filter = request()->has('levels') ?  request('levels') : [];
                            $categories_filter = request()->has('categories') ?  request('categories') : [];
                            $price_filter = request()->has('price') ?  request('price') : [];
                            $free_courses_count = $courses->where('price',0)->count(); 
                            $paid_courses_count = $courses->where('price','!=',0)->count(); 
                        @endphp
                        <!-- course-filter-area start -->
                        <div class="rts-course-filter-area">
                            <!-- single filter wized -->
                            <div class="single-filter-left-wrapper">
                                <h6 class="title">{{__('home.search')}}</h6>
                                <div class="search-filter filter-body">
                                    <div class="input-wrapper">
                                        <input type="text" class="autoComplete_courses"  placeholder="{{__('home.search for')}}..." name="search_input_courses" >
                                        <i onclick="document.getElementById('filter_form').submit()" class="fa-light fa-magnifying-glass"></i>
                                    </div>
                                </div>
                            </div>
                            <!-- single filter wized end -->
                            <!-- categories filter wized -->
                            <div class="single-filter-left-wrapper">
                                <!--<h6 class="title">@lang('home.category')</h6>-->
                                  <button class="btn secCollabse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
                                    @lang('home.category')
                                  </button>
                                <div class="checkbox-filter filter-body">
                                    <div class="collapse" id="collapseExample">
                                        <div class="checkbox-wrapper">
                                        @foreach ($categories as $category)                         
                                                <!-- single check box -->
                                                <div class="single-checkbox-filter">
                                                    <div class="check-box">
                                                        <input type="checkbox" name="categories[]" onchange="this.form.submit()" value="{{$category->id }}" 
                                                        @if (in_array($category->id,$categories_filter) )@checked(true)  @endif id="category-{{$category->id}}">
                                                        <label for="category-{{$category->id}}">{{$category->{'name_'.$lang} }}</label><br>
                                                    </div>
                                                    <span class="number">({{$category->coursesCount($levels_filter) }})</span>
                                                </div>
                                                <!-- single check box end -->
                                        @endforeach
                                    </div>
                                    </div>
                                </div>
                            </div>
                            <!-- categories filter wized end -->

                            <!-- single filter wized -->
                            {{-- <div class="single-filter-left-wrapper">
                                <h6 class="title">@lang('home.price')</h6>
                                <div class="checkbox-filter filter-body last">
                                    <div class="checkbox-wrapper">
                                        <!-- single check box -->
                                        <div class="single-checkbox-filter">
                                            <div class="check-box">
                                                <input type="checkbox" name="price[]"  @if (in_array('free',$price_filter) ) checked  @endif  onchange="this.form.submit()"  value="free" id="price-1">
                                                <label for="price-1">@lang('home.free')</label><br>
                                            </div>
                                            <span class="number">({{$free_courses_count}})</span>
                                        </div>
                                        <!-- single check box end -->
                                        <!-- single check box -->
                                        <div class="single-checkbox-filter">
                                            <div class="check-box">
                                                <input type="checkbox" name="price[]" @if (in_array('paid',$price_filter) ) checked  @endif  onchange="this.form.submit()"  value="paid" id="price-2">
                                                <label for="price-2">@lang('home.paid')</label><br>
                                            </div>
                                            <span class="number">({{$paid_courses_count}})</span>
                                        </div>
                                        <!-- single check box end -->
                                    </div>
                                </div>
                            </div> --}}
                            <!-- single filter wized end -->
                            @if (request()->has('levels')||request()->has('categories')||request()->has('price') ||request()->has('search_input_courses')  )
                                <a    href="{{url('/courses')}}" class="rts-btn btn-border"><i class="fa-regular fa-x"></i> {{__('home.clear_filter')}}</a>
                            @endif
                        </div>
                        <!-- course-filter-area end -->
                    </div>
                        <div class="col-lg-9">
                        <!-- filter top-area end -->
                            <div class="tab-content" id="myTabContent">
                                <div class="infinite-scroll">
                                    <div class="row g-5 mb-5">
                                        @foreach ($courses as $course)
                                            <div class="col-lg-4 col-md-6 col-sm-6 col-12">
                                                <!-- single course style two -->
                                                <div class="single-course-style-three">
                                                    <a    href="{{ LaravelLocalization::localizeUrl('course/' . $course->{'link_'.$lang}) }}" class="thumbnail">
                                                        <img src="{{ isset($course->image) ? Helper::uploadedImagesPath('courses/source', $course->image) : Helper::imageFilesPath('noimage.png') }}" alt="course">
                                                        <div class="tag-thumb">
                                                            <span>{{ $course->category->{'name_' . $lang} ?? '' }}</span>
                                                        </div>
                                                    </a>
                                                    <div class="body-area">
                                                        <div class="course-top">
                                                            <div class="price">
                                                                @if ($course->discount)
                                                                    {{--<h4 class="none"> {{ $course->price . ' ' . __('home.SAR') }}</h4>
                                                                    <span class="discount">-{{ round((($course->price - $course->last_price()) / $course->price) * 100,2) }}%</span>--}}
                                                                    
                                                                    <div class="price">
                                                                        {{ $course->last_price() . ' ' . __('home.SAR') }}  
                                                                        <small style='font-size: 18px; text-decoration: line-through; color: #727272;'> {{ $course->price . ' ' . __('home.SAR') }} </small>
                                                                    </div>
                                                                    @if(isset($course->discount->end_date))
                                                                        <div class="clock-area">
                                                                            <i class="ms-1 fa-light fa-clock"></i>
                                                                            @php
                                                                                $end_date = \Carbon\Carbon::parse($course->discount->end_date);
                                                                                $daysLeft = \Carbon\Carbon::now()->diffInDays($end_date);
                                                                            @endphp
                                                                            <span class="text-danger">{{ $daysLeft }} @lang('home.Day left at this price!')</span>
                                                                        </div>
                                                                    @endif
                                                                @else
                                                                    <div class="price">
                                                                        {{ $course->last_price() . ' ' . __('home.SAR') }}
                                                                    </div>
                                                                @endif
                                                            </div>
                                                        </div>
                                                        <a href="{{ LaravelLocalization::localizeUrl('course/' . $course->{'link_'.$lang} ) }}">
                                                            <h5 class="title">{{ $course->{'name_' . $lang} }}</h5>
                                                        </a>
                                                        <p class=' mb-3 rounded d-inline-block p-2 border ' style='      border: 1px solid #f379245c !important; font-size: 13px;  padding: 3px 6px !important;'>{{ $course->field->{'name_' . $lang} }}</p>
                                                        {{--<div class="teacher-stars row">
                                                            @if($course->teachers())
                                                                @foreach ($course->teachers() as $teacher)
                                                                    <span class="teacher mx-2 col-auto">{{ $teacher->name }}</span>
                                                                    @if (!$loop->last)
                                                                        /
                                                                    @endif
                                                                @endforeach
                                                            @endif
                                                            <ul class="stars col-auto">
                                                                @if ($course->rate != 0)
                                                                    <span class="span">{{ $course->rate }}</span>
                                                                @endif
                                                                <?php $rate = intval($course->rate); ?>
                                                                @for ($i = 1; $i <= $rate; $i++)
                                                                    <li><i class="fa-sharp fa-solid fa-star"></i></li>
                                                                @endfor
                                                                @for ($i = 1; $i <= 5 - $rate; $i++)
                                                                    <li><i class="fa-sharp fa-regular fa-star"></i></li>
                                                                @endfor
                                                            </ul>
                                                        </div>--}}
                                                        <p class=' mb-3 rounded d-inline-block p-2 border 'style=' background: #f379241f;  color: #f37924;   border: 1px solid #f379245c !important; font-size: 13px;  padding: 3px 6px !important;'>
                                                            <i class="ms-1 fa-solid fa-clipboard-user"></i>
                                                            {{ $course->type->{'name_'.$lang} }}   
                                                        </p>
                                                       <div class="leasson-students">
                                                            <div class="lesson">
                                                                <i class="fa-regular fa-clock"></i>
                                                                <span>{{ $course->duration }}</span>
                                                            </div>
                                                            <div class="lesson">
                                                                <i class="fa-light fa-calendar-lines-pen"></i>
                                                                <span>  {{ $course->overall_days }}</span>
                                                            </div>
                                                             <div class="button-area">
                                                                <a href="{{ LaravelLocalization::localizeUrl('course/' . $course->{'link_'.$lang}) }}"   class="rts-btn btn-primary px-3 py-2 ">  {{ trans('home.register_now') }}  </a>
                                                             </div>
                                                        </div> 
                                                        <div class="course-content-area">
                                                            <h6 class="heading-title">
                                                                <a    href="{{ LaravelLocalization::localizeUrl('course/' . $course->{'link_'.$lang} ) }}">{{ $course->{'name_' . $lang} ?? '' }}</a>
                                                            </h6>
                                                            <p class=' mb-3 rounded d-inline-block p-2 border '>{{ $course->field->{'name_' . $lang} }}</p>
                                                         {{--  <div class="tags-area-wrapper">
                                                                  <div class="single-tag">
                                                                    <span>{{$course->level->{'name_'.$lang} ?? '' }}</span>
                                                                </div>
                                                              <div class="lesson-studente">
                                                                    <div class="lesson">
                                                                        <i class="fa-light fa-calendar-lines-pen"></i>
                                                                        <span>@if($course->course) {{ $course->course->countLessons() }} @else 0 @endif @lang('home.lessons')</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            @if ($course->{'text_'.$lang})
                                                                <p class="desc">{{ substr(strip_tags($course->{'text_'.$lang}), 0, 150).'... ' }}</p>
                                                            @endif
                                                            @if($course->points())
                                                            <ul class="wrapper-list">
                                                                @foreach ($course->points() as $point)
                                                                    <li><i class="fa-solid fa-check"></i>{{$point->{'text_'.$lang} }}</li>                                                        
                                                                @endforeach
                                                            </ul>
                                                            @endif
                                                            --}}
                                                            <div class="button-area">
                                                                <a href="javascript:void(0)" data-course_id="{{$course->id}}" class="rts-btn btn-primary addToCart">@lang('home.Add to Cart')</a>
                                                                <a href="javascript:void(0)" data-course_id="{{$course->id}}" class="addToWislist wishlist-btn"><i class="fa-thin fa-circle-heart"></i></a>
                                                            </div>
                                                            <div class="shape">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- single course style two end -->
                                            </div>                                    
                                        @endforeach
                                        {{ $courses->links() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- course area end -->
    @else
        <div class="col-md-12 col-lg-12 col-xl-12 mb-3 text-center">
            <img  src="{{ Helper::imageFilesPath('no_data.png')}}"width="400" alt="no data image">
            <h4>{{trans('home.no data found in this page')}}</h4>
        </div>
    @endif

@endsection
@section ('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jscroll/2.4.1/jquery.jscroll.min.js"></script>
    <script>
    $(document).ready(function() {
        $('nav[aria-label="Pagination Navigation"]').hide();

        var $scrollContainer;
        if (window.innerWidth <= 767) {
            $scrollContainer = $('.infinite-scroll'); // Mobile: Scroll container
        } else {
            $scrollContainer = $(window); // Desktop: Window scroll
        }

        var jscrollInstance = $('.infinite-scroll').jscroll({
            autoTrigger: true,
            loadingMsg: '<div class="loading"><b>Loading...</b></div>',
            padding: 0,
            nextSelector: 'nav[aria-label="Pagination Navigation"] a[rel="next"]',
            contentSelector: '.infinite-scroll .row',
            callback: function() {
                var $container = $('.infinite-scroll');
                var scrollHeightBeforeAppend = $container[0].scrollHeight;
                var currentScrollTop = $container.scrollTop();

                $('nav[aria-label="Pagination Navigation"]').remove();

                if ($('nav[aria-label="Pagination Navigation"] a[rel="next"]').length === 0) {
                    jscrollInstance.destroy();
                }

                // Adjust scroll position to account for newly appended content
                var scrollHeightAfterAppend = $container[0].scrollHeight;
                var newContentHeight = scrollHeightAfterAppend - scrollHeightBeforeAppend;

                if (window.innerWidth <= 767) {
                    $container.scrollTop(currentScrollTop + newContentHeight);
                }
            }
        });
    });
</script>

    <script>
        $('.autoCompleteProduct').on('change', function () {
            $('#filter_form').submit();
        });
        // Initialize autocomplete
        function auto() {
            var options2 = {
                url: function (phrase) {
                    return "{{ url('searchAutoComplete') }}";
                },
                ajaxSettings: {
                    dataType: "json",
                    method: "GET",
                    data: {
                        dataType: "json"
                    }
                },
                getValue: function (element) {
                    return element.name;
                },
                preparePostData: function (data) {
                    data.phrase = $('.autoComplete_courses').val();
                    return data;
                },
                list: {
                    match: {
                        enabled: true
                    }
                }
            };

            $('.autoComplete_courses').easyAutocomplete(options2);
        }

        $(document).ready(function() {
            auto();
        });
    </script>

@endsection