@extends('layouts.app')
@section('title')
    <title>{{__('home.categories') }}</title>
@endsection
@section('content')
<!-- bread crumb area -->
    <div class="rts-bread-crumbarea-1 rts-section-gap bg_image">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-main-wrapper">
                        <h1 class="title">{{__('home.categories') }}</h1>
                        <!-- breadcrumb pagination area -->
                        <div class="pagination-wrapper">
                            <a href="{{url('/')}}">@lang('home.home')</a>
                            <i class="fa-regular fa-chevron-right"></i>
                            <a class="active" >{{__('home.categories') }}</a>
                        </div>
                        <!-- breadcrumb pagination area end -->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- category area start -->
    <div class="category-area-style-one category-area-style-page  shape-move rts-section-gap bg_image bg-white">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="title-area-center-style">
                        <div class="pre-title">
                            <img src="{{ Helper::imageFilesPath('banner/bulb.png') }}" alt="icon">
                            <span>{{__('home.all_categories') }}</span>
                        </div>
                        <h2 class="title">{{__('home.explore_all_categories')}}</h2>
                    </div>
                </div>
            </div>
            <div class="row mt--50">
                <div class="col-lg-12">
                    <div class="category-swiper-wrapper">
                        <div class="swiper mySwiper-category-1">
                            <div class="row justify-content-center">
                                @forelse ($categories as $category)                                  
                                    <!-- single cat -->
                                    <div class="col-xl-2 col-lg-3 col-md-4 col-6 mb-3">
                                        <a href="{{ LaravelLocalization::localizeUrl('category/' . $category->{'link_' . $lang}) }}" class="category-style-one">
                                            <div class="icon">
                                                    @if($category->image)
                                                        <img src="{{ Helper::uploadedImagesPath('categories/source', $category->image) }}" alt="{{$category->{'name_'.$lang} }}">
                                                    @else
                                                        <img src="{{Helper::imageFilesPath('noimage.png')}}" alt="{{auth()->user()?->name() }}">
                                                    @endif
                                               {{-- <img src="{{ Helper::uploadedImagesPath('categories/source', $category->image) }}" alt="{{$category->{'name_'.$lang} }}">  --}}
                                            </div>
                                            <h5 class="title">{{$category->{'name_'.$lang} }}</h5>
                                            <span>{{count($category->courses)}} + @lang('home.courses')</span>
                                        </a>
                                    </div>
                                    <!-- single cat -->
                                @empty
                                    <div class="col-md-12 col-lg-12 col-xl-12 mb-3 text-center">
                                        <img  src="{{ Helper::imageFilesPath('no_data.png')}}"width="400" alt="no data image">
                                        <h4>{{trans('home.no data found in this page')}}</h4>
                                    </div>
                                @endforelse
                                
                            </div>
                        
                        </div>
                    </div>
                </div>
            </div>

      
        </div>
        <div class="shape-image">
            <div class="shape one" data-speed="0.04" data-revert="true"><img src="{{ Helper::imageFilesPath('banner/15.png') }}" alt=""></div>
            <div class="shape two" data-speed="0.04"><img src="{{ Helper::imageFilesPath('banner/shape/banner-shape02.svg') }}" alt=""></div>
            <div class="shape three" data-speed="0.04"><img src="{{ Helper::imageFilesPath('banner/shape/03.svg') }}" alt=""></div>
        </div>
    </div>
    <!-- category area end -->

@endsection