@extends('layouts.app')
@section('title')
    @php echo $metatags @endphp
@endsection

@section('content')
   <!-- Start breadcrumb Area -->
    <div class="rbt-breadcrumb-default ptb--100 ptb_md--50 ptb_sm--30 bg-gradient-1">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-inner text-center">
                        <h1 class="title">{{__('home.blogs')}}</h1>
                        <ul class="page-list">
                            <li class="rbt-breadcrumb-item"><a href="{{url('/')}}">@lang('home.home')</a></li>
                            <li>
                                <div class="icon-right"><i class="feather-chevron-right"></i></div>
                            </li>
                            <li class="rbt-breadcrumb-item active">{{__('home.blogs')}}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Breadcrumb Area -->

    <!-- Start About us Section -->
    <div class="bg-color-white rbt-section-gap">
        <div class="container">
            <div class="infinite-scroll">

            <!-- Start Card Area -->
            <div class="row g-5 mt--15">
                @forelse($blogs as $blog)
                 <!-- Start Single Card  -->
                    <div class="col-lg-4 col-md-6 col-sm-12 col-12">
                        <div class="rbt-card variation-02 rbt-hover">
                            <div class="rbt-card-img">
                                <a href="{{LaravelLocalization::localizeUrl('blogs/'.$blog->{'link_'.$lang} )}}">
                                    <img src="{{ isset($blog->image) ? Helper::uploadedImagesPath('blogitems',$blog->image) : Helper::imageFilesPath('noimage.png') }}" alt="{{$blog->alt_img}}"> </a>
                            </div>
                            <div class="rbt-card-body">
                                <h5 class="rbt-card-title"><a href="{{LaravelLocalization::localizeUrl('blogs/'.$blog->{'link_'.$lang} )}}">{{$blog->{'name_'.$lang} }}</a></h5>
                                <p class="rbt-card-text">{!! \Illuminate\Support\Str::limit(strip_tags($blog->{'text_'.$lang}), 50) !!}</p>
                                <div class="rbt-card-bottom">
                                    <a class="transparent-button" href="{{LaravelLocalization::localizeUrl('blogs/'.$blog->{'link_'.$lang} )}}"><i><svg width="17" height="12" xmlns="http://www.w3.org/2000/svg"><g stroke="#27374D" fill="none" fill-rule="evenodd"><path d="M10.614 0l5.629 5.629-5.63 5.629"/><path stroke-linecap="square" d="M.663 5.572h14.594"/></g></svg></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End Single Card  -->
                @empty
                    <div class="col-md-12 col-lg-12 col-xl-12 mb-3 text-center">
                        <h4>{{trans('home.no data found in this page')}}</h4>
                    </div>
                @endforelse
                {!! $blogs->links() !!}
            </div>
            <!-- End Card Area -->
            </div>

        </div>
    </div>
    <!-- End About us Section -->


    <div class="rbt-separator-mid">
        <div class="container">
            <hr class="rbt-separator m-0">
        </div>
    </div>

@endsection
@section('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jscroll/2.4.1/jquery.jscroll.min.js"></script>
    <script>
        $(document).ready(function() {
            $('nav[aria-label="Pagination Navigation"]').hide();
    
            var $scrollContainer;
            if (window.innerWidth <= 767) {
                $scrollContainer = $('.infinite-scroll'); // Mobile: Scroll container
            } else {
                $scrollContainer = $(window); // Desktop: Window scroll
            }
    
            var jscrollInstance = $('.infinite-scroll').jscroll({
                autoTrigger: true,
                loadingMsg: '<div class="loading"><b>Loading...</b></div>',
                padding: 0,
                nextSelector: 'nav[aria-label="Pagination Navigation"] a[rel="next"]',
                contentSelector: '.infinite-scroll .row',
                callback: function() {
                    var $container = $('.infinite-scroll');
                    var scrollHeightBeforeAppend = $container[0].scrollHeight;
                    var currentScrollTop = $container.scrollTop();
    
                    $('nav[aria-label="Pagination Navigation"]').remove();
    
                    if ($('nav[aria-label="Pagination Navigation"] a[rel="next"]').length === 0) {
                        jscrollInstance.destroy();
                    }
    
                    // Adjust scroll position to account for newly appended content
                    var scrollHeightAfterAppend = $container[0].scrollHeight;
                    var newContentHeight = scrollHeightAfterAppend - scrollHeightBeforeAppend;
    
                    if (window.innerWidth <= 767) {
                        $container.scrollTop(currentScrollTop + newContentHeight);
                    }
                }
            });
        });
</script>
@endsection
