<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Document</title>
  <style>
        @import url("https://fonts.googleapis.com/css?family=Quicksand:400,500,700&subset=latin-ext");
        ::-webkit-scrollbar {
  width: 7px; 
}


::-webkit-scrollbar-track {
  background-color: #fce0d4 ; 
}


::-webkit-scrollbar-thumb {
  background-color: #f16426; 
  width: 10px;
}


::-webkit-scrollbar-thumb:hover {
  color: #f16426; 
}
    html {
      position: relative;
      overflow-x: hidden !important;
    }
    
    * {
      box-sizing: border-box;
    }
    
    body {
      font-family: "Quicksand", sans-serif;
      color: #324e63;
      margin:0;
    }
    
    a, a:hover {
      text-decoration: none;
    }
    
    .icon {
      display: inline-block;
      width: 1em;
      height: 1em;
      stroke-width: 0;
      stroke: currentColor;
      fill: currentColor;
    }
    
    .wrapper {
      width: 100%;
      width: 100%;
      height: auto;
      min-height: 100vh;
      padding: 50px 20px;
      padding-top: 100px;
      display: flex;
      background-image: linear-gradient(-20deg, #fdf3ef 0%, #f16426 100%);
      display: flex; 
    }
    @media screen and (max-width: 768px) {
      .wrapper {
        height: auto;
        min-height: 100vh;
        padding-top: 100px;
      }
    }
    
    .profile-card {
      width: 100%;
      min-height: 460px;
      margin: auto; 
      background: transparent;
      border-radius: 12px;
      max-width: 700px;
      position: relative;
    }
    .profile-card.active .profile-card__cnt {
      filter: blur(6px);
    }
    .profile-card.active .profile-card-message,
    .profile-card.active .profile-card__overlay {
      opacity: 1;
      pointer-events: auto;
      transition-delay: 0.1s;
    }
    .profile-card.active .profile-card-form {
      transform: none;
      transition-delay: 0.1s;
    }
    
    @media screen and (max-width: 576px) {
      .profile-card__img {
        width: 220px; 
      }
    }
   
    .profile-card__cnt { 
      text-align: center;
      padding: 0 20px;
      padding-bottom: 40px;
      transition: all 0.3s;
    }
   
  
   
    .profile-card-loc {
      display: flex;
      justify-content: center;
      align-items: center;
      font-size: 18px;
      font-weight: 600;
    }
    .profile-card-loc__icon {
      display: inline-flex;
      font-size: 27px;
      margin-right: 10px;
    }
    
   
   
    .profile-card-inf__title {
      font-weight: 700;
      font-size: 27px;
      color: #324e63;
    }
    .profile-card-inf__txt {
      font-weight: 500;
      margin-top: 7px;
    }
    .profile-card-social {
      margin-top: 25px;
      display: flex;
      justify-content: center;
      align-items: center;
      flex-direction: column;
    }
    .profile-card-social__item {
             display: flex;
    width: 100%;
    height: 62px;
    margin: 15px;
    border-radius: 20px;
    align-items: center;
    background: #ffffffb8 !important;
    color: #585858;
    padding: 0 23px;
    justify-content: space-between;
    position: relative;
    font-size: 23px;
    transition: all 0.3s;
    }
    @media screen and (max-width: 768px) {
      .profile-card-social__item {
  
        margin: 10px;
      }
    }
    @media screen and (min-width: 768px) {
      .profile-card-social__item:hover {
        transform: scale(1.2);
      }
    }
    .profile-card-social__item.facebook {
      background: linear-gradient(45deg, #3b5998, #0078d7);
      box-shadow: 0px 4px 30px rgba(43, 98, 169, 0.5);
    }
    .profile-card-social__item.twitter {
      background: linear-gradient(45deg, #1da1f2, #0e71c8);
      box-shadow: 0px 4px 30px rgba(19, 127, 212, 0.7);
    }
    .profile-card-social__item.instagram {
      background: linear-gradient(45deg, #405de6, #5851db, #833ab4, #c13584, #e1306c, #fd1d1d);
      box-shadow: 0px 4px 30px rgba(120, 64, 190, 0.6);
    }
    .profile-card-social__item.linkedin {
      background: linear-gradient(45deg, #405de6, #5851db, #833ab4, #c13584, #e1306c, #fd1d1d);
      box-shadow: 0px 4px 30px rgba(120, 64, 190, 0.6);
    }
    .profile-card-social__item.tiktok {
      background: linear-gradient(45deg, #405de6, #5851db, #833ab4, #c13584, #e1306c, #fd1d1d);
      box-shadow: 0px 4px 30px rgba(120, 64, 190, 0.6);
    }
    .profile-card-social__item.snapchat {
      background: linear-gradient(45deg, #405de6, #5851db, #833ab4, #c13584, #e1306c, #fd1d1d);
      box-shadow: 0px 4px 30px rgba(120, 64, 190, 0.6);
    }
    .profile-card-social__item.behance {
      background: linear-gradient(45deg, #1769ff, #213fca);
      box-shadow: 0px 4px 30px rgba(27, 86, 231, 0.7);
    }
    .profile-card-social__item.github {
      background: linear-gradient(45deg, #333333, #626b73);
      box-shadow: 0px 4px 30px rgba(63, 65, 67, 0.6);
    }
    .profile-card-social__item.codepen {
      background: linear-gradient(45deg, #324e63, #414447);
      box-shadow: 0px 4px 30px rgba(55, 75, 90, 0.6);
    }
    .profile-card-social__item.link {
      background: linear-gradient(45deg, #d5135a, #f05924);
      box-shadow: 0px 4px 30px rgba(223, 45, 70, 0.6);
    }
    .profile-card-social .icon-font {
      display: inline-flex;
    }
    .profile-card-ctr {
      display: flex;
      justify-content: center;
      align-items: center;
      margin-top: 40px;
    }
    @media screen and (max-width: 576px) {
      .profile-card-ctr {
        flex-wrap: wrap;
      }
    }
    .profile-card__button {
      background: none;
      border: none;
      font-family: "Quicksand", sans-serif;
      font-weight: 700;
      font-size: 19px;
      margin: 15px 35px;
      padding: 15px 40px;
      min-width: 201px;
      border-radius: 50px;
      min-height: 55px;
      color: #fff;
      cursor: pointer;
      backface-visibility: hidden;
      transition: all 0.3s;
    }
    @media screen and (max-width: 768px) {
      .profile-card__button {
        min-width: 170px;
        margin: 15px 25px;
      }
    }
    @media screen and (max-width: 576px) {
      .profile-card__button {
        min-width: inherit;
        margin: 0;
        margin-bottom: 16px;
        width: 100%;
        max-width: 300px;
      }
      .profile-card__button:last-child {
        margin-bottom: 0;
      }
    }
    .profile-card__button:focus {
      outline: none !important;
    }
    @media screen and (min-width: 768px) {
      .profile-card__button:hover {
        transform: translateY(-5px);
      }
    }
    .profile-card__button:first-child {
      margin-left: 0;
    }
    .profile-card__button:last-child {
      margin-right: 0;
    }
    .profile-card__button.button--blue {
      background: linear-gradient(45deg, #1da1f2, #0e71c8);
      box-shadow: 0px 4px 30px rgba(19, 127, 212, 0.4);
    }
    .profile-card__button.button--blue:hover {
      box-shadow: 0px 7px 30px rgba(19, 127, 212, 0.75);
    }
    .profile-card__button.button--orange {
     background: linear-gradient(45deg, #f69b73, #f05924);
    box-shadow: 0px 4px 30px rgba(223, 45, 70, 0.35);
    }
    .profile-card__button.button--orange:hover {
      box-shadow: 0px 7px 30px rgba(223, 45, 70, 0.75);
    }
    .profile-card__button.button--gray {
      box-shadow: none;
      background: #dcdcdc;
      color: #142029;
    }
    .profile-card-message {
      width: 100%;
      height: 100%;
      position: absolute;
      top: 0;
      left: 0;
      padding-top: 130px;
      padding-bottom: 100px;
      opacity: 0;
      pointer-events: none;
      transition: all 0.3s;
    }
    .profile-card-form {
      box-shadow: 0 4px 30px rgba(15, 22, 56, 0.35);
      max-width: 80%;
      margin-left: auto;
      margin-right: auto;
      height: 100%;
      background: #fff;
      border-radius: 10px;
      padding: 35px;
      transform: scale(0.8);
      position: relative;
      z-index: 3;
      transition: all 0.3s;
    }
    @media screen and (max-width: 768px) {
      .profile-card-form {
        max-width: 90%;
        height: auto;
      }
    }
    @media screen and (max-width: 576px) {
      .profile-card-form {
        padding: 20px;
      }
    }
    .profile-card-form__bottom {
      justify-content: space-between;
      display: flex;
    }
    @media screen and (max-width: 576px) {
      .profile-card-form__bottom {
        flex-wrap: wrap;
      }
    }
    .profile-card textarea {
      width: 100%;
      resize: none;
      height: 210px;
      margin-bottom: 20px;
      border: 2px solid #dcdcdc;
      border-radius: 10px;
      padding: 15px 20px;
      color: #324e63;
      font-weight: 500;
      font-family: "Quicksand", sans-serif;
      outline: none;
      transition: all 0.3s;
    }
    .profile-card textarea:focus {
      outline: none;
      border-color: #8a979e;
    }
    .profile-card__overlay {
      width: 100%;
      height: 100%;
      position: absolute;
      top: 0;
      left: 0;
      pointer-events: none;
      opacity: 0;
      background: rgba(22, 33, 72, 0.35);
      border-radius: 12px;
      transition: all 0.3s;
    }@import url("https://fonts.googleapis.com/css?family=Quicksand:400,500,700&subset=latin-ext");
    html {
      position: relative;
      overflow-x: hidden !important;
    }
    
    * {
      box-sizing: border-box;
    }
    
    body {
      font-family: "Quicksand", sans-serif;
      color: #324e63;
    }
    
    a, a:hover {
      text-decoration: none;
    }
    
    .icon {
      display: inline-block;
      width: 1em;
      height: 1em;
      stroke-width: 0;
      stroke: currentColor;
      fill: currentColor;
    }
    
   
    @media screen and (max-width: 768px) {
      .wrapper {
        height: auto;
        min-height: 100vh;
        padding-top: 100px;
      }
    }
    
  
    .profile-card.active .profile-card__cnt {
      filter: blur(6px);
    }
    .profile-card.active .profile-card-message,
    .profile-card.active .profile-card__overlay {
      opacity: 1;
      pointer-events: auto;
      transition-delay: 0.1s;
    }
    .profile-card.active .profile-card-form {
      transform: none;
      transition-delay: 0.1s;
    }
    .profile-card__img {
         width: 310px;
            margin-left: auto;
            margin-right: auto;
            transform: translateY(-50%);
            border-radius: 8px;
            padding: 16px;
            background: #ffffffc2;
            overflow: hidden;
            position: relative;
            z-index: 4;
            box-shadow: 0px 5px 50px 0px #f16726, 0px 0px 0px 7px rgb(240 97 39 / 17%);
    }
    @media screen and (max-width: 576px) {
      .profile-card__img {
        width: 220px; 
      }
    }
    .profile-card__img img {
         display: block;
            width: 100%;
            height: 100%;  
    }
   
    .profile-card__name {
      font-weight: 700;
        font-size: 36px;
        color: #373737;
        margin-bottom: 15px;
    }
   
    
    .profile-card-loc {
      display: flex;
      justify-content: center;
      align-items: center;
      font-size: 18px;
      font-weight: 600;
    }
    .profile-card-loc__icon {
      display: inline-flex;
      font-size: 27px;
      margin-right: 10px;
    }
    .profile-card-inf {
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      align-items: flex-start;
      margin-top: 35px;
    }
    .profile-card-inf__item {
      padding: 10px 35px;
      min-width: 150px;
    }
    @media screen and (max-width: 768px) {
      .profile-card-inf__item {
        padding: 10px 20px;
        min-width: 120px;
      }
    }
    .profile-card-inf__title {
      font-weight: 700;
      font-size: 27px;
      color: #324e63;
    }
    .profile-card-inf__txt {
      font-weight: 500;
      margin-top: 7px;
    }
  
  
     
    @media screen and (min-width: 768px) {
      .profile-card-social__item:hover {
        transform: scale(1.2);
      }
    }
    .profile-card-social__item.facebook {
      background: linear-gradient(45deg, #3b5998, #0078d7);
      box-shadow: 0px 4px 30px rgba(43, 98, 169, 0.5);
    }
    .profile-card-social__item.twitter {
      background: linear-gradient(45deg, #1da1f2, #0e71c8);
      box-shadow: 0px 4px 30px rgba(19, 127, 212, 0.7);
    }
    .profile-card-social__item.instagram {
      background: linear-gradient(45deg, #405de6, #5851db, #833ab4, #c13584, #e1306c, #fd1d1d);
      box-shadow: 0px 4px 30px rgba(120, 64, 190, 0.6);
    }
    .profile-card-social__item.behance {
      background: linear-gradient(45deg, #1769ff, #213fca);
      box-shadow: 0px 4px 30px rgba(27, 86, 231, 0.7);
    }
    .profile-card-social__item.github {
      background: linear-gradient(45deg, #333333, #626b73);
      box-shadow: 0px 4px 30px rgba(63, 65, 67, 0.6);
    }
    .profile-card-social__item.codepen {
      background: linear-gradient(45deg, #324e63, #414447);
      box-shadow: 0px 4px 30px rgba(55, 75, 90, 0.6);
    }
    .profile-card-social__item.link {
      background: linear-gradient(45deg, #d5135a, #f05924);
      box-shadow: 0px 4px 30px rgba(223, 45, 70, 0.6);
    }
    .profile-card-social .icon-font {
      display: inline-flex;
    }
    .profile-card-ctr {
      display: flex;
      justify-content: center;
      align-items: center;
      margin-top: 40px;
    }
    @media screen and (max-width: 576px) {
      .profile-card-ctr {
        flex-wrap: wrap;
      }
    }
    .profile-card__button {
      background: none;
      border: none;
      font-family: "Quicksand", sans-serif;
      font-weight: 700;
      font-size: 19px;
      margin: 15px 35px;
      padding: 15px 40px;
      min-width: 201px;
      border-radius: 50px;
      min-height: 55px;
      color: #fff;
      cursor: pointer;
      backface-visibility: hidden;
      transition: all 0.3s;
    }
    @media screen and (max-width: 768px) {
      .profile-card__button {
        min-width: 170px;
        margin: 15px 25px;
      }
    }
    @media screen and (max-width: 576px) {
      .profile-card__button {
        min-width: inherit;
        margin: 0;
        margin-bottom: 16px;
        width: 100%;
        max-width: 300px;
      }
      .profile-card__button:last-child {
        margin-bottom: 0;
      }
    }
    .profile-card__button:focus {
      outline: none !important;
    }
    @media screen and (min-width: 768px) {
      .profile-card__button:hover {
        transform: translateY(-5px);
      }
    }
    .profile-card__button:first-child {
      margin-left: 0;
    }
    .profile-card__button:last-child {
      margin-right: 0;
    }
    .profile-card__button.button--blue {
      background: linear-gradient(45deg, #1da1f2, #0e71c8);
      box-shadow: 0px 4px 30px rgba(19, 127, 212, 0.4);
    }
    .profile-card__button.button--blue:hover {
      box-shadow: 0px 7px 30px rgba(19, 127, 212, 0.75);
    }
  
    .profile-card__button.button--orange:hover {
      box-shadow: 0px 7px 30px rgba(223, 45, 70, 0.75);
    }
    .profile-card__button.button--gray {
      box-shadow: none;
      background: #dcdcdc;
      color: #142029;
    }
    .profile-card-message {
      width: 100%;
      height: 100%;
      position: absolute;
      top: 0;
      left: 0;
      padding-top: 130px;
      padding-bottom: 100px;
      opacity: 0;
      pointer-events: none;
      transition: all 0.3s;
    }
    .profile-card-form {
      box-shadow: 0 4px 30px rgba(15, 22, 56, 0.35);
      max-width: 80%;
      margin-left: auto;
      margin-right: auto;
      height: 100%;
      background: #fff;
      border-radius: 10px;
      padding: 35px;
      transform: scale(0.8);
      position: relative;
      z-index: 3;
      transition: all 0.3s;
    }
    @media screen and (max-width: 768px) {
      .profile-card-form {
        max-width: 90%;
        height: auto;
      }
    }
    @media screen and (max-width: 576px) {
      .profile-card-form {
        padding: 20px;
      }
    }
    .profile-card-form__bottom {
      justify-content: space-between;
      display: flex;
    }
    @media screen and (max-width: 576px) {
      .profile-card-form__bottom {
        flex-wrap: wrap;
      }
    }
    .profile-card textarea {
      width: 100%;
      resize: none;
      height: 210px;
      margin-bottom: 20px;
      border: 2px solid #dcdcdc;
      border-radius: 10px;
      padding: 15px 20px;
      color: #324e63;
      font-weight: 500;
      font-family: "Quicksand", sans-serif;
      outline: none;
      transition: all 0.3s;
    }
    .profile-card textarea:focus {
      outline: none;
      border-color: #8a979e;
    }
    .profile-card__overlay {
      width: 100%;
      height: 100%;
      position: absolute;
      top: 0;
      left: 0;
      pointer-events: none;
      opacity: 0;
      background: rgba(22, 33, 72, 0.35);
      border-radius: 12px;
      transition: all 0.3s;
    }
</style>
</head>
<body>
  

<div class="wrapper">
  <div class="profile-card js-profile-card">
    <div class="profile-card__img">
      <img src="https://www.betraining.com.sa/uploads/settings/71504.png" alt="profile card">
    </div>

    <div class="profile-card__cnt js-profile-cnt">
      <div class="profile-card__name">  Be training  </div> 
      <div class="profile-card-loc">
      

       
      </div>

     
      <div class="profile-card-social">
        <a href="https://www.facebook.com/" class="profile-card-social__item facebook" target="_blank">
          <span class="icon-font">
            <svg fill="#000000" width="35px" height="35px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="M21.95 5.005l-3.306-.004c-3.206 0-5.277 2.124-5.277 5.415v2.495H10.05v4.515h3.317l-.004 9.575h4.641l.004-9.575h3.806l-.003-4.514h-3.803v-2.117c0-1.018.241-1.533 1.566-1.533l2.366-.001.01-4.256z"/></svg>          </span>
          <span class=" ">
              Facebook
          </span>
          
        </a>

         

        <a href="https://www.instagram.com/" class="profile-card-social__item instagram" target="_blank">
          <span class="icon-font">
                <svg fill="#000000" width="35px" height="35px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="M20.445 5h-8.891A6.559 6.559 0 0 0 5 11.554v8.891A6.559 6.559 0 0 0 11.554 27h8.891a6.56 6.56 0 0 0 6.554-6.555v-8.891A6.557 6.557 0 0 0 20.445 5zm4.342 15.445a4.343 4.343 0 0 1-4.342 4.342h-8.891a4.341 4.341 0 0 1-4.341-4.342v-8.891a4.34 4.34 0 0 1 4.341-4.341h8.891a4.342 4.342 0 0 1 4.341 4.341l.001 8.891z"/><path d="M16 10.312c-3.138 0-5.688 2.551-5.688 5.688s2.551 5.688 5.688 5.688 5.688-2.551 5.688-5.688-2.55-5.688-5.688-5.688zm0 9.163a3.475 3.475 0 1 1-.001-6.95 3.475 3.475 0 0 1 .001 6.95zM21.7 8.991a1.363 1.363 0 1 1-1.364 1.364c0-.752.51-1.364 1.364-1.364z"/></svg>          </span>
           <span class=" ">
              Instagram
          </span>
        </a>

        <a href="https://www.x.com/BeTrainingsa" class="profile-card-social__item twitter" target="_blank">
          <span class="icon-font">
                <svg fill="#000000" width="35px" height="35px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="M11.919 24.94c-2.548 0-4.921-.747-6.919-2.032a9.049 9.049 0 0 0 6.681-1.867 4.512 4.512 0 0 1-4.215-3.137c.276.054.559.082.848.082.412 0 .812-.056 1.193-.156a4.519 4.519 0 0 1-3.622-4.425v-.059a4.478 4.478 0 0 0 2.042.564 4.507 4.507 0 0 1-2.008-3.758c0-.824.225-1.602.612-2.268a12.811 12.811 0 0 0 9.303 4.715 4.517 4.517 0 0 1 7.692-4.115 9.107 9.107 0 0 0 2.866-1.094 4.542 4.542 0 0 1-1.983 2.498 9.08 9.08 0 0 0 2.592-.71 9.283 9.283 0 0 1-2.252 2.337c.008.193.014.388.014.583-.001 5.962-4.542 12.843-12.844 12.842"/></svg>          </span>
           <span class=" ">
              Twitter
          </span>
        </a>
        
        <a href="https://www.linkedin.com/company/betrainingsa" class="profile-card-social__item linkedin" target="_blank">
          <span class="icon-font">
                <svg width="35px" height="35px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M18.72 3.99997H5.37C5.19793 3.99191 5.02595 4.01786 4.86392 4.07635C4.70189 4.13484 4.55299 4.22471 4.42573 4.34081C4.29848 4.45692 4.19537 4.59699 4.12232 4.75299C4.04927 4.909 4.0077 5.07788 4 5.24997V18.63C4.01008 18.9901 4.15766 19.3328 4.41243 19.5875C4.6672 19.8423 5.00984 19.9899 5.37 20H18.72C19.0701 19.9844 19.4002 19.8322 19.6395 19.5761C19.8788 19.32 20.0082 18.9804 20 18.63V5.24997C20.0029 5.08247 19.9715 4.91616 19.9078 4.76122C19.8441 4.60629 19.7494 4.466 19.6295 4.34895C19.5097 4.23191 19.3672 4.14059 19.2108 4.08058C19.0544 4.02057 18.8874 3.99314 18.72 3.99997ZM9 17.34H6.67V10.21H9V17.34ZM7.89 9.12997C7.72741 9.13564 7.5654 9.10762 7.41416 9.04768C7.26291 8.98774 7.12569 8.89717 7.01113 8.78166C6.89656 8.66615 6.80711 8.5282 6.74841 8.37647C6.6897 8.22474 6.66301 8.06251 6.67 7.89997C6.66281 7.73567 6.69004 7.57169 6.74995 7.41854C6.80986 7.26538 6.90112 7.12644 7.01787 7.01063C7.13463 6.89481 7.2743 6.80468 7.42793 6.74602C7.58157 6.68735 7.74577 6.66145 7.91 6.66997C8.07259 6.66431 8.2346 6.69232 8.38584 6.75226C8.53709 6.8122 8.67431 6.90277 8.78887 7.01828C8.90344 7.13379 8.99289 7.27174 9.05159 7.42347C9.1103 7.5752 9.13699 7.73743 9.13 7.89997C9.13719 8.06427 9.10996 8.22825 9.05005 8.3814C8.99014 8.53456 8.89888 8.6735 8.78213 8.78931C8.66537 8.90513 8.5257 8.99526 8.37207 9.05392C8.21843 9.11259 8.05423 9.13849 7.89 9.12997ZM17.34 17.34H15V13.44C15 12.51 14.67 11.87 13.84 11.87C13.5822 11.8722 13.3313 11.9541 13.1219 12.1045C12.9124 12.2549 12.7546 12.4664 12.67 12.71C12.605 12.8926 12.5778 13.0865 12.59 13.28V17.34H10.29V10.21H12.59V11.21C12.7945 10.8343 13.0988 10.5225 13.4694 10.3089C13.84 10.0954 14.2624 9.98848 14.69 9.99997C16.2 9.99997 17.34 11 17.34 13.13V17.34Z" fill="#000000"/>
                </svg>          
                </span>
           <span class=" ">
              linkedin
          </span>
        </a>
        
        <a href="https://www.tiktok.com/@betrainingsa" class="profile-card-social__item tiktok" target="_blank">
          <span class="icon-font">
                <svg fill="#000000" width="35px" height="35px" viewBox="0 0 24 24" id="tiktok" data-name="Flat Color" xmlns="http://www.w3.org/2000/svg" class="icon flat-color"><path id="primary" d="M21,7V9a1,1,0,0,1-1,1,8,8,0,0,1-4-1.08V15.5A6.5,6.5,0,1,1,6.53,9.72a1,1,0,0,1,1.47.9v2.52a.92.92,0,0,1-.28.62,2.49,2.49,0,0,0,2,4.23A2.61,2.61,0,0,0,12,15.35V3a1,1,0,0,1,1-1h2.11a1,1,0,0,1,1,.83A4,4,0,0,0,20,6,1,1,0,0,1,21,7Z" style="fill: rgb(0, 0, 0);"></path></svg>          </span>
           <span class=" ">
              Tiktok
          </span>
        </a>
        
        <a href="https://www.snapchat.com/add/betrainingsa" class="profile-card-social__item snapchat" target="_blank">
          <span class="icon-font">
                <svg fill="#000000" width="30px" height="30px" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg">
                        <title>snapchat</title>
                        <path d="M16.257 1.995c0.029-0 0.064-0.001 0.099-0.001 3.249 0 6.044 1.94 7.291 4.725l0.020 0.051c0.333 1.18 0.524 2.534 0.524 3.934 0 0.749-0.055 1.485-0.161 2.205l0.010-0.082-0.004 0.075c-0.015 0.225-0.027 0.431-0.037 0.637 0.132 0.072 0.289 0.114 0.456 0.114 0.016 0 0.032-0 0.048-0.001l-0.002 0c0.478-0.045 0.916-0.179 1.31-0.385l-0.019 0.009c0.162-0.082 0.352-0.13 0.554-0.13 0.009 0 0.018 0 0.027 0l-0.001-0c0.008-0 0.017-0 0.026-0 0.219 0 0.429 0.041 0.622 0.117l-0.012-0.004c0.496 0.117 0.868 0.532 0.917 1.042l0 0.005q0.028 0.842-1.516 1.46c-0.111 0.036-0.261 0.094-0.43 0.149-0.562 0.169-1.423 0.45-1.666 1.012-0.036 0.114-0.056 0.244-0.056 0.38 0 0.262 0.077 0.506 0.209 0.71l-0.003-0.005 0.019 0.019c1.117 2.493 3.286 4.344 5.926 5.003l0.061 0.013c0.299 0.049 0.525 0.306 0.525 0.616 0 0.007-0 0.014-0 0.021l0-0.001c-0.001 0.102-0.021 0.198-0.058 0.286l0.002-0.005c-0.3 0.711-1.591 1.235-3.931 1.588-0.087 0.204-0.158 0.444-0.202 0.692l-0.003 0.020c-0.046 0.268-0.104 0.501-0.177 0.727l0.010-0.036c-0.069 0.293-0.329 0.508-0.638 0.508-0.019 0-0.039-0.001-0.058-0.003l0.002 0h-0.037c-0.246-0.013-0.476-0.046-0.699-0.098l0.027 0.005c-0.477-0.107-1.024-0.169-1.586-0.169-0.002 0-0.003 0-0.005 0h0c-0.024-0-0.053-0.001-0.082-0.001-0.374 0-0.74 0.034-1.096 0.099l0.037-0.006c-0.83 0.222-1.551 0.603-2.162 1.112l0.009-0.007c-1.108 0.944-2.536 1.541-4.102 1.609l-0.014 0c-0.075 0-0.149-0.019-0.225-0.019h-0.186c-1.575-0.060-3-0.659-4.106-1.617l0.008 0.007c-0.596-0.501-1.311-0.882-2.094-1.096l-0.039-0.009c-0.346-0.055-0.747-0.089-1.156-0.092l-0.004-0c-0.568 0.008-1.115 0.076-1.642 0.196l0.053-0.010c-0.199 0.049-0.43 0.082-0.667 0.092l-0.007 0c-0.016 0.001-0.034 0.002-0.052 0.002-0.325 0-0.597-0.222-0.675-0.522l-0.001-0.005c-0.076-0.24-0.112-0.486-0.169-0.709-0.047-0.269-0.119-0.508-0.216-0.734l0.008 0.022c-2.397-0.277-3.686-0.802-3.985-1.532-0.039-0.082-0.064-0.178-0.069-0.279l-0-0.002c-0-0.007-0-0.015-0-0.023 0-0.309 0.226-0.565 0.522-0.612l0.004-0c2.703-0.674 4.873-2.527 5.965-4.968l0.022-0.056 0.020-0.036c0.133-0.195 0.212-0.436 0.212-0.695 0-0.14-0.023-0.274-0.065-0.4l0.003 0.009c-0.244-0.542-1.105-0.822-1.665-1.011-0.168-0.043-0.312-0.094-0.45-0.156l0.018 0.007c-1.383-0.544-1.571-1.162-1.496-1.591 0.207-0.583 0.753-0.992 1.395-0.992 0.023 0 0.045 0.001 0.068 0.002l-0.003-0c0.001 0 0.002 0 0.004 0 0.171 0 0.334 0.034 0.483 0.096l-0.008-0.003c0.401 0.211 0.871 0.346 1.371 0.374l0.009 0c0.012 0 0.025 0.001 0.039 0.001 0.198 0 0.385-0.049 0.549-0.135l-0.006 0.003-0.057-0.711c-0.093-0.628-0.147-1.354-0.147-2.092 0-1.406 0.194-2.768 0.555-4.058l-0.025 0.106c1.237-2.815 4.001-4.746 7.216-4.746 0.044 0 0.088 0 0.131 0.001l-0.007-0 0.524-0.019h0.075z"></path>
                </svg>          
                </span>
           <span class=" ">
              Snapchat
          </span>
        </a>
        
        <a href="https://wa.me/966590542300" class="profile-card-social__item Whatsapp" target="_blank">
          <span class="icon-font">
                <svg width="35px" height="35px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M3.50002 12C3.50002 7.30558 7.3056 3.5 12 3.5C16.6944 3.5 20.5 7.30558 20.5 12C20.5 16.6944 16.6944 20.5 12 20.5C10.3278 20.5 8.77127 20.0182 7.45798 19.1861C7.21357 19.0313 6.91408 18.9899 6.63684 19.0726L3.75769 19.9319L4.84173 17.3953C4.96986 17.0955 4.94379 16.7521 4.77187 16.4751C3.9657 15.176 3.50002 13.6439 3.50002 12ZM12 1.5C6.20103 1.5 1.50002 6.20101 1.50002 12C1.50002 13.8381 1.97316 15.5683 2.80465 17.0727L1.08047 21.107C0.928048 21.4637 0.99561 21.8763 1.25382 22.1657C1.51203 22.4552 1.91432 22.5692 2.28599 22.4582L6.78541 21.1155C8.32245 21.9965 10.1037 22.5 12 22.5C17.799 22.5 22.5 17.799 22.5 12C22.5 6.20101 17.799 1.5 12 1.5ZM14.2925 14.1824L12.9783 15.1081C12.3628 14.7575 11.6823 14.2681 10.9997 13.5855C10.2901 12.8759 9.76402 12.1433 9.37612 11.4713L10.2113 10.7624C10.5697 10.4582 10.6678 9.94533 10.447 9.53028L9.38284 7.53028C9.23954 7.26097 8.98116 7.0718 8.68115 7.01654C8.38113 6.96129 8.07231 7.046 7.84247 7.24659L7.52696 7.52195C6.76823 8.18414 6.3195 9.2723 6.69141 10.3741C7.07698 11.5163 7.89983 13.314 9.58552 14.9997C11.3991 16.8133 13.2413 17.5275 14.3186 17.8049C15.1866 18.0283 16.008 17.7288 16.5868 17.2572L17.1783 16.7752C17.4313 16.5691 17.5678 16.2524 17.544 15.9269C17.5201 15.6014 17.3389 15.308 17.0585 15.1409L15.3802 14.1409C15.0412 13.939 14.6152 13.9552 14.2925 14.1824Z" fill="#000000"/>
                </svg>        
                </span>
           <span class=" ">
              Whatsapp
          </span>
        </a>
        
        <a href="mailto:CS@betraining.com.sa" class="profile-card-social__item Email" target="_blank">
          <span class="icon-font">
                <svg fill="#000000" width="35px" height="35px" viewBox="0 0 1920 1920" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1920 428.266v1189.54l-464.16-580.146-88.203 70.585 468.679 585.904H83.684l468.679-585.904-88.202-70.585L0 1617.805V428.265l959.944 832.441L1920 428.266ZM1919.932 226v52.627l-959.943 832.44L.045 278.628V226h1919.887Z" fill-rule="evenodd"/>
                </svg>       
                </span>
           <span class=" ">
              Email
          </span>
        </a>

        <a href="https://betraining.com.sa/ar/about-us" class="profile-card-social__item link" target="_blank">
          <span class="icon-font">
              <svg class="icon"><use xlink:href="#icon-link"></use></svg>
          </span>
           <span class=" ">
              Website
          </span>
        </a>

        <a href="https://maps.app.goo.gl/Srz6WJ1ohnT1Lx6Q6" class="profile-card-social__item location" target="_blank">
          <span class="icon-font">
              <svg class="icon"><use xlink:href="#icon-location"></use></svg>
          </span>
           <span class=" ">
               العنوان:              جدة المملكة العربية السعودية مجمع النور, جدة 23215
          </span>
        </a>
        
      </div>

      
       
    </div>

    

  </div>

</div>

<svg hidden="hidden" style='display:none'>
  <defs>

    <symbol id="icon-location" viewBox="0 0 32 32">
      <title>location</title>
      <path d="M16 31.68c-0.352 0-0.672-0.064-1.024-0.16-0.8-0.256-1.44-0.832-1.824-1.6l-6.784-13.632c-1.664-3.36-1.568-7.328 0.32-10.592 1.856-3.2 4.992-5.152 8.608-5.376h1.376c3.648 0.224 6.752 2.176 8.608 5.376 1.888 3.264 2.016 7.232 0.352 10.592l-6.816 13.664c-0.288 0.608-0.8 1.12-1.408 1.408-0.448 0.224-0.928 0.32-1.408 0.32zM15.392 2.368c-2.88 0.192-5.408 1.76-6.912 4.352-1.536 2.688-1.632 5.92-0.288 8.672l6.816 13.632c0.128 0.256 0.352 0.448 0.64 0.544s0.576 0.064 0.832-0.064c0.224-0.096 0.384-0.288 0.48-0.48l6.816-13.664c1.376-2.752 1.248-5.984-0.288-8.672-1.472-2.56-4-4.128-6.88-4.32h-1.216zM16 17.888c-3.264 0-5.92-2.656-5.92-5.92 0-3.232 2.656-5.888 5.92-5.888s5.92 2.656 5.92 5.92c0 3.264-2.656 5.888-5.92 5.888zM16 8.128c-2.144 0-3.872 1.728-3.872 3.872s1.728 3.872 3.872 3.872 3.872-1.728 3.872-3.872c0-2.144-1.76-3.872-3.872-3.872z"></path>
      <path d="M16 32c-0.384 0-0.736-0.064-1.12-0.192-0.864-0.288-1.568-0.928-1.984-1.728l-6.784-13.664c-1.728-3.456-1.6-7.52 0.352-10.912 1.888-3.264 5.088-5.28 8.832-5.504h1.376c3.744 0.224 6.976 2.24 8.864 5.536 1.952 3.36 2.080 7.424 0.352 10.912l-6.784 13.632c-0.32 0.672-0.896 1.216-1.568 1.568-0.48 0.224-0.992 0.352-1.536 0.352zM15.36 0.64h-0.064c-3.488 0.224-6.56 2.112-8.32 5.216-1.824 3.168-1.952 7.040-0.32 10.304l6.816 13.632c0.32 0.672 0.928 1.184 1.632 1.44s1.472 0.192 2.176-0.16c0.544-0.288 1.024-0.736 1.28-1.28l6.816-13.632c1.632-3.264 1.504-7.136-0.32-10.304-1.824-3.104-4.864-5.024-8.384-5.216h-1.312zM16 29.952c-0.16 0-0.32-0.032-0.448-0.064-0.352-0.128-0.64-0.384-0.8-0.704l-6.816-13.664c-1.408-2.848-1.312-6.176 0.288-8.96 1.536-2.656 4.16-4.32 7.168-4.512h1.216c3.040 0.192 5.632 1.824 7.2 4.512 1.6 2.752 1.696 6.112 0.288 8.96l-6.848 13.632c-0.128 0.288-0.352 0.512-0.64 0.64-0.192 0.096-0.384 0.16-0.608 0.16zM15.424 2.688c-2.784 0.192-5.216 1.696-6.656 4.192-1.504 2.592-1.6 5.696-0.256 8.352l6.816 13.632c0.096 0.192 0.256 0.32 0.448 0.384s0.416 0.064 0.608-0.032c0.16-0.064 0.288-0.192 0.352-0.352l6.816-13.664c1.312-2.656 1.216-5.792-0.288-8.352-1.472-2.464-3.904-4-6.688-4.16h-1.152zM16 18.208c-3.424 0-6.24-2.784-6.24-6.24 0-3.424 2.816-6.208 6.24-6.208s6.24 2.784 6.24 6.24c0 3.424-2.816 6.208-6.24 6.208zM16 6.4c-3.072 0-5.6 2.496-5.6 5.6 0 3.072 2.528 5.6 5.6 5.6s5.6-2.496 5.6-5.6c0-3.104-2.528-5.6-5.6-5.6zM16 16.16c-2.304 0-4.16-1.888-4.16-4.16s1.888-4.16 4.16-4.16c2.304 0 4.16 1.888 4.16 4.16s-1.856 4.16-4.16 4.16zM16 8.448c-1.952 0-3.552 1.6-3.552 3.552s1.6 3.552 3.552 3.552c1.952 0 3.552-1.6 3.552-3.552s-1.6-3.552-3.552-3.552z"></path>
    </symbol>

    <symbol id="icon-behance" viewBox="0 0 32 32">
      <title>behance</title>
      <path d="M9.281 6.412c0.944 0 1.794 0.081 2.569 0.25 0.775 0.162 1.431 0.438 1.988 0.813 0.55 0.375 0.975 0.875 1.287 1.5 0.3 0.619 0.45 1.394 0.45 2.313 0 0.994-0.225 1.819-0.675 2.481-0.456 0.662-1.119 1.2-2.006 1.625 1.213 0.35 2.106 0.962 2.706 1.831 0.6 0.875 0.887 1.925 0.887 3.163 0 1-0.194 1.856-0.575 2.581-0.387 0.731-0.912 1.325-1.556 1.781-0.65 0.462-1.4 0.8-2.237 1.019-0.831 0.219-1.688 0.331-2.575 0.331h-9.544v-19.688h9.281zM8.719 14.363c0.769 0 1.406-0.181 1.906-0.55 0.5-0.363 0.738-0.963 0.738-1.787 0-0.456-0.081-0.838-0.244-1.131-0.169-0.294-0.387-0.525-0.669-0.688-0.275-0.169-0.588-0.281-0.956-0.344-0.356-0.069-0.731-0.1-1.113-0.1h-4.050v4.6h4.388zM8.956 22.744c0.425 0 0.831-0.038 1.213-0.125 0.387-0.087 0.731-0.219 1.019-0.419 0.287-0.194 0.531-0.45 0.706-0.788 0.175-0.331 0.256-0.756 0.256-1.275 0-1.012-0.287-1.738-0.856-2.175-0.569-0.431-1.325-0.644-2.262-0.644h-4.7v5.419h4.625z"></path>
      <path d="M22.663 22.675c0.587 0.575 1.431 0.863 2.531 0.863 0.788 0 1.475-0.2 2.044-0.6s0.913-0.825 1.044-1.262h3.45c-0.556 1.719-1.394 2.938-2.544 3.675-1.131 0.738-2.519 1.113-4.125 1.113-1.125 0-2.131-0.181-3.038-0.538-0.906-0.363-1.663-0.869-2.3-1.531-0.619-0.663-1.106-1.45-1.45-2.375-0.337-0.919-0.512-1.938-0.512-3.038 0-1.069 0.175-2.063 0.525-2.981 0.356-0.925 0.844-1.719 1.494-2.387s1.413-1.2 2.313-1.588c0.894-0.387 1.881-0.581 2.975-0.581 1.206 0 2.262 0.231 3.169 0.706 0.9 0.469 1.644 1.1 2.225 1.887s0.994 1.694 1.25 2.706c0.256 1.012 0.344 2.069 0.275 3.175h-10.294c0 1.119 0.375 2.188 0.969 2.756zM27.156 15.188c-0.462-0.512-1.256-0.794-2.212-0.794-0.625 0-1.144 0.106-1.556 0.319-0.406 0.213-0.738 0.475-0.994 0.787-0.25 0.313-0.425 0.65-0.525 1.006-0.1 0.344-0.163 0.663-0.181 0.938h6.375c-0.094-1-0.438-1.738-0.906-2.256z"></path>
      <path d="M20.887 8h7.981v1.944h-7.981v-1.944z"></path>
    </symbol>

    <symbol id="icon-link" viewBox="0 0 32 32">
      <title>link</title>
      <path d="M17.984 11.456c-0.704 0.704-0.704 1.856 0 2.56 2.112 2.112 2.112 5.568 0 7.68l-5.12 5.12c-2.048 2.048-5.632 2.048-7.68 0-1.024-1.024-1.6-2.4-1.6-3.84s0.576-2.816 1.6-3.84c0.704-0.704 0.704-1.856 0-2.56s-1.856-0.704-2.56 0c-1.696 1.696-2.624 3.968-2.624 6.368 0 2.432 0.928 4.672 2.656 6.4 1.696 1.696 3.968 2.656 6.4 2.656s4.672-0.928 6.4-2.656l5.12-5.12c3.52-3.52 3.52-9.248 0-12.8-0.736-0.672-1.888-0.672-2.592 0.032z"></path>
      <path d="M29.344 2.656c-1.696-1.728-3.968-2.656-6.4-2.656s-4.672 0.928-6.4 2.656l-5.12 5.12c-3.52 3.52-3.52 9.248 0 12.8 0.352 0.352 0.8 0.544 1.28 0.544s0.928-0.192 1.28-0.544c0.704-0.704 0.704-1.856 0-2.56-2.112-2.112-2.112-5.568 0-7.68l5.12-5.12c2.048-2.048 5.632-2.048 7.68 0 1.024 1.024 1.6 2.4 1.6 3.84s-0.576 2.816-1.6 3.84c-0.704 0.704-0.704 1.856 0 2.56s1.856 0.704 2.56 0c1.696-1.696 2.656-3.968 2.656-6.4s-0.928-4.704-2.656-6.4z"></path>
    </symbol>
  </defs>
</svg>
</body>
</html>


