@extends('layouts.app')
@section('title')
    <title>{{__('home.wishlist') }}</title>
@endsection
@section('content')
<!-- bread crumb area -->
<div class="rts-bread-crumbarea-1 rts-section-gap bg_image">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="breadcrumb-main-wrapper">
                    <h1 class="title">{{__('home.wishlist') }}</h1>
                    <!-- breadcrumb pagination area -->
                    <div class="pagination-wrapper">
                        <a href="{{url('/')}}">@lang('home.home')</a>
                        <i class="fa-regular fa-chevron-right"></i>
                        <a class="active" >{{__('home.wishlist') }}</a>
                    </div>
                    <!-- breadcrumb pagination area end -->
                </div>
            </div>
        </div>
    </div>
</div>

   <!-- Shop area start -->
   <main class="ms-main">
    <div class="ms-page-content">
        <!--================= Cart Area Start =================-->
        <article class="post-283 page type-page status-publish hentry">
            <div class="ms-default-page container">
                <div class="woocommerce">
                    <div class="woocommerce-notices-wrapper "></div>
                    <div class="ms-woocommerce-cart-form-wrapper d-flex gap-5">
                        @if(count($wishlist) > 0)
                        <table class="  shop_table shop_table_responsive cart woocommerce-cart-form__contents">
                            <thead>
                                <tr>
                                    <th class="product-thumbnail">&nbsp;</th>
                                    <th class="product-name">@lang('home.training')</th>
                                    <th class="product-price">@lang('home.price')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($wishlist as $course)
                                    <tr class="woocommerce-cart-form__cart-item cart_item">
                                        <td class="product-thumbnail">
                                            <a href="javascript:void(0)" data-wishlist_id="{{ $course->id }}"
                                                class="btnDelete_wishlist btn-remove icon-cancel"
                                                title="Remove Product">
                                                <i class="far fa-times"></i>
                                            </a>
                                            <a href="{{ LaravelLocalization::localizeUrl('course/' . $course->course->id) }}">
                                                <img src="{{ Helper::uploadedImagesPath('courses/source', $course->course->image) }}"
                                                    class="attachment-woocommerce_thumbnail size-woocommerce_thumbnail" alt="{{ $course->course->{'name_' . $lang} }}">
                                            </a>
                                        </td>
                                        <td class="product-name" data-title="Product">
                                            <a href="{{ LaravelLocalization::localizeUrl('course/' . $course->course->{'link_' . $lang}) }}">{{ $course->course->{'name_' . $lang} }}</a>
                                        </td>
                                        <td class="product-price" data-title="Price">
                                            <span class="woocommerce-Price-amount amount">
                                                <bdi><span  class="woocommerce-Price-currencySymbol">@lang('home.SAR')</span>{{ $course->course->last_price() }}</bdi>
                                            </span>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @else
                            <h2 class="my-0 mx-auto">{{ trans('home.no_data_found') }}</h2>
                        @endif

                    </div>
                </div>
                <div class="clearfix"></div>
            </div>
        </article>
    </div>
</main>
<!-- Shop area end -->
@endsection


@section('script')
    <Script>
        //btnDelete
        $(document).on('click', '.btnDelete_wishlist', function() {
            var wishlist_id = $(this).data('wishlist_id');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('wishlistDelete') }}",
                method: 'POST',
                data: {
                    wishlist_id: wishlist_id
                },
                success: function() {
                    location.reload();
                },
            });
        });
    </script>
@endsection
