<div class="cart-header">
    <h3 class="cart-heading">@lang('home.My Cart') ({{ $cartCount }} @lang('home.course'))</h3>
    <div class="close-cart"><i class="fal fa-times"></i></div>
</div>
<div class="product-area">
    @foreach ($cart->cart_courses as $cart_course)
        <div class="product-item">
            <div class="product-detail">
                <div class="product-thumb"><img src="{{ Helper::uploadedImagesPath('courses/source', $cart_course->course->image) }}" alt="{{$cart_course->course->category->{'name_'.$lang} }}"></div>
                <div class="item-wrapper">
                    <span class="product-name">{{$cart_course->course->{'name_'.$lang} }}</span>
                    <div class="item-wrapper">
                        <span class="product-variation"><span class="color">{{$cart_course->course->category->{'name_'.$lang} }}</span>
                    </div>
                    <div class="item-wrapper">
                        <span class="product-price">@lang('home.SAR'){{$cart_course->price}}</span>
                    </div>
                </div>
            </div>
            <div class="cart-edit">
                <div class="item-wrapper d-flex mr--5 align-items-center">
                    <a href="javascript:void(0)" data-cart_course_id="{{$cart_course->id}}" class="btnDelete delete-cart"><i class="fal fa-times"></i></a>
                </div>
            </div>
        </div>        
    @endforeach    
</div>

<div class="cart-bottom-area">
    <span class="total-price">@lang('home.total') <span class="price">@lang('home.SAR'){{$cart->total_price}}</span></span>
    <a href="{{Laravellocalization::localizeUrl('/check-out')}}" class="checkout-btn cart-btn">@lang('home.Proceed to checkout')</a>
    <a href="{{Laravellocalization::localizeUrl('/cart')}}" class="view-btn cart-btn">@lang('home.My Cart')</a>
</div>

<script>
    //btnDelete
    $(document).on('click', '.btnDelete', function() {
        var cart_course_id = $(this).data('cart_course_id');
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: "{{ route('cartDelete') }}",
            method: 'POST',
            data: {
                cart_course_id: cart_course_id
            },
            success: function(data) {
                $('.cart-count').html(data.cartCount);
                $('.miniCart').html(data.html);
                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: data.text,
                });
            },
        });
    });
</script>