@extends('layouts.app')
@section('title')
    <title>{{ __('home.cart') }}</title>
@endsection
@section('content')
    <!-- bread crumb area -->
    <div class="rts-bread-crumbarea-1 rts-section-gap bg_image">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-main-wrapper">
                        <h1 class="title">{{ __('home.cart') }}</h1>
                        <!-- breadcrumb pagination area -->
                        <div class="pagination-wrapper">
                            <a href="{{ url('/') }}">@lang('home.home')</a>
                            <i class="fa-regular fa-chevron-right"></i>
                            <a class="active">{{ __('home.cart') }}</a>
                        </div>
                        <!-- breadcrumb pagination area end -->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Shop area start -->
    <main class="ms-main">
        <div class="ms-page-content">
            <!--================= Cart Area Start =================-->
            <article class="post-283 page type-page status-publish hentry">
                <div class="ms-default-page container">
                    <div class="woocommerce">
                        <div class="woocommerce-notices-wrapper "></div>
                        <div class="ms-woocommerce-cart-form-wrapper d-flex gap-5">
                            <table class="  shop_table shop_table_responsive cart woocommerce-cart-form__contents">
                                <thead>
                                    <tr>
                                        <th class="product-thumbnail">&nbsp;</th>
                                        <th class="product-name">@lang('home.course')</th>
                                        <th class="product-price">@lang('home.price')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($cart->cart_courses as $cart_course)
                                        <tr class="woocommerce-cart-form__cart-item cart_item">

                                            <td class="product-thumbnail">
                                                <a href="javascript:void(0)" data-cart_course_id="{{ $cart_course->id }}"
                                                    class="btnDelete_shopping btn-remove icon-cancel"
                                                    title="Remove Product">
                                                    <i class="far fa-times"></i>
                                                </a>
                                                <a
                                                    href="{{ LaravelLocalization::localizeUrl('course/' . $cart_course->course->{'link_' . $lang}) }}">
                                                    <img src="{{ Helper::uploadedImagesPath('courses/source', $cart_course->course->image) }}"
                                                        class="attachment-woocommerce_thumbnail size-woocommerce_thumbnail"
                                                        alt="">
                                                </a>
                                            </td>
                                            <td class="product-name" data-title="Product">
                                                <a
                                                    href="{{ LaravelLocalization::localizeUrl('course/' . $cart_course->course->{'link_' . $lang}) }}">{{ $cart_course->course->{'name_' . $lang} }}</a>
                                            </td>

                                            <td class="product-price" data-title="Price">
                                                <span class="woocommerce-Price-amount amount">
                                                    <bdi><span
                                                            class="woocommerce-Price-currencySymbol">@lang('home.SAR')</span>{{ $cart_course->price }}</bdi>
                                                </span>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>

                            <div class="col-md-3  ms-cart-totals cart_totals ">
                                <h3 class="animated fadeIn">@lang('home.cart')</h3>
                                <table class="shop_table shop_table_responsive mt-5">
                                    <tbody>
                                        <tr class="order-total">
                                            <th>@lang('home.total')</th>
                                            <td data-title="Total">
                                                <strong><span class="woocommerce-Price-amount amount">
                                                        <bdi><span
                                                                class="woocommerce-Price-currencySymbol">@lang('home.SAR')</span>{{ $cart->total_price }}</bdi></span>
                                                </strong>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                @if (count($cart->cart_courses) > 0)
                                    <div class="ms-proceed-to-checkout wc-proceed-to-checkout">
                                        <a href="{{ LaravelLocalization::localizeUrl('/check-out') }}"
                                            class="rts-btn btn-primary">@lang('home.Proceed to checkout')</a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </article>
        </div>
    </main>
    <!-- Shop area end -->
@endsection
@section('script')
    <Script>
        //btnDelete
        $(document).on('click', '.btnDelete_shopping', function() {
            var cart_course_id = $(this).data('cart_course_id');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('cartDelete') }}",
                method: 'POST',
                data: {
                    cart_course_id: cart_course_id
                },
                success: function() {
                    location.reload();
                },
            });
        });
    </script>
@endsection
