@extends('layouts.app')
@section('title')
    <title>{{ __('home.notification') }}</title>
@endsection
@section('content')
    <!-- dashboard banner area start -->
    <div class="dashboard-banner-area-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="dashboard-banner-area-start bg_image">
                        <div class="author-profile-image-and-name">
                            <div class="profile-pic">
                                @if ($user->image)
                                    <img alt="{{ $user->name() }}"
                                        src="{{ URL::to('uploads/users/source') }}/{{ $user->image }}">
                                @else
                                    <img alt="avatar"
                                        src="{{ URL::To('resources/assets/back/images/users/avatar-1.jpg') }}">
                                @endif
                            </div>
                            <div class="name-desig">
                                <h1 class="title">{{ $user->name() }}</h1>
                                <div class="course-vedio">
                                    <div class="single">
                                        <i class="fa-light fa-envelope"></i>
                                        <span>{{ $user->email }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- dashboard banner area end -->
    <!-- rts dahboard-area-main-wrapper -->
    <div class="dashboard--area-main pt--100">
        <div class="container">
            <div class="row g-5">
                @include('userboard.partials.sideUserDashboard') 
                <div class="col-lg-9">
                    <div class="rts-reviewd-area-dashed table-responsive" style="white-space: nowrap;">
                        <h5 class="title">@lang('home.notification')</h5>
                        <table class="table-reviews">
                            <thead>
                                <tr>
                                    <th style="width: 30%;">@lang('home.title')</th>
                                    <th style="width: 30%;">@lang('home.date')</th>
                                    <th>@lang('home.message')</th>
                                </tr>
                            </thead>
                            <tbody class="">
                                @foreach ($user->notifications as $notify)
                                    <tr>
                                        <td>
                                            <div class="author-area">
                                                <p>{{$notify->notification_mesasge->title}}</p>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="date">{{ \Carbon\Carbon::parse($notify->created_at)->format('F j, Y') }}</span>
                                        </td>
                                        <td>
                                            <span class="name">{{$notify->notification_mesasge->text}}</span>
                                        
                                        </td>
                                    </tr>                                    
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- rts dahboard-area-main-wrapper end -->


    <div class="rts-section-gapTop">

    </div>
@endsection
