@extends('layouts.app')
@section('title')
    <title>{{ __('home.webinars') }}</title>
@endsection
@section('content')
    <!-- dashboard banner area start -->
    <div class="dashboard-banner-area-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="dashboard-banner-area-start bg_image">
                        <div class="author-profile-image-and-name">
                            <div class="profile-pic">
                                @if ($user->image)
                                    <img alt="{{ $user->name() }}"
                                        src="{{ URL::to('uploads/users/source') }}/{{ $user->image }}">
                                @else
                                    <img alt="avatar"
                                        src="{{ URL::To('resources/assets/back/images/users/avatar-1.jpg') }}">
                                @endif
                            </div>
                            <div class="name-desig">
                                <h1 class="title">{{ $user->name() }}</h1>
                                <div class="course-vedio">
                                    <div class="single">
                                        <i class="fa-light fa-envelope"></i>
                                        <span>{{ $user->email }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- dashboard banner area end -->
    <!-- rts dahboard-area-main-wrapper -->
    <div class="dashboard--area-main pt--100">
        <div class="container">
            <div class="row g-5">
                @include('userboard.partials.sideUserDashboard') 
                <div class="col-lg-9">
                    <div class="exrolled-course-wrapper-dashed">
                        <h5 class="title">@lang('home.webinars')</h5>
                        <div class="tab-content mt--30" id="myTabContent">
                            <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                                <div class="row g-5">
                                    @forelse ($my_webinars as $my_webinar)
                                        <div class="col-lg-4 col-md-6 col-sm-12 col-12">
                                            <!-- single course style two -->
                                            <div class="single-course-style-three enroll-course">
                                                <a href="{{ LaravelLocalization::localizeUrl('user/webinars/' . $my_webinar->webinar->{'link_' . $lang}) }}" class="thumbnail">
                                                    <img src="{{ Helper::uploadedImagesPath('webinars', $my_webinar->webinar->image) }}" alt="{{ $my_webinar->webinar->{'name_' . $lang} }}">
                                                    <div class="tag-thumb">
                                                        <span>{{ $my_webinar->webinar->speaker }}</span>
                                                    </div>
                                                </a>
                                                <div class="body-area">
                                                    <div class="course-top">
                                                        <div class="price">
                                                            {{ $my_webinar->webinar->price == 0 ? __('home.free') : $my_webinar->webinar->price . ' ' . __('home.EGP') }}
                                                        </div>
                                                    </div>
                                                    <div class="course-top">
                                                        <div class="price">
                                                            {{ \Carbon\Carbon::parse($my_webinar->webinar->start_date)->format('F j, Y') }}
                                                        </div>
                                                    </div>
                                                    <a href="{{ LaravelLocalization::localizeUrl('user/webinars/' . $my_webinar->webinar->{'link_' . $lang}) }}">
                                                        <h5 class="title">{{ $my_webinar->webinar->{'name_' . $lang} }}</h5>
                                                    </a>
                                                </div>
                                                @if ($my_webinar->webinar->video_link)
                                                    <a href="{{LaravelLocalization::localizeUrl('user/watch-webinar/'.$my_webinar->webinar->{'link_'.$lang} )}}" target="_blank" class="rts-btn btn-primary text-center">@lang('home.Watch Event')</a>
                                                @else
                                                    <a  target="_blank" class="rts-btn btn-primary text-center">@lang('home.Video not exist yet')</a>
                                                @endif
                                            </div>
                                            <!-- single course style two end -->
                                        </div>    
                                    @empty
                                        <div class="m-5 text-center"> {{__('home.empty')}}</div>                            
                                    @endforelse
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- rts dahboard-area-main-wrapper end -->


    <div class="rts-section-gapTop">

    </div>
@endsection


@section('script')
    @if(session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->pull('success') }}'
            });
        </script>
    @endif
@endsection
