@extends('layouts.app')
@section('title')
    <title>{{ __('home.checkout') }}</title>
@endsection
@section('content')
    <!-- bread crumb area -->
    <div class="rts-bread-crumbarea-1 rts-section-gap bg_image">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-main-wrapper">
                        <h1 class="title">{{ __('home.checkout') }}</h1>
                        <!-- breadcrumb pagination area -->
                        <div class="pagination-wrapper">
                            <a href="{{ url('/') }}">@lang('home.home')</a>
                            <i class="fa-regular fa-chevron-right"></i>
                            <a class="active">{{ __('home.checkout') }}</a>
                        </div>
                        <!-- breadcrumb pagination area end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Shop area start -->
    <main class="ms-main">
        <div class="ms-page-content">

            <!--================= Checkout Area Start =================-->
            <article id="post-284" class="page checkout-area type-page status-publish hentry">
                <header class="ms-sp--header container">
                    <h1 class="ms-sp--title">{{ __('home.checkout') }}</h1>
                </header>
                <div class="ms-default-page container entry-content">
                    <div class="woocommerce">
                        <div class="woocommerce-notices-wrapper"></div>
                            <form method="POST" action="{{ route('webinarPlaceOrder') }}">
                                @csrf
                                <div class="row">
                                    <div class="col-lg-8">
                                        <div class="full-grid">
                                            <div class="ordered-product">
                                                <div class="checkout-title">
                                                    <h3 class="animated fadeIn">@lang('home.Your order')</h3>
                                                </div>
                                                <table>
                                                    <thead>
                                                        <tr>
                                                            <th>@lang('home.webinar')</th>
                                                            <th>@lang('home.total')</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>{{ $webinar->{'name_' . $lang} }}</td>
                                                            <td>@lang('home.EGP'){{ ' ' . $webinar->price }}
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                    <tfoot>
                                                        <tr>
                                                            <th>@lang('home.total')</th>
                                                            <th>@lang('home.EGP'){{ ' ' . $webinar->price }}</th>
                                                        </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                        </div>
                                        <fieldset>
                                            <h3 class="title my-3">{{ __('home.INFORMATIONS') }}</h3>
                                            <div class="row g-2 m-2">
                                                <div class="form-group mb-2 col-md-6">
                                                    <input required class="form-control" name="f_name"
                                                        value="{{ old('f_name') }}" placeholder="{{ __('home.f_name') }}"
                                                        type="text" />
                                                    @error('f_name')
                                                        <div class="alert alert-danger" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </div>
                                                    @enderror
                                                </div>
                                                <div class="form-group mb-2 col-md-6">
                                                    <input required class="form-control" name="l_name"
                                                        value="{{ old('l_name') }}" placeholder="{{ __('home.l_name') }}"
                                                        type="text" />
                                                    @error('l_name')
                                                        <div class="alert alert-danger" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </div>
                                                    @enderror
                                                </div>
                                                <div class="form-group mb-2 col-md-6">
                                                    <input required class="form-control" name="phone1"
                                                        value="{{ old('phone1') }}" placeholder="{{ __('home.phone') }}"
                                                        type="tel" />
                                                    @error('phone1')
                                                        <div class="alert alert-danger" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </div>
                                                    @enderror
                                                </div>
                                                <div class="form-group mb-2 col-md-6">
                                                    <input required class="form-control" name="email"
                                                        value="{{ old('email') }}" placeholder="{{ __('home.email') }}"
                                                        type="text" />
                                                    @error('email')
                                                        <div class="alert alert-danger" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </div>
                                                    @enderror
                                                </div>
                                                <div class="form-group col-6">
                                                    <input type="password" name="password"
                                                        class="form-control @error('password') is-invalid @enderror"
                                                        placeholder="{{ trans('home.password') }}" id="CustomerPassword"
                                                        value="" required />
                                                    @error('password')
                                                        <div class="alert alert-danger" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </div>
                                                    @enderror
                                                </div>
                                                <div class="form-group col-6">
                                                    <input required id="CustomerConfirmPassword" type="Password"
                                                        class="form-control @error('password') is-invalid @enderror"
                                                        name="password_confirmation"
                                                        placeholder=" {{ trans('home.confirm_password') }}" required />
                                                </div>
                                            </div>
                                        </fieldset>
                                    </div>

                                    <div class="col-lg-4 pl--30 pl_sm--15 pl_md--15">
                                        <h3 id="order_review_heading" class="animated fadeIn">@lang('home.Your order')</h3>
                                        <div id="order_review" class="woocommerce-checkout-review-order">
                                            <table
                                                class="ms-checkout-review-order-table shop_table woocommerce-checkout-review-order-table">
                                                <tbody>
                                                    <tr class="cart_item">
                                                        <td colspan="2">
                                                            <div class="ms-checkout-product">
                                                                <div class="ms-checkout-product__thumbnail">
                                                                    <img src="{{ Helper::uploadedImagesPath('webinars', $webinar->image) }}"
                                                                        class="attachment-woocommerce_thumbnail size-woocommerce_thumbnail"
                                                                        alt="Shop Image">
                                                                </div>
                                                                <div class="ms-checkout-product__content">
                                                                    <h5>{{ $webinar->{'name_' . $lang} }}</h5>
                                                                    <span class="woocommerce-Price-amount amount"><bdi><span
                                                                                class="woocommerce-Price-currencySymbol">@lang('home.EGP')</span>{{ $webinar->price }}</bdi></span>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>

                                                </tbody>
                                            </table>
                                            <div id="payment" class="woocommerce-checkout-payment">
                                                <div class="mb-3">
                                                    <input name="webinar_id" type="hidden" value="{{ $webinar->id }}">
                                                    <h5>@lang('home.payment_methods')</h5>
                                                    <div class="d-flex align-items-center justify-content-center gap-5">
                                                        @foreach ($payment_methods as $payment_method)
                                                            <div class="d-flex align-items-center">
                                                                <input type="radio"
                                                                    {{ $payment_method->id == 1 ? 'checked' : '' }}
                                                                    name="payment_id" id="payment_{{ $payment_method->id }}"
                                                                    value="{{ $payment_method->id }}">
                                                                <label for="payment_{{ $payment_method->id }}"
                                                                    class="ms-2 mb-0">
                                                                    <span
                                                                        class="fs-3">{{ $payment_method->{'name_' . $lang} }}</span>
                                                                </label>
                                                            </div>
                                                        @endforeach
                                                    </div>

                                                </div>
                                                <div class="form-row place-order mt-5 ">
                                                    <div class="ms-proceed-to-checkout wc-proceed-to-checkout">
                                                        <button class="add-btn rts-btn btn-primary m-auto"
                                                            type="submit">@lang('home.Continue to payment')</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    <div class="clearfix"></div>
                </div>
            </article>
            <!--================= Checkout Area End =================-->
        </div>
    </main>
@endsection


@section('script')
    {{-- copune --}}
    <script>
        $('.getCode').click(function() {
            var coupon_code = $('#coupon_code').val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('applyCoupon') }}",
                method: 'POST',
                data: {
                    coupon_code: coupon_code
                },
                success: function(data) {
                    location.reload();
                },
                error: function(xhr) {
                    if (xhr.status == 401) {
                        window.location.href = "{{ LaravelLocalization::localizeUrl('login') }}";
                    }
                }
            });
        });
    </script>
    @if (Session::has('check_coupon'))
        <script>
            Swal.fire({
                icon: '{{ Session::get('check_coupon_status') }}',
                title: '{{ Session::get('check_coupon_status') }}',
                text: "{{ Session::get('check_coupon') }}",
            });
        </script>
    @endif
    @php
        Session::forget('check_coupon');
    @endphp
@endsection
