@extends('layouts.app')
@section('title')
    <title>{{ __('home.exame') }}</title>
@endsection
@section('content')
    <div class="rts-bread-crumbarea-1 rts-section-gap bg_image">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-main-wrapper">
                        <h1 class="title">{{$exame->{'name_'.$lang} }}</h1>
                        <!-- breadcrumb pagination area -->
                        <div class="pagination-wrapper">
                            <a href="{{url('/')}}">@lang('home.home')</a>
                            <i class="fa-regular fa-chevron-right"></i>
                            <a class="active" >{{$exame->{'name_'.$lang} }}</a>
                        </div>
                        <!-- breadcrumb pagination area end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
   
    <!-- rts dahboard-area-main-wrapper -->
    <div class="dashboard--area-main pt--100">
        <div class="container">
            <div class="row g-5">
                <form method="POST" action="{{route('submitExame',$exame->id)}}">
                    @csrf
                    <div class="course-content-wrapper-main text-center">
                        @foreach ($exame->questions as $question)
                            <div class="accordion mt--30" id="accordionExample">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingOne">
                                        <div class="m-5 justify-content-center">
                                            <span style="color: #5c5c5c;">{{  $question->{'question_'.$lang} }}</span>
                                        </div>
                                        <div class="d-flex m-5 gap-5 justify-content-center">
                                            @foreach ($question->answers as $answer)
                                                <div class="align-items-center ">
                                                    <input type="radio" {{$answer->id==1?'checked':''}}  
                                                    name="answer[{{$question->id}}]" id="payment_{{$answer->id}}" value="{{$answer->id}}">
                                                    <label for="payment_{{$answer->id}}" class="ms-2 mb-0">
                                                        <span class="fs-3">{{$answer->{'answer_'.$lang} }}</span>
                                                    </label>
                                                </div>                                            
                                            @endforeach
                                        <div>
                                    </h2>
                                </div>
                            </div>
                        @endforeach                    
                        <div class="form-row place-order mt-5 ">
                            <div class="ms-proceed-to-checkout wc-proceed-to-checkout">
                                <button class="add-btn rts-btn btn-primary m-auto" type="submit">@lang('home.submit')</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="rts-section-gapTop">

    </div>
@endsection
