@extends('layouts.admin')

@section('meta')
<title>{{$course->{'name_'.$lang} }}</title>
@endsection
@section('content')

<div class="container-fluid">

    <!-- Page Header -->

    <!-- End Page Header -->

    <!-- Row-->
    <div class="row mt-5">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card">
                <div class="card-body">
                        <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.welcome').' '.auth()->user()->name()}}</h2>
                    <div class="row mr-2">
                        <a href = "{{url('/student')}}">
                           <h5>
                               {{__('home.admin_index')}}
                           </h5> 
                        </a>
                        <a href = "{{route('watch_training',$training->id)}}">
                           <h5> {{' / '.$training->{'name_'.$lang} }}</h5>
                        </a>
                    </div>
                    
                    <div class="text-center">
                        <h4 class="m-auto">{{__('home.courses_info')}}</h4>
                    </div>
                    <div class="text-center">
                        <h4 class="m-auto">{{$course->{'name_'.$lang} }}</h4>
                    </div>
                </div>
            </div>
        </div>
    </div> 
		<div class="card custom-card main-content-body-profile">
            <nav class="nav main-nav-line m-auto">
                @foreach($course->lessons as $index=>$lesson_tab)
                    <a class="nav-link @if($index==0) active @endif" id="tab-{{$index}}" data-toggle="tab" href="#div-{{$index}}" 
                    role="tab" aria-controls="div-{{$index}} second-div-{{$index}}" aria-selected="@if($index==0) true @else false @endif">{{$lesson_tab->{'name_'.$lang} }}</a>
                @endforeach
            </nav>

            <div class="tab-content " id="myTabContent">
                @foreach($course->lessons as $index_div=>$lesson_div)
                    <div class="tab-pane fade  @if($index_div==0) show active @endif" id="div-{{$index_div}}" role="tabpanel" aria-labelledby="tab-{{$index_div}}">
                        <div class="row justify-content-center">
                            <div class="m-5 col-md-5">
                                <div class="row justify-content-center text-center">
                                    <div class="col-md-10">
                                        <h3>{{ __('home.duration').' : '.$lesson_div->duration }}</h3>
                                        <h4>{!! $lesson_div->{'text_'.$lang} !!}</h4>
                                    </div>
                                </div>
                            </div>
                            <div class="m-5 col-md-5">
                                <div class="row justify-content-center text-center">
                                    <div class="col-md-10">
                                         @if($lesson_div->video_url)
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <!-- Video iframe -->
                                                    <div class="embed-responsive embed-responsive-16by9">
                                                        <iframe class="embed-responsive-item" src="{{$lesson_div->video_url}}" allowfullscreen></iframe>
                                                    </div>
                                                    <a href="{{$lesson_div->video_url}}">
                                                        <div class="mt-4 d-flex align-items-center justify-content-center">
                                                            <i class="ml-3 fas fa-video fa-2x"></i>
                                                            <h5 class="ml-2">{{__('home.lesson_url') }}</h5>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <br>
                             <div class="mb-5 col-md-10 text-center">
                             @if($lesson_div->attachments)
                                <h3>{{__('home.attachments')}}</h3>
                                <hr class="col-10">
                                <div class="row justify-content-center text-center">
                                        @if($lesson_div->attachments->{'intro_attachment_'.$lang} )
                                            <div class="col-4">
                                                <h3>  {{__('home.intro_attachment')}}</h3>
                                                <h4 class="mr-2">
                                                <a href="{{url('uploads/courses/attachments/files/'.$lesson_div->attachments->{'intro_attachment_'.$lang} )}}" download="{{$lesson_div->attachments->{'intro_attachment_'.$lang} }}">
                                                      <i class="fas fa-download"></i>
                                                {{$lesson_div->attachments->{'intro_attachment_'.$lang} }}
                                                </a>
                                                </h4>
                                            </div>
                                        @endif
                                         @if($lesson_div->attachments->{'attachment_'.$lang} )
                                        <div class="col-4">
                                            <h3>  {{__('home.attachment')}}</h3>
                                            <h4 class="mr-2">
                                            <a href="{{url('uploads/courses/attachments/files/'.$lesson_div->attachments->{'attachment_'.$lang} )}}" download="{{$lesson_div->attachments->{'attachment_'.$lang} }}">
                                                  <i class="fas fa-download"></i>
                                            {{$lesson_div->attachments->{'attachment_'.$lang} }}
                                            </a>
                                            </h4>
                                        </div>
                                        @endif
                                        @if($lesson_div->attachments->{'details_attachment_'.$lang} )
                                        <div class="col-4">
                                            <h3>  {{__('home.details_attachment')}}</h3>
                                            <h4 class="mr-2">
                                            <a href="{{url('uploads/courses/attachments/files/'.$lesson_div->attachments->{'details_attachment_'.$lang} )}}" download="{{$lesson_div->attachments->{'details_attachment_'.$lang} }}">
                                                  <i class="fas fa-download"></i>
                                            {{$lesson_div->attachments->{'details_attachment_'.$lang} }}
                                            </a>
                                            </h4>
                                        </div>
                                        @endif
                                                
                                    </div>
                            @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
   
</div>
@endsection
