<!doctype html>
<html class="no-js" lang="{{$lang=='en'?'en':'ar'}}" dir="{{$lang=='en'?'ltr':'rtl'}}">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
          @yield('title')
         <!-- Stylesheets -->
        <link rel="shortcut icon" type="image/x-icon" href="{{Helper::uploadedImagesPath('settings',$configration->app_logo)}}">
        <!-- fontawesome 6.4.2 -->
        <link rel="stylesheet" href="{{Helper::cssFilesPath('plugins/fontawesome-6.css')}}">
        <!-- swiper Css 10.2.0 -->
        <link rel="stylesheet" href="{{Helper::cssFilesPath('plugins/swiper.min.css')}}">
        <!-- magnific popup css -->
        <link rel="stylesheet" href="{{Helper::cssFilesPath('vendor/magnific-popup.css')}}">
        <!-- Bootstrap 5.0.2 -->
        <link rel="stylesheet" href="{{Helper::cssFilesPath('vendor/bootstrap.min.css')}}">
        <!-- jquery ui css -->
        <link rel="stylesheet" href="{{Helper::cssFilesPath('vendor/jquery-ui.css')}}">
        <!-- metismenu scss -->
        <link rel="stylesheet" href="{{Helper::cssFilesPath('vendor/metismenu.css')}}">
        <!-- custom style css -->
        <link rel="stylesheet" href="{{Helper::cssFilesPath('style.css')}}"> 
        @if ($lang=="ar")
            <link rel="stylesheet" href="{{Helper::cssFilesPath('styleRtl.css')}}">
        @endif        

        @yield('style')
    </head>

    <body>
        @if ($setting->mobile)
        <a href="tel:{{$setting->mobile}}" class="float-call">
            <i class="fal fa-phone" aria-hidden="true"></i>
        </a>
        @endif
        @if ($setting->whatsapp)
            <a href="https://wa.me/{{ str_replace(' ', '', $setting->whatsapp) }}" class="float-whts" target="_blank">
                <i class="fab fa-whatsapp" aria-hidden="true"></i>
            </a>
        @endif
    

       <div id="back__preloader" >
        <div id="back__circle_loader"></div>
        <div class="back__loader_logo"><img src="{{Helper::uploadedImagesPath('settings',$configration->app_logo)}}" alt="Preload"></div>
       </div>
     
        @yield('content')

        
    
    <!-- rts backto top start -->
    <div class="progress-wrap">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;"></path>
        </svg>
    </div>
    <!-- rts backto top end -->

    <!-- offcanvase search -->
    <div class="search-input-area">
        <div class="container">
            <div class="search-input-inner">
                <div class="input-div">
                    <input class="search-input autocomplete" type="text" placeholder="Search by keyword or #">
                    <button ><i class="far fa-search"></i></button>
                </div>
            </div>
        </div>
        <div id="close" class="search-close-icon"><i class="far fa-times"></i></div>
    </div>
    <!-- offcanvase search -->
    <div id="anywhere-home" class="">
    </div>


    <!-- Template  JS -->

    <script src="{{ Helper::jsFilesPath('vendor/jquery.min.js')}}"></script>
    <!-- jquery ui js -->
    <script src="{{ Helper::jsFilesPath('vendor/jquery-ui.js')}}"></script>
    <!-- metismenu js -->
    <script src="{{ Helper::jsFilesPath('vendor/metismenu.js')}}"></script>
    <!-- magnific popup js-->
    <script src="{{ Helper::jsFilesPath('vendor/magnifying-popup.js')}}"></script>
    <!-- swiper JS 10.2.0 -->
    <script src="{{ Helper::jsFilesPath('plugins/swiper.js')}}"></script>
    <!-- counterup js -->
    <script src="{{ Helper::jsFilesPath('plugins/counterup.js')}}"></script>
    <!-- waypoint js -->
    <script src="{{ Helper::jsFilesPath('vendor/waypoint.js')}}"></script>
    <!-- wow js -->
    <script src="{{ Helper::jsFilesPath('vendor/waw.js')}}"></script>
    <!-- isotop mesonary -->
    <script src="{{ Helper::jsFilesPath('plugins/isotop.js')}}"></script>
    <!-- jquery imageloaded -->
    <script src="{{ Helper::jsFilesPath('plugins/imagesloaded.pkgd.min.js')}}"></script>
    <!-- resize sensor js -->
    <script src="{{ Helper::jsFilesPath('plugins/resizer-sensor.js')}}"></script>
    <!-- sticky sidebar -->
    <script src="{{ Helper::jsFilesPath('plugins/sticky-sidebar.js')}}"></script>
    <!-- gsap twinmax js -->
    <script src="{{ Helper::jsFilesPath('plugins/twinmax.js')}}"></script>
    <!-- chroma js -->
    <script src="{{ Helper::jsFilesPath('vendor/chroma.min.js')}}"></script>
    <!-- bootstrap 5.0.2 -->
    <script src="{{ Helper::jsFilesPath('plugins/bootstrap.min.js')}}"></script>
    <!-- dymanic Contact Form -->
    <script src="{{ Helper::jsFilesPath('plugins/contact.form.js')}}"></script>
    <!-- calender js -->
    <script src="{{ Helper::jsFilesPath('plugins/calender.js')}}"></script>
    <!-- main Js -->
    <script src="{{ Helper::jsFilesPath('main.js')}}"></script>



        @yield('script')
    </body>
</html>
