@extends('layouts.app')
@section('title')
   <title>{{$configration->app_name}}|{{trans('home.login')}}</title>
@endsection
@section('content')
<div class="rbt-breadcrumb-default ptb--100 ptb_md--50 ptb_sm--30 bg-gradient-1">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-inner text-center">
                        <h2 class="title">{{__('home.register')}}</h2>
                        <ul class="page-list">
                            <li class="rbt-breadcrumb-item"><a href="{{url('/')}}">@lang('home.home')</a></li>
                            <li>
                                <div class="icon-right"><i class="feather-chevron-right"></i></div>
                            </li>
                            <li class="rbt-breadcrumb-item active">{{__('home. ')}}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

<div class="rbt-elements-area bg-color-white rbt-section-gap">
        <div class="container">
            <div class="row justify-content-center gy-5 row--30">


                <div class="col-lg-6">
                    <div class="rbt-contact-form contact-form-style-1 max-width-auto">
                        <h3 class="title">{{__('home.register')}}</h3>
                        <form class="max-width-auto" method="POST" action="{{ route('register') }}">
                            @csrf
                            <div class="form-group">
                                <input id="email" type="email" name="email" value="{{old('email')}}" required>
                                <label>{{__('home.email')}} *</label>
                                <span class="focus-border"></span>
                                @error('email')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <input id="name" type="text" name="f_name" required value="{{old('f_name')}}" >
                                <label>{{trans('home.f_name')}} *</label>
                                <span class="focus-border"></span>
                                @error('f_name')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <input id="name" type="text" name="l_name" required value="{{old('l_name')}}" >
                                <label>{{trans('home.l_name')}} *</label>
                                <span class="focus-border"></span>
                                @error('l_name')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <input id="password" type="password" name="password" required>
                                <label>{{__('home.password')}} *</label>
                                <span class="focus-border"></span>
                                @error('password')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <input id="passwords" type="password" name="password_confirmation" required>
                                <label>{{trans('home.confirm_password')}} *</label>
                                <span class="focus-border"></span>
                            </div>
                            
                             <div class="single-checkbox-filter">
                                <div class="check-box">
                                    <input type="checkbox" id="type-1" required>
                                    <label for="type-1">{{__('home.Accept the Terms and Privacy Policy')}}</label><br>
                                </div>
                            </div>

                            <div class="form-submit-group">
                                <button type="submit" class="rbt-btn btn-md btn-gradient hover-icon-reverse w-100">
                                    <span class="icon-reverse-wrapper">
                                        <span class="btn-text">{{__('home.register')}}</span>
                                        <span class="btn-icon"><i class="feather-arrow-right"></i></span>
                                        <span class="btn-icon"><i class="feather-arrow-right"></i></span>
                                    </span>
                                </button>
                                <p class="mt-2">  {{__('home.Already have an account?')}} <a    href="{{url('/login')}}">{{__('home.login')}}</a></p>    
                            </div>

                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>



                           
@endsection
