@extends('layouts.app')
@section('title')
   <title>{{$configration->app_name}}|{{trans('home.login')}}</title>
@endsection
@section('content')
  <!--================= back wrapper Start Here =================-->

<div class="rbt-breadcrumb-default ptb--100 ptb_md--50 ptb_sm--30 bg-gradient-1">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-inner text-center">
                        <h2 class="title">{{__('home.login')}}</h2>
                        <ul class="page-list">
                            <li class="rbt-breadcrumb-item"><a href="{{url('/')}}">@lang('home.home')</a></li>
                            <li>
                                <div class="icon-right"><i class="feather-chevron-right"></i></div>
                            </li>
                            <li class="rbt-breadcrumb-item active">{{__('home.login')}}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    
    
    
    
    
    
    
     <div class="rbt-elements-area bg-color-white rbt-section-gap">
        <div class="container">
            <div class="row justify-content-center gy-5 row--30">

                <div class="col-lg-6">
                    <div class="rbt-contact-form contact-form-style-1 max-width-auto">
                        <h4 class="title">{{trans('home.login')}}</h4>
                        <form method="POST" action="{{ route('login') }}">
                            @csrf
                            <div class="form-group">
                                 <input id="email" type="text" name="email"  required>
                                 <label>{{ trans('home.email') }}*</label>
                             <span class="focus-border"></span>
                            </div>
                            <div class="form-group">
                                 <input id="password" name="password" type="password" required>
                                 <label>{{ trans('home.password') }} *</label>
                                 <span class="focus-border"></span>
                            </div>
 
                            <div class="row mb--30">
                                <div class="col-lg-6">
                                    <div class="rbt-checkbox">
                                        <input type="checkbox" id="rememberme" name="rememberme">
                                        <label for="rememberme">{{ trans('home.remeber_me') }}</label>
                                    </div>
                                </div>
                            </div>

                            <div class="form-submit-group">
                                <button type="submit" class="rbt-btn btn-md btn-gradient hover-icon-reverse w-100">
                                    <span class="icon-reverse-wrapper">
                                        <span class="btn-text"> {{__('home.login')}}</span>
                                        <span class="btn-icon"><i class="feather-arrow-right"></i></span>
                                        <span class="btn-icon"><i class="feather-arrow-right"></i></span>
                                    </span>
                                </button>
                                <p class="mt-2">{{__("home.Dont have an account?")}}<a    href="{{LaravelLocalization::localizeUrl('/register?userType=student')}}"> {{__('home.register')}} </a></p>
                            </div>
                        </form>
                    </div>
                        </form>
                     </div>
                </div>
            </div>
        </div>
    </div>
@endsection

