@extends('layouts.app')
@section('meta')
    <title>{{$configration->app_name}} | {{trans('home.changePassword')}}</title>
@endsection
@section('content')
<div class="container page main-signin-wrapper my-4">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <span>
                        {{ __('home.changePassword') }}
                    </span>
                </div>

                <div class="card-body">
                    <form method="POST" action="{{ url('save-new-password') }}">
                        @csrf
                        <div class="form-group col-12">
                            <input id="password" type="password" class="form-control @error('cur_password') is-invalid @enderror" name="cur_password" required autocomplete="new-password" placeholder="{{ __('home.cur_password') }}" >
                            @error('cur_password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group  col-12">
                            <input id="new_password" type="password" class="form-control @error('new_password') is-invalid @enderror" name="new_password" required autocomplete="new-password" placeholder="{{ __('home.new_password') }}" >
                            @error('new_password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>


                        <div class="form-group  col-12">
                            <input id="conf_password" type="password" class="form-control @error('conf_password') is-invalid @enderror" name="conf_password" required autocomplete="new-password" placeholder="{{ __('home.conf_password') }}" >
                            @error('conf_password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-12">
                            <button type="submit" class="btn btn-primary w-100 hover-effect">
                                {{ __('save changes') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
 