@extends('layouts.admin')
<title>{{ trans('home.webinars') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.webinars') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.webinars') }}</li>
                </ol>
            </div>

            <div class="btn btn-list">

                <a href="{{ route('webinars.create') }}"><button class="btn ripple btn-primary"><i
                            class="fas fa-plus-circle"></i> {{ trans('home.add') }}</button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                        {{ trans('home.publish/unpublish') }}</button></a>
                <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                        {{ trans('home.delete') }}</button></a>
            </div>
        </div>

        @if (session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session()->pull('success') }} <button type="button" class="btn-close" data-bs-dismiss="alert"
                    aria-label="Close"></button>
            </div>
        @endif


        <!-- Row-->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card-body">
                    <table class="table text-center" id="exportexample">
                        <thead>
                            <tr>
                                <th><input type="checkbox" name="checkbox" class="tableChecked form-check-input"
                                        id="checkAll" /></th>
                                <th>{{ trans('home.id') }}</th>
                                <th>{{ trans('home.name') }}</th>
                                <th>{{ trans('home.start_date') }}</th>
                                <th>{{ trans('home.end_date') }}</th>
                                <th>{{ trans('home.image') }}</th>
                                <th>{{ __('home.publish/unpublish') }}</th>
                                <th>{{ __('home.edit') }}</th>
                                <th>{{ __('home.delete') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($webinars as $webinar)
                                <tr id="{{ $webinar->id }}">
                                    <td> <input type="checkbox" name="checkbox" class="tableChecked form-check-input"
                                            value="{{ $webinar->id }}" /> </td>
                                    <td><a href="{{ route('webinars.edit', $webinar->id) }}">{{ $webinar->id }}</a> </td>
                                    <td>{{ $webinar->{'name_' . $lang} }} </td>
                                    <td>{{ $webinar->formatted_start_date  }} </td>
                                    <td>{{ $webinar->formatted_end_date }} </td>

                                    <td>
                                        @if ($webinar->image)
                                            <img src="{{ url('uploads/webinars/source/' . $webinar->image) }}"
                                                width="150">
                                        @else
                                            <img src="{{ url('resources/assets/back/images/noimage.jpg') }}"  width="100">
                                        @endif
                                    </td>
                                    <td>
                                        <input class="btn_active" data-id="{{ $webinar->id }}" type="checkbox"
                                            id="switch-{{ $webinar->id }}" switch="success"
                                            {{ $webinar->status == 1 ? 'checked' : '' }} />
                                        <label for="switch-{{ $webinar->id }}" data-on-label="{{ trans('home.yes') }}"
                                            data-off-label="{{ trans('home.no') }}"></label>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-info waves-effect waves-light "
                                            href="{{ route('webinars.edit', $webinar->id) }}">{{ __('home.edit') }}</a>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-danger waves-effect waves-light btn_delete"
                                            data-id="{{ $webinar->id }}">{{ __('home.delete') }}</a>
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
