@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.edit_webinar')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.webinars')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{route('webinars.index')}}">{{trans('home.webinars')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_webinar')}}</li>
            </ol>
        </div>
    </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ trans('home.edit') }}</h4>
                    </div>
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                <!-- End Page Header -->
                                {!! Form::open([
                                    'method' => 'PATCH',
                                    'url' => route('webinars.update',$webinar->id),
                                    'data-toggle' => 'validator',
                                    'files' => 'true',
                                ]) !!}
                                    <div class="row">
                                        <div class="col-md-3 mb-3">
                                            <label class="">{{ trans('home.name_en') }}</label>
                                            <input class="form-control @error('name_en') is-invalid @enderror" name="name_en" value="{{$webinar->name_en}}"
                                                type="text" placeholder="{{ trans('home.name_en') }}" required
                                                value="{{ old('name_en') }}">
                                            @error('name_en')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
    
                                        <div class="col-md-3 mb-3">
                                            <label class="">{{ trans('home.name_ar') }}</label>
                                            <input class="form-control @error('name_ar') is-invalid @enderror" name="name_ar" value="{{$webinar->name_ar}}"
                                                type="text" placeholder="{{ trans('home.name_ar') }}"
                                                value="{{ old('name_ar') }}">
                                            @error('name_ar')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label class="">{{ trans('home.speaker') }}</label>
                                            <input class="form-control @error('speaker') is-invalid @enderror" name="speaker" value="{{$webinar->speaker}}"
                                                type="text" placeholder="{{ trans('home.speaker') }}"
                                                value="{{ old('speaker') }}">
                                            @error('speaker')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label class="">{{ trans('home.price') }}</label>
                                            <input class="form-control @error('price') is-invalid @enderror" name="price" value="{{$webinar->price}}"
                                                type="number" placeholder="{{ trans('home.price') }}"
                                                value="{{ old('price') }}">
                                        </div>
    
                                        <div class="col-md-3 mb-3">
                                            <label class="">{{ trans('home.location') }}</label>
                                            <input class="form-control " name="location" value="{{$webinar->location}}"
                                                type="text" placeholder="{{ trans('home.location') }}"
                                                value="{{ old('location') }}">
                                        </div>
                                        
                                        <div class="col-md-3 mb-3">
                                            <label for="type">{{trans('home.webinar_type')}}</label>
                                            <select class="form-control" data-trigger name="type">
                                                <option value="" >{{ trans('home.choose_type') }}</option>
                                                <option value="offline" @selected(old('type',$webinar->type) == 'offline') >{{ trans('home.offline') }}</option>
                                                <option value="online" @selected(old('type',$webinar->type) == 'online') >{{ trans('home.online') }}</option>
                                                <option value="offline_and_online" @selected(old('type',$webinar->type) == 'offline_and_online') >{{ trans('home.offline_and_online') }}</option>
                                            </select>
                                        </div>
                                        
                                        <div class="col-md-3 mb-3" id="start_date">
                                            <label for="start_date">{{ trans('home.start_date') }}</label>
                                            <input type="datetime-local" class="form-control" placeholder="{{ trans('home.start_date') }}"  value="{{$webinar->start_date}}"
                                                name="start_date">
                                        </div>
                                        <div class="col-md-3 mb-3" id="end_date">
                                            <label for="end_date">{{ trans('home.end_date') }}</label>
                                            <input type="datetime-local" class="form-control" placeholder="{{ trans('home.end_date') }}" value="{{$webinar->end_date}}"
                                                name="end_date">
                                        </div>
                                        <div class="col-md-8 mb-3 mt-3">
                                            <label for="formFile" class="form-label">{{ trans('home.choose_image') }}</label>
                                            <input class="form-control" type="file" id="formFile" name="image">
                                        </div>
                                        @if($webinar->image)
                                            <div class="form-group  col-md-2 m-2 mt-3">
                                                <img src="{{url('\uploads\webinars\source')}}\{{$webinar->image}}" width="200" height="150">
                                            </div>
                                        @else
                                            <div class="form-group  col-md-3 mt-3">
                                                <img src="{{url('resources/assets/back/images/noimage.jpg')}}" width="70">
                                            </div>
                                        @endif

                                    </div>
                                    <div class="row mt-4">
                                        <div class="form-group col-md-6 ">
                                            <label for="text_en">{{trans('home.text_en')}}</label>
                                            <textarea class="form-control ckeditor-classic area1" name="text_en" placeholder="{{trans('home.text_en')}}" >{!! $webinar->text_en !!}</textarea>
                                        </div>
    
                                        <div class="form-group col-md-6 ">
                                            <label for="text_ar">{{trans('home.text_ar')}}</label>
                                            <textarea class="form-control ckeditor-classic area1" name="text_ar" placeholder="{{trans('home.text_ar')}}" >{!! $webinar->text_ar !!}</textarea>
                                        </div>
                                        <div class="form-group col-md-6 mt-4">
                                            <label for="text_en_2">{{trans('home.text_2').' '.__('home.en')}}</label>
                                            <textarea class="form-control ckeditor-classic area1" name="text_en_2" placeholder="{{trans('home.text_2').' '.__('home.en')}}" >{!! $webinar->text_en_2 !!}</textarea>
                                        </div>
    
                                        <div class="form-group col-md-6 mt-4">
                                            <label for="text_ar_2">{{trans('home.text_2').' '.__('home.ar')}}</label>
                                            <textarea class="form-control ckeditor-classic area1" name="text_ar_2" placeholder="{{trans('home.text_2').' '.__('home.ar')}}" >{!! $webinar->text_ar_2 !!}</textarea>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <span class="badge-soft-primary">{{ trans('home.en') }}</span>
                                            <div class="col-md-12 mb-3">
                                                <label for="link_en">{{ trans('home.slug') }}</label>
                                                <input type="text" class="form-control" value="{{$webinar->link_en}}"
                                                    placeholder="{{ trans('home.slug') . ' ' . __('home.en') }}"
                                                    name="link_en">
                                            </div>
                                        </div>


                                        <div class="form-group col-md-6">
                                            <span class="badge-soft-primary">{{ trans('home.ar') }}</span>
                                            <div class="col-md-12 mb-3">
                                                <label for="link_ar">{{ trans('home.slug') }}</label>
                                                <input type="text" class="form-control" value="{{$webinar->link_ar}}"
                                                    placeholder="{{ trans('home.slug') . ' ' . __('home.ar') }}"
                                                    name="link_ar">
                                            </div>
                                        </div>

                                        <div class="form-group col-4">
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch"
                                                    switch="success" {{ $webinar->status ? 'checked' : '' }} />
                                                <label for="switch" data-on-label="{{ trans('home.yes') }}"
                                                    data-off-label="{{ trans('home.no') }}"></label>
                                                <label class="form-check-label mx-3" for="switch">
                                                    {{ trans('home.publish') }}</label>
                                            </div>
                                        </div>
                                        <div class="mt-4">
                                            <button type="submit"
                                                class="btn btn-primary w-md">{{ trans('home.save') }}</button>
                                            <a href="{{ url('/admin/exames') }}"><button type="button"
                                                    class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                                    {{ trans('home.cancel') }}</button></a>
                                        </div>
                                    </div>

                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection

