@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_webinar')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.webinars')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{route('webinars.index')}}">{{trans('home.webinars')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_webinar')}}</li>
            </ol>
        </div>
    </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                {!! Form::open(['route' => 'webinars.store', 'data-toggle' => 'validator', 'files'=>'true']) !!}
                                <!-- Row-->
                                @csrf
                                <div class="row">
                                    <div class="col-md-3 mb-3">
                                        <label class="">{{ trans('home.name_en') }}</label>
                                        <input class="form-control @error('name_en') is-invalid @enderror" name="name_en"
                                            type="text" placeholder="{{ trans('home.name_en') }}" required
                                            value="{{ old('name_en') }}">
                                        @error('name_en')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="col-md-3 mb-3">
                                        <label class="">{{ trans('home.name_ar') }}</label>
                                        <input class="form-control @error('name_ar') is-invalid @enderror" name="name_ar"
                                            type="text" placeholder="{{ trans('home.name_ar') }}"
                                            value="{{ old('name_ar') }}">
                                        @error('name_ar')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label class="">{{ trans('home.speaker') }}</label>
                                        <input class="form-control @error('speaker') is-invalid @enderror" name="speaker"
                                            type="text" placeholder="{{ trans('home.speaker') }}"
                                            value="{{ old('speaker') }}">
                                        @error('speaker')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label class="">{{ trans('home.price') }}</label>
                                        <input class="form-control @error('price') is-invalid @enderror" name="price"
                                            type="number" placeholder="{{ trans('home.price') }}"
                                            value="{{ old('price') }}">
                                    </div>

                                    <div class="col-md-3 mb-3">
                                        <label class="">{{ trans('home.location') }}</label>
                                        <input class="form-control " name="location"
                                            type="text" placeholder="{{ trans('home.location') }}"
                                            value="{{ old('location') }}">
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label for="type">{{trans('home.webinar_type')}}</label>
                                        <select class="form-control" data-trigger name="type">
                                            <option value="" >{{ trans('home.choose_type') }}</option>
                                            <option value="offline" @selected(old('type') == 'offline') >{{ trans('home.offline') }}</option>
                                            <option value="online" @selected(old('type') == 'online') >{{ trans('home.online') }}</option>
                                            <option value="offline_and_online" @selected(old('type') == 'offline_and_online') >{{ trans('home.offline_and_online') }}</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-3" id="start_date">
                                        <label for="start_date">{{ trans('home.start_date') }}</label>
                                        <input type="datetime-local" class="form-control" placeholder="{{ trans('home.start_date') }}"
                                            name="start_date">
                                    </div>
                                    <div class="col-md-3 mb-3" id="end_date">
                                        <label for="end_date">{{ trans('home.end_date') }}</label>
                                        <input type="datetime-local" class="form-control" placeholder="{{ trans('home.end_date') }}"
                                            name="end_date">
                                    </div>
                                    <div class="col-md-12 mb-3 mt-3">
                                        <label for="formFile" class="form-label">{{ trans('home.choose_image') }}</label>
                                        <input class="form-control" type="file" id="formFile" name="image">
                                    </div>



                                </div>
                                <div class="row mt-4">
                                    <div class="form-group col-md-6 ">
                                        <label for="text_en">{{trans('home.text_en')}}</label>
                                        <textarea class="form-control ckeditor-classic area1" name="text_en" placeholder="{{trans('home.text_en')}}" ></textarea>
                                    </div>

                                    <div class="form-group col-md-6 ">
                                        <label for="text_ar">{{trans('home.text_ar')}}</label>
                                        <textarea class="form-control ckeditor-classic area1" name="text_ar" placeholder="{{trans('home.text_ar')}}" ></textarea>
                                    </div>
                                    <div class="form-group col-md-6 ">
                                        <label for="text_en_2">{{trans('home.text_2').' '.__('home.en')}}</label>
                                        <textarea class="form-control ckeditor-classic area1" name="text_en_2" placeholder="{{trans('home.text_2').' '.__('home.en')}}" ></textarea>
                                    </div>

                                    <div class="form-group col-md-6 ">
                                        <label for="text_ar_2">{{trans('home.text_2').' '.__('home.ar')}}</label>
                                        <textarea class="form-control ckeditor-classic area1" name="text_ar_2" placeholder="{{trans('home.text_2').' '.__('home.ar')}}" ></textarea>
                                    </div>


                                    <div class="form-group col-md-6">
                                        <span class="badge-soft-primary">{{ trans('home.en') }}</span>
                                        <div class="col-md-12 mb-3">
                                            <label for="link_en">{{ trans('home.slug') }}</label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ trans('home.slug') . ' ' . __('home.en') }}"
                                                name="link_en">
                                        </div>
                                    </div>


                                    <div class="form-group col-md-6">
                                        <span class="badge-soft-primary">{{ trans('home.ar') }}</span>
                                        <div class="col-md-12 mb-3">
                                            <label for="link_ar">{{ trans('home.slug') }}</label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ trans('home.slug') . ' ' . __('home.ar') }}"
                                                name="link_ar">
                                        </div>
                                    </div>
                                    <div class="form-group col-12 mb-3">
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="status" id="switch"
                                                switch="success" checked />
                                            <label for="switch" data-on-label="{{ trans('home.yes') }}"
                                                data-off-label="{{ trans('home.no') }}"></label>
                                            <label class="form-check-label mx-3" for="switch">
                                                {{ trans('home.publish') }}</label>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group col-12 mb-3">
                                        <button type="submit" class="btn btn-primary">{{ trans('home.save') }}</button>
                                        <a href="{{ url('/admin/webinars') }}"><button type="button"
                                                class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                                {{ trans('home.cancel') }}</button></a>
                                    </div>
                                </div>
                                <!-- End Row -->
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
