@extends('layouts.admin')
<title>{{trans("home.add_user")}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.users')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('admin/roles')}}">{{trans('home.users')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_user')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.add_user')}}</h6>
                        </div>
                        {!! Form::open(['route' => 'users.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
                            <div class="row">

                                <div class="col-md-3 mb-3">
                                    <label for="helperText">{{trans('home.f_name')}}</label>
                                    <input type="text" class="form-control" placeholder="{{trans('home.f_name')}}"  name="f_name"  required>
                                </div>
                                
                                <div class="col-md-3 mb-3">
                                    <label for="helperText">{{trans('home.l_name')}}</label>
                                    <input type="text" class="form-control" placeholder="{{trans('home.l_name')}}"  name="l_name"  required>
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="helperText">{{trans('home.email')}}</label>
                                    <input type="text" class="form-control email" placeholder="{{trans('home.email')}}"  name="email"  required>
                                </div>

                                <div class="col-md-3">
                                    <label for="helperText">{{trans('home.password')}}</label>
                                    <input type="password" class="form-control" placeholder="{{trans('home.password')}}" name="password" data-minlength="8" required>
                                    <p class="pristine-error text-help">{{trans('home.Your Password Must Be at Least 8 Characters')}}</p>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="formFile" class="form-label">{{ trans('home.choose_image') }}</label>
                                    <input class="form-control" type="file" id="formFile" name="image">
                                </div>
                                <div class="col-md-6 mb-3 ">
                                    <label for="phone1">{{__('home.phone')}}</label>
                                    <div class="input-group">
                                        <div class="input-group-text"><i class="fas fa-phone"></i></div>
                                        <input class="form-control"  type="number" min="0" placeholder="Phone" name="phone" autocomplete="off">
                                    </div>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="helperText">{{trans('home.roles')}}</label>
                                    <select class="form-control" name="role">
                                        @foreach($roles as $role)
                                                <option value="{{$role->name}}" >{{ $role->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group col-md-6">            
                                    <label for="helperText">{{trans('home.type')}}</label>
                                    <select class="form-control" data-trigger name="type">
                                        <option value="admin" @selected(old('type') == 'admin') >{{trans('home.admin')}}</option>
                                        <option value="student" @selected(old('type') == 'student')>{{trans('home.student')}}</option>
                                        <option value="teacher" @selected(old('type') == 'teacher')>{{trans('home.teacher')}}</option>
                                        <option value="crm_employee" @selected(old('type') == 'crm_employee')>{{trans('home.crm_employee')}}</option>
                                    </select>
                                </div>
                                
                                <div class="form-group col-md-6">            
                                    <label for="helperText">{{trans('home.status')}}</label>
                                    <select class="form-control" data-trigger name="status">
                                        <option value="active" @selected(old('status') == 'active') >{{trans('home.admin')}}</option>
                                        <option value="inactive" @selected(old('status') == 'inactive')>{{trans('home.student')}}</option>
                                        <option value="block" @selected(old('status') == 'block')>{{trans('home.instructor')}}</option>
                                    </select>
                                </div>
                                
                                <div class="form-group col-md-6">            
                                    <label for="helperText">{{trans('home.country')}}</label>
                                    <select class="form-control" data-trigger name="country_id">
                                        <option value="" >{{trans('home.select_country')}}</option>
                                        @foreach($countries as $country)
                                            <option value="{{ $country->id }}" @selected(old('country_id') == $country->id)>{{ $country->{'name_'.$lang} }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="form-group col-md-6">            
                                    <label for="helperText">{{trans('home.area')}}</label>
                                    <select class="form-control" data-trigger name="area_id">
                                        <option value="" >{{trans('home.select_area')}}</option>
                                        @foreach($areas as $area)
                                            <option value="{{ $area->id }}" @selected(old('area_id') == $area->id)>{{ $area->{'name_'.$lang} }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="form-group col-md-6">            
                                    <label for="helperText">{{trans('home.region')}}</label>
                                    <select class="form-control" data-trigger name="region_id">
                                        <option value="" >{{trans('home.select_region')}}</option>
                                        @foreach($regions as $region)
                                            <option value="{{ $region->id }}" @selected(old('region_id') == $region->id)>{{ $region->{'name_'.$lang} }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                
                            </div>
                            <div class="mt-4">
                                <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                <a href="{{url('/admin/users')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                                
                            </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
@section('script')
    <script>
        $('.role').select2({
            placeholder: 'Select Roles'
        });

        $('.admin').select2();

        $(".email").attr("autocomplete","off");
        
    </script>
@endsection