@extends('layouts.admin')
<title>{{trans('home.trainings')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.trainings')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.trainings')}}</li>
                </ol>
            </div>
            @can('operations')
            <div class="btn btn-list">
                <a href="{{url('admin/trainings/create')}}"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> {{trans('home.add')}}</button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> {{trans('home.publish/unpublish')}}</button></a>
                <a class="mr-2" id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
            </div>
            @endcan
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.trainings')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                            <hr>
                        </div>
                        @can('trainings_excel')
                       
                        <form method="post" action="{{ route('trainings.import.excel') }}" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    {{-- <label>{{trans('home.Exel')}}</label> --}}
                                    <div class="input-group mb-1 d-flex justify-content-first">
                                        <div class="input-group-prepend"> 
                                            <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                        </div>
                                        <div class="custom-file col-3">
                                            <input type="file" class="custom-file-input" name="excelFile"  accept=".csv,.xlsx">
                                            <label class="custom-file-label"
                                                for="inputGroupFile01">{{ trans('home.choose_excel_file') }}</label>
                                        </div>
                                        <button class="btn ripple btn-primary mr-5" type="submit"><i
                                        class="fas fa-plus-circle"></i>
                                        {{ trans('home.importExcel') }}</button>
                                    </div>
                                        
                                    @error('excelFile')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </form>
                        @endcan
                        <div class="table-responsive">
                        <table class="table text-center" id="exportexample">
                        <thead>
                            <tr>
                                <th><input type="checkbox" class="form-check-input" id="checkAll" /></th>
                                <th>{{ trans('home.id') }}</th>
                                <th>{{ trans('home.name') }}</th>
                                <th>{{ trans('home.category') }}</th>
                                <th>{{ trans('home.training_type') }}</th>
                                <th>{{ __('home.course') }}</th>
                                <th>{{ __('home.publish/unpublish') }}</th>
                                <th>{{ __('home.edit') }}</th>
                                <!--<th>{{ __('home.delete') }}</th>-->
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($trainings as $training)
                                <tr id="{{ $training->id }}">
                                    <td> <input type="checkbox" name="checkbox" class="tableChecked form-check-input"
                                            value="{{ $training->id }}" /> </td>
                                    <td><a href="{{ route('courses.edit', $training->id) }}">{{ $training->id }}</a></td>
                                    <td>{{ $training->{'name_' . $lang} }}</td>
                                    <td>{{ $training->category ? $training->category->{'name_' . $lang} : 'N/A' }}</td>
                                    <td>{{ $training->type ? $training->type->{'name_' . $lang} : 'N/A' }}</td>
                                    <td>
                                        @if($training->course) 
                                            <a href="{{ url('admin/courses/' . $training->course->course_id ) }}" 
                                                class="btn btn-info waves-effect waves-light ">{{  __('home.course') }}
                                            </a>
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                    <td>
                                        <input class="btn_active" data-id="{{ $training->id }}" type="checkbox"
                                            id="switch-{{ $training->id }}" switch="success"
                                            {{ $training->status == 1 ? 'checked' : '' }} />
                                        <label for="switch-{{ $training->id }}" data-on-label="{{ trans('home.yes') }}"
                                            data-off-label="{{ trans('home.no') }}"></label>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-info waves-effect waves-light "
                                            href="{{ route('trainings.edit', $training->id) }}">{{ __('home.edit') }}</a>
                                    </td>
                                   {{-- <td>
                                                    <a type="button" class="btn btn-danger waves-effect waves-light btn_delete" href="{{ route('trainings.destroy', $training->id) }}"
                                            >{{ __('home.delete') }}</a>
                                    </td>--}}
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection

