@extends('layouts.admin')

@section('meta')
    <title>{{trans('home.trainings')}}</title>
@endsection

@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.trainings')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.trainings')}}</li>
                </ol>
            </div>
            @can('ask_for_adding_new_training')
                <a href="#"  data-bs-toggle="modal" data-bs-target="#trainingPartnerRequestmodel">
                    <button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i>     {{__('home.ask_for_adding_new_training')}}
                    </button>
                </a>
            @endcan
            @can('trainings_operations')
            <div class="btn btn-list">
                @can('trainings_add_buttons')
                    <a href="#"  data-bs-toggle="modal" data-bs-target="#importtrainingsmodel">
                        <button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i>     {{__('home.import_trainings_excel')}}
                        </button>
                    </a>
                    <a class="mr-2" href="{{url('admin/trainings/create')}}"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> {{trans('home.add')}}</button></a>
                 @endcan
                 @can('trainings_delete_buttons')
                    <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> {{trans('home.publish/unpublish')}}</button></a>
                    <a class="mr-2" id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
                @endcan
            </div>
            @endcan
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.trainings')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                            <hr>
                        </div>
                        <div class="d-flex justify-content-left m-3">
                            <input style="width:15px; margin-left:5px" type="checkbox" name="checkbox" class="tableChecked" value="Select All" id="checkAll"/>
                            <label style="font-size:20px; padding-top:10px" for="checkAll">{{trans('home.select_all')}}</label>
                        </div>
                        {!! $dataTable->table(['class' => 'table table-bordered w-100']) !!}
                    </div>
                </div>
            </div>
        </div>
        
        <!-- End Row -->
        <!-- Import Excel  -->
        <div class="modal fade bd-example-modal-xl" id="importtrainingsmodel" tabindex="-1" role="dialog" aria-labelledby="importtrainingsmodelTitle" aria-hidden="true">
          <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content" style="border-radius: 35px;">
              <div class="modal-header">
                 <img src="{{url('resources/assets/back/img/excel-training-guide.png')}}">
              </div>    
            <form method="post" action="{{ route('trainings.import.excel') }}" enctype="multipart/form-data">
              <div class="modal-body ">
                    <div class="m-auto">
                            @csrf
                            <div class="input-group mb-1 d-flex justify-content-first">
                                <div class="custom-file m-auto col-6">
                                    <div class="input-group-prepend"> 
                                        <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                    </div>
                                    <input type="file" class="custom-file-input" name="excelFile"  accept=".csv,.xlsx">
                                    <label class="custom-file-label"
                                        for="inputGroupFile01">{{ trans('home.choose_excel_file') }}</label>
                                </div>
                               
                            </div>
                    </div>
              </div>
              <div class="modal-footer  justify-content-center ">
                   <button class="btn ripple btn-primary " type="submit"><i
                                class="fas fa-plus-circle"></i>
                                {{ trans('home.importExcel') }}</button>
                <button id="closeModalButton" type="button" class="btn btn-secondary " data-bs-dismiss="modal">Close</button>
              </div>
                        </form>
            </div>
          
          </div>
        </div>
             <!-- ask_for_adding_new_training as partner  -->
        <div class="modal fade bd-example-modal-lg" id="trainingPartnerRequestmodel" style="z-index:99999" tabindex="-1" role="dialog" aria-labelledby="trainingPartnerRequestmodelTitle" aria-hidden="true">
          <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content" style="border-radius: 35px;">
              <div class="modal-header">
                 <h5 class="m-auto">{{__('home.ask_for_adding_new_training')}}</h5>
              </div>
            <form method="post" action="{{ route('save_partners_training_request') }}" enctype="multipart/form-data">
              <div class="modal-body ">
                    <div class="m-auto">
                        @csrf
                        
                            <input type="hidden" name="name_en" id="hidden_name_en">
                            <input type="hidden" name="name_ar" id="hidden_name_ar">
                            <input type="hidden" name="n_students" id="hidden_n_students">
                            <input type="hidden" name="address" id="hidden_address">
                            <input type="hidden" name="training_type" id="hidden_training_type">
                            <input type="hidden" name="timing_type" id="hidden_timing_type">
                            <input type="hidden" name="online_url" id="hidden_online_url">
                            <input type="hidden" name="hall_id" id="hidden_hall_id">
                            <input type="hidden" name="training_field_id" id="hidden_training_field_id">
                            <input type="hidden" name="recorded" id="hidden_recorded">
                            <!--<input type="hidden" name="overall_days" id="hidden_overall_days">-->
                            <input type="hidden" name="overall_time" id="hidden_overall_time">
                            <input type="hidden" name="instructor_id" id="hidden_instructor_id">
                            <input type="hidden" name="start_date" id="hidden_start_date">
                            <input type="hidden" name="end_date" id="hidden_end_date">
                            <input type="hidden" name="time_from" id="hidden_time_from">
                            <input type="hidden" name="time_to" id="hidden_time_to">
                        
                        
                            <div class="row m-2">
                                <div class="form-group col-md-3">
                                    <label class="">{{trans('home.name_en')}}</label>
                                    <input class="form-control @error('name_en') is-invalid @enderror" name="name_en" id="name_en" type="text" placeholder="{{trans('home.name_en')}}">
                                    @error('name_en')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label class="">{{trans('home.name_ar')}} <span style="color: red;padding: 0 3px">*</span></label>
                                    <input class="form-control @error('name_ar') is-invalid @enderror" name="name_ar" id="name_ar" type="text" placeholder="{{trans('home.name_ar')}}" required>
                                    @error('name_ar')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-md-3">
                                    
                                    <label class="">{{trans('home.n_students')}}(<span class="badge badge-warning">{{ trans('home.30_students_limited') }}</span>)</label>
                                    <input class="form-control" name="n_students" type="number" id="n_students" placeholder="{{trans('home.n_students')}}" required>
                                </div>
                                <div class="form-group col-md-3">
                                    <label for="training_type">{{trans('home.training_type')}}</label>
                                    <select id="training_type" class="form-control select2" name="training_type" required>
                                        <option value="online">{{trans('home.online')}}</option>
                                        <option value="offline">{{trans('home.offline')}}</option>
                                    </select>
                                </div>
                                <div class="form-group col-md-3">
                                    <label class="">{{trans('home.address').' /url' }}</label>
                                    <input id="address" class="form-control" name="address" type="text" placeholder="{{trans('home.address')}}" >
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label class="">{{trans('home.online_url')}}</label>
                                    <input id="online_url" class="form-control @error('online_url') is-invalid @enderror" name="online_url" type="text" placeholder="{{trans('home.online_url')}}">
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label for="request_type">{{trans('home.request_type')}}</label>
                                    <select class="form-control select2" name="request_type" id="request_type" required>
                                        <option selected value="new">{{trans('home.new_request')}}</option>
                                        <option value="edit">{{trans('home.edit_request')}}</option>
                                        <option value="exception">{{trans('home.exception_request')}}</option>
                                    </select>
                                </div>
                                
                                <div class="form-group col-md-3" id="exception_or_not_div">
                                    <label for="exception_or_not">{{trans('home.exception_or_not')}}</label>
                                    <select class="form-control select2" name="exception_or_not" id="exception_or_not" required>
                                        <option value="">{{trans('home.exception_or_not')}}</option>
                                        <option value="yes">{{trans('home.yes')}}</option>
                                        <option value="no">{{trans('home.no')}}</option>
                                    </select>
                                </div>
                                
                                <div class="form-group col-md-3" style="display:none" id="code_to_edit">
                                    
                                </div>
                                
                                <div class="form-group col-md-3" style="display:none" id="exception_file">
                                    
                                </div>
    
                                <!--<div class="col-md-4">-->
                                <!--    <label>{{trans('home.image')}}</label>-->
                                <!--    <div class="input-group mb-1">-->
                                <!--        <div class="input-group-prepend">-->
                                <!--            <span class="input-group-text"> {{trans('home.upload')}}</span>-->
                                <!--        </div>-->
                                <!--        <div class="custom-file">-->
                                <!--            <input type="file" class="custom-file-input" name="image">-->
                                <!--            <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>-->
                                <!--        </div>-->
                                <!--    </div>-->
                                <!--    @error('image')-->
                                <!--        <span class="invalid-feedback" role="alert">-->
                                <!--            <strong>{{ $message }}</strong>-->
                                <!--        </span>-->
                                <!--    @enderror-->
                                <!--</div>-->
    
                                <!--<div class="form-group col-md-3">-->
                                <!--    <label class="">{{trans('home.alt_img')}}</label>-->
                                <!--    <input class="form-control" name="alt_img" type="text" placeholder="{{trans('home.alt_img')}}" />-->
                                <!--</div>-->
                                
                            @if(auth()->user()->type != "partner")
                                <div class="form-group col-md-3">
                                    @error('center_id') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                    <label class="">{{trans('home.partner')}}<span style="color: red;padding: 0 3px">*</span></label>
                                    <select class="form-control select2 centers" required name="center_id" id="" {{auth()->user()->type=="partner"?'disabled':''}} >
                                        <option value="">{{ __('home.choose_center') }}</option>
                                        @foreach ($centers as $center)
                                            <option value ="{{$center->id}}" @selected(old('center_id')== $center->id)>{{(app()->getLocale()=='en')? $center->name_en:$center->name_ar}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @else
                                <div style="display:none" class="form-group col-md-3">
                                    <select required  class="form-control select2 centers" name="center_id" id="" {{auth()->user()->type=="partner"?'disabled':''}}>
                                        @foreach ($centers as $center)
                                           @if(!empty(auth()->user()->partner->first()->centers()->first())) <option value ="{{$center->id}}" @selected(auth()->user()->partner->first()->centers()->first()->id== $center->id)>{{(app()->getLocale()=='en')? $center->name_en:$center->name_ar}}</option> @endif
                                        @endforeach
                                    </select>
                                </div>
                            @endif
                                
                                <div class="form-group col-md-3">
                                    <label for="centers">{{trans('home.instructor')}}<span style="color: red;padding: 0 3px">*</span></label>
                                    <select class="form-control select2 instructors" name="instructor_id" id="instructor_id" required>
                                        @foreach($instructors as $instructor)
                                            <option value="{{$instructor->id}}" >{{$instructor->f_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                
                               {{-- @if(auth()->user()->type !='partner')
                                <div class="form-group col-md-3">
                                    <label for="centers">{{trans('home.centers')}}<span style="color: red;padding: 0 3px">*</span></label>
                                    <select class="form-control select2 centers" name="center_id" id="center_id" required>
                                        @foreach($centers as $center)
                                            <option value="{{$center->id}}" >{{(app()->getLocale() == 'en')?$center->name_en:$center->name_ar }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                @endif --}}
                                
                                <div class="form-group col-md-3">
                                    <label for="centers">{{trans('home.center_halls')}}</label>
                                    <select class="form-control select2 halls" name="hall_id" id="hall_id" required>
                                        @if(auth()->user()->type =='partner')
                                                <option value="">{{ trans('home.choose_hall') }}</option>
                                            @foreach($halls as $hall)
                                                <option value="{{$hall->id}}" >{{(app()->getLocale() == 'en')?$hall->name_en:$hall->name_ar }}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                                
                                <div style="display:none" class="hall_details row col-md-6">
                                    
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label for="start_date">{{trans('home.start_date')}}<span style="color: red;padding: 0 3px">*</span></label>
                                    <div class="input-group">
                                        <input type='date' class="form-control datepicker" name="start_date" id="start_date" placeholder="{{trans('home.start_date')}}"  value="{{old('start_date')}}" required/>
                                    </div>
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label for="end_date">{{trans('home.end_date')}}<span style="color: red;padding: 0 3px">*</span></label>
                                    <div class="input-group">
                                        <input type='date' class="form-control datepicker" name="end_date" id="end_date" placeholder="{{trans('home.end_date')}}"  value="{{old('end_date')}}" required/>
                                    </div>
                                </div>
                                <div class="form-group col-md-4">
                                    <label for="training_field_id">{{trans('home.training_field_id')}}<span style="color: red;padding: 0 3px">*</span></label>
                                    <select class="form-control select2 col-12" name="training_field_id" id="training_field_id" required>
                                        @foreach($fields as $field)
                                            <option value="{{$field->id}}" >{{(app()->getLocale() == 'en')?$field->name_en:$field->name_ar }}</option>
                                        @endforeach
                                    </select>
                                </div>
    
                             
                                
                                <div class="form-group col-md-3">
                                    <label for="timing_type">{{trans('home.timing_type')}}<span style="color: red;padding: 0 3px">*</span></label>
                                    <select class="form-control select2" name="timing_type" id="timing_type" required>
                                        <option value="AM">{{trans('home.AM')}}</option>
                                        <option value="PM">{{trans('home.PM')}}</option>
                                    </select>
                                </div>
                                
                                <div class="form-group col-md-2">
                                    <label for="recorded">{{trans('home.recorded')}}<span style="color: red;padding: 0 3px">*</span></label>
                                    <select class="form-control select2" name="recorded" id="recorded" required>
                                        <option value="yes">{{trans('home.yes')}}</option>
                                        <option value="no">{{trans('home.no')}}</option>
                                    </select>
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label for="time_from">{{trans('home.time_from')}} ({{trans('home.attendance')}})</label>
                                    <div class="input-group"> <span style="color: red;padding: 0 3px">*</span>
                                        <input type='time' class="form-control timepicker" name="time_from" id="time_from" placeholder="{{trans('home.time_from')}}" value="{{old('time_from')}}" required/>
                                    </div>
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label for="time_to">{{trans('home.time_to')}} ({{trans('home.attendance')}})</label>
                                    <div class="input-group">
                                        <input type='time' class="form-control timepicker" name="time_to" id="time_to" placeholder="{{trans('home.time_to')}}" value="{{old('time_to')}}" required/>
                                    </div>
                                </div>
    
                                <div class="form-group col-md-2">
                                    <label class="">{{trans('home.overall_days')}}</label>
                                    <input class="form-control" name="overall_days" id="overall_days" type="number" min="0" placeholder="{{trans('home.overall_days')}}" required/>
                                </div>
                                
                                <div class="form-group col-md-2">
                                    <label class="">{{trans('home.overall_time')}}</label>
                                    <input class="form-control" name="overall_time" id="overall_time" type="number" min="0" placeholder="{{trans('home.overall_time')}}" required/>
                                </div>
                                <!-- <div class="form-group col-md-3">-->
                                <!--    <label for="view_survey">{{trans('home.view_survey_date')}}</label>-->
                                <!--    <div class="input-group">-->
                                <!--        <input type='date' class="form-control datepicker" name="view_survey" placeholder="{{trans('home.view_survey_date')}}"  value="{{old('view_survey')}}" />-->
                                <!--    </div>-->
                                <!--</div>-->
                                
                                <!--<div class="form-group col-md-3">-->
                                <!--    <label for="view_exam">{{trans('home.view_exam_date')}}</label>-->
                                <!--    <div class="input-group">-->
                                <!--        <input type='date' class="form-control datepicker" name="view_exam" placeholder="{{trans('home.view_exam_date')}}"  value="{{old('view_exam')}}" />-->
                                <!--    </div>-->
                                <!--</div>-->
                                @if(auth()->user()->type !='partner')
                                <div class="form-group col-md-4">
                                    <label for="helperText">{{trans('home.courses')}}  <span class="badge badge-warning">({{trans('home.match training with at least one course')}})</span></label>
                                    <select class="form-control role select2" name="courses_id[]" multiple required>
                                        @foreach($courses as $course)
                                            <option value="{{$course->id}}" >{{(app()->getLocale() == 'en')?$course->name_en:$course->name_ar }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                @endif
                            </div>
                    </div>
              </div>
              <div class="modal-footer  justify-content-center ">
                   <button class="btn ripple btn-primary " type="submit"><i
                                class="fas fa-plus-circle"></i>
                                {{ trans('home.send') }}</button>
                <button id="closeModalButton" type="button" class="btn btn-secondary " data-bs-dismiss="modal">Close</button>
              </div>
            </form>
            </div>
          
          </div>
        </div>
           
       
    
    </div>
     
   
@endsection

@section('script')
<script>
    $(document).ready(function() {
        // Initialize Select2 for elements outside of modals
        $('.select2').select2();

        // Initialize Select2 for elements inside the "importtrainingsmodel" modal
        $('#importtrainingsmodel').on('shown.bs.modal', function () {
            $('.select2').select2({
                dropdownParent: $('#importtrainingsmodel')
            });
        });

        // Initialize Select2 for elements inside the "trainingPartnerRequestmodel" modal
        $('#trainingPartnerRequestmodel').on('shown.bs.modal', function () {
            $('.select2').select2({
                dropdownParent: $('#trainingPartnerRequestmodel')
            });
        });
    });

    // Fetch center halls based on the selected center
    $('.centers').change(function () {
        var id = $(this).val();
        var halls = $('.halls');
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            type: "POST",
            url: "{{ url('admin/getCenterHalls') }}",
            data: {id: id},
            success: function(data) {
                var html = '<option></option>';
                for (var i = 0; i < data.length; i++) {
                    html += '<option value="'+ data[i].id +'">' + ({{ \App::getLocale() == 'en' ? 'data[i].name_en' : 'data[i].name_ar' }}) + '</option>';
                }
                halls.html(html);
            }
        });
    });

    // Fetch hall details based on the selected hall
    $('.halls').change(function () {
        var id = $(this).val();
        var halls = $('.hall_details');
        halls.show();
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            type: "POST",
            url: "{{ url('admin/getHallDetails') }}",
            data: {id: id},
            success: function(data) {
                var html = '';
                html += '<div class="form-group col-md-4 hall_details"><label class="">' + "{{ trans('home.map_url') }}" + '</label><input class="form-control" name="map_url" type="text" value="' + data.map_url + '" placeholder="' + "{{ trans('home.map_url') }}" + '" readonly></div>';
                html += '<div class="form-group col-md-4 hall_details"><label class="">' + "{{ trans('home.area') }}" + '</label><input class="form-control " name="area" type="text" value="' + ({{ \App::getLocale() == 'ar' ? 'data.area.name_ar' : 'data.area.name_en' }}) + '" placeholder="' + "{{ trans('home.area') }}" + '" readonly></div>';
                html += '<div class="form-group col-md-4 hall_details"><label class="">' + "{{ trans('home.region') }}" + '</label><input class="form-control " name="region" type="text" value="' + ({{ \App::getLocale() == 'ar' ? 'data.region.name_ar' : 'data.region.name_en' }}) + '" placeholder="' + "{{ trans('home.region') }}" + '" readonly></div>';
                halls.html(html);
            }
        });
    });
 $(document).ready(function() {
    $('#exception_or_not').on('change', function() {
        if ($(this).val() === 'yes') {
            exeception = "";
            exeception += '<label class="">' + "{{ trans('home.exception_file') }}" + '</label>';
            exeception += '<input class="form-control @error("exception_file") is-invalid @enderror" name="exception_file" type="file" placeholder="{{ trans("home.exception_file") }}">';
            $('#exception_file').html(exeception).show();
        } else {
            $('#exception_file').empty().hide();
        }
    });
    // Handle request type change to display appropriate fields
    $('#request_type').on('change', function() {
        
        $('.hall_details').hide();
        $('#exception_or_not_div').show();
        $('#name_en').val('').prop('disabled',false);
        $('#name_ar').val('').prop('disabled',false);
        // if(data.PartnerTrainingRequest){ 
        //     $('#n_students').val(data.PartnerTrainingRequest.n_students); 
        //     $('#address').val(data.PartnerTrainingRequest.address);
        // }
        $('#n_students').val('').prop('disabled',false);
        $('#address').val('').prop('disabled',false);
        // $('#training_type').val(data.training_type);
        $('#training_type option').removeAttr('selected');
        $('#training_type').val('').prop('disabled',false);
        $('#timing_type').val('').prop('disabled',false);
        $('#online_url').val('').prop('disabled',false);
        $('#hall_id').val('').prop('disabled',false);
        $('#training_field_id').val('').prop('disabled',false);
        $('#recorded').val('').prop('disabled',false);
        $('#overall_days').val('').prop('disabled',false);
        $('#overall_time').val('').prop('disabled',false);
        $('#instructor_id').val('').prop('disabled',false);
        $('#start_date').val('').prop('disabled',false);
        $('#end_date').val('').prop('disabled',false);
        $('#time_from').val('').prop('disabled',false);
        $('#time_to').val('').prop('disabled',false);
        
        
        var html = '';
        var html2 = '';

        $('#code_to_edit').empty().hide();
        $('#exception_file').empty().hide();

        if ($(this).val() === 'edit') {
            
            // $('#exception_or_not_div').show();
            
            html += '<label class="">' + "{{ trans('home.code_to_edit') }}" + '</label>';
            html += '<select id="select1" class="form-control select2 code_to_edit" name="code_to_edit" required>';
            html += '<option value="">' +  "{{ trans('home.choose_training') }}" + '</option>';
            @foreach($edit_trainings as $edit_training)
            html += '<option value="{{ $edit_training->code }}">{{ $edit_training->code . ' - ' . $edit_training->{"name_".$lang} }}</option>';
            @endforeach
            html += '</select>';

            $('#code_to_edit').html(html).show();
            
            
            $('.code_to_edit').on('change', function() {
                var code = $(this).val();
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    url: "{{ url('admin/get-request-data') }}",
                    data: {code: code},
                    success: function(data) {
                        $('#name_en').val(data.name_en).prop('disabled',true);
                        $('#name_ar').val(data.name_ar).prop('disabled',true);
                        if(data.PartnerTrainingRequest){ 
                            $('#n_students').val(data.PartnerTrainingRequest.n_students); 
                            $('#address').val(data.PartnerTrainingRequest.address);
                        }
                        $('#n_students').prop('disabled',true);
                        $('#address').prop('disabled',true);
                        $('#training_type').val(data.training_type).change().prop('disabled',true);
                        $('#timing_type').val(data.timing_type).change().prop('disabled',true);
                        $('#online_url').val(data.online_url).prop('disabled',true);
                        if(data.trainings_schaduals.hall_id){$('#hall_id').val(data.trainings_schaduals.hall_id).change().prop('disabled',true);} else {$('#hall_id').prop('disabled',true);}
                        $('#training_field_id').val(data.training_field_id).change().prop('disabled',true);
                        $('#recorded').val(data.recorded).change().prop('disabled',true);
                        $('#overall_days').val(data.overall_days).prop('disabled',true);
                        $('#overall_time').val(data.overall_time).prop('disabled',true);
                        $('#instructor_id').val(data.instructor_id).change();
                        
                        //update hidden fields with data
                        $('#hidden_name_en').val(data.name_en);
                        $('#hidden_name_ar').val(data.name_ar);
                        $('#hidden_training_type').val(data.training_type);
                        if(data.PartnerTrainingRequest){ 
                            $('#hidden_n_students').val(data.PartnerTrainingRequest.n_students); 
                            $('#hidden_address').val(data.PartnerTrainingRequest.address);
                        }
                        $('#hidden_timing_type').val(data.timing_type);
                        $('#hidden_online_url').val(data.online_url);
                        $('#hidden_hall_id').val(data.trainings_schaduals.hall_id);
                        $('#hidden_training_field_id').val(data.training_field_id);
                        $('#hidden_recorded').val(data.recorded);
                        $('#hidden_overall_days').val(data.overall_days);
                        $('#hidden_overall_time').val(data.overall_time);
                    }
                });
            });
            
            setTimeout(function() {
                $('#select1').select2({
                    dropdownParent: $('#trainingPartnerRequestmodel')
                });
            }, 100);
            
        //Exception
        } else if ($(this).val() === 'exception') { 

            html += '<label class="">' + "{{ trans('home.code_to_edit') }}" + '</label>';
            html += '<select id="select2" class="form-control select2 code_to_edit" name="code_to_edit" required>';
            html += '<option value="">' +  "{{ trans('home.choose_training') }}" + '</option>';
            @foreach($edit_trainings as $edit_training)
                html += '<option value="{{ $edit_training->code }}">{{ $edit_training->code . ' - ' . $edit_training->{"name_".$lang} }}</option>';
            @endforeach
            html += '</select>';
            
            $('#code_to_edit').html(html).show();
            
            $('#exception_or_not_div').hide();
            $('#exception_or_not_div #exception_or_not').val('yes');
                        
            exeception = "";
            exeception += '<label class="">' + "{{ trans('home.exception_file') }}" + '<span style="color: red;padding: 0 3px">*</span></label>';
            exeception += '<input class="form-control @error("exception_file") is-invalid @enderror" name="exception_file" required type="file" placeholder="{{ trans("home.exception_file") }}">';
            $('#exception_file').html(exeception).show();
            
            
            $('.code_to_edit').on('change', function() {
                var code = $(this).val();
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    url: "{{ url('admin/get-request-data') }}",
                    data: {code: code},
                    success: function(data) {
                        $('#name_en').val(data.name_en).prop('disabled',true);
                        $('#name_ar').val(data.name_ar).prop('disabled',true);
                        if(data.PartnerTrainingRequest){ 
                            $('#n_students').val(data.PartnerTrainingRequest.n_students); 
                            $('#address').val(data.PartnerTrainingRequest.address);
                        }
                        $('#n_students').prop('disabled',true);
                        $('#address').prop('disabled',true);
                        // $('#training_type').val(data.training_type);
                        // $('#training_type option').filter('[value="' + data.training_type + '"]').attr('selected', true);
                        $('#training_type').val(data.training_type).change().prop('disabled',true);
                        $('#timing_type').val(data.timing_type).change().prop('disabled', true);
                        $('#online_url').val(data.online_url).prop('disabled',true);
                        if(data.trainings_schaduals.hall_id){$('#hall_id').val(data.trainings_schaduals.hall_id).change().prop('disabled',true);} else {$('#hall_id').prop('disabled',true);}
                        $('#training_field_id').val(data.training_field_id).change().prop('disabled',true);
                        $('#recorded').val(data.recorded).change().prop('disabled',true);
                        $('#overall_days').val(data.overall_days);
                        $('#overall_time').val(data.overall_time).prop('disabled',true);
                        $('#instructor_id').val(data.instructor_id).change().prop('disabled',true);
                        $('#start_date').val(data.trainings_schaduals.start_date).prop('disabled',true);
                        $('#end_date').val(data.trainings_schaduals.end_date).prop('disabled',true);
                        $('#time_from').attr('type','text').val(data.time_from).prop('disabled',true);
                        $('#time_to').attr('type','text').val(data.time_to).prop('disabled',true);
                        
                        //update hidden fields with data
                        $('#hidden_name_en').val(data.name_en);
                        $('#hidden_name_ar').val(data.name_ar);
                        $('#hidden_training_type').val(data.training_type);
                        if(data.PartnerTrainingRequest){ 
                            $('#hidden_n_students').val(data.PartnerTrainingRequest.n_students); 
                            $('#hidden_address').val(data.PartnerTrainingRequest.address);
                        }
                        $('#hidden_timing_type').val(data.timing_type);
                        $('#hidden_online_url').val(data.online_url);
                        $('#hidden_hall_id').val(data.trainings_schaduals.hall_id);
                        $('#hidden_training_field_id').val(data.training_field_id);
                        $('#hidden_recorded').val(data.recorded);
                        // $('#hidden_overall_days').val(data.overall_days);
                        $('#hidden_overall_time').val(data.overall_time);
                        $('#hidden_instructor_id').val(data.instructor_id);
                        $('#hidden_start_date').val(data.trainings_schaduals.start_date);
                        $('#hidden_end_date').val(data.trainings_schaduals.end_date);
                        $('#hidden_time_from').val(data.time_from);
                        $('#hidden_time_to').val(data.time_to);
                    }
                });
            });
            
            // $('#exception_file').html(html2).show();
            setTimeout(function() {
                $('#select2').select2({
                    dropdownParent: $('#trainingPartnerRequestmodel')
                });
            }, 100);
        }
    });

    // Initialize Select2 on all existing select elements
    $('.select2').select2();
    
});
</script>
    {!! $dataTable->scripts() !!}
@endsection

