@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.edit')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.trainings')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/trainings')}}">{{trans('home.trainings')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_training')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    {!! Form::open(['method'=>'PATCH','url' => 'admin/trainings/'.$training->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.training_info')}}</h6>
                            <hr>
                        </div>
                        
                        <div class="row">
                            <div class="col-lg-12">
                                {!! Form::open(['method'=>'PATCH','url' => 'admin/trainings/'.$training->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
                                    <div class="row">
                                        <div class="col-md-4 mb-3">
                                            <label for="name_en">{{trans('home.name_en')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.name_en')}}" name="name_en" value="{{old('name_en',$training->name_en)}}"  required>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label for="name_ar">{{trans('home.name_ar')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.name_ar')}}" name="name_ar" value="{{old('name_ar',$training->name_ar)}}"  required>
                                        </div>
                                        
                                        <div class="col-md-4 mb-3">
                                            <label for="name_ar">{{trans('home.price')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.price')}}" name="price" value="{{old('price',$training->price)}}"  >
                                        </div>
                                        
                                        <div class="col-md-2 mb-3">
                                        <label for="period">{{trans('home.training_period')}}</label>
                                        <select class="form-control" data-trigger name="period">
                                                <option @selected(old('period',$training->period) == 'am') value="am" >{{ __('home.am') }}</option>
                                                <option @selected(old('period',$training->period) == 'pm') value="pm" >{{ __('home.pm') }}</option>
                                            </select>
                                        </div>
                             

                                        <div class="col-md-3 mb-3">
                                            <label for="level_id">{{trans('home.category')}}</label>
                                            <select class="form-control" data-trigger name="category_id" required>
                                                @foreach($categories as $category)
                                                <option value="{{$category->id}}" @selected(old('category_id',$training->category_id) == $category->id) >{{$category->{'name_'.$lang} }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label for="type">{{trans('home.training_type')}}</label>
                                            <select class="form-control" data-trigger name="type_id">
                                                @foreach($types as $type)
                                                <option value="{{$type->id}}" @selected(old('type_id',$training->type_id) == $type->id) >{{$type->{'name_'.$lang} }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                   

                                        <div class="col-md-2 mb-3">
                                            <label for="duration">{{trans('home.duration')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.duration')}}" name="duration" value="{{old('duration',$training->duration)}}" >
                                        </div>
                                        <div class="col-md-2 mb-3">
                                            <label for="duration">{{trans('home.overall_days')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.overall_days')}}" name="overall_days" value="{{old('overall_days',$training->overall_days)}}" >
                                        </div>
                                        
                                        <div class="form-group col-md-2">
                                            <label for="mobile">{{trans('home.mobile')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.mobile')}}" name="mobile" value="{{old('mobile',$training->mobile)}}">
                                        </div>
                                        
                                        <div class="form-group col-md-2">
                                            <label for="whatsapp">{{trans('home.whatsapp')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.whatsapp')}}" name="whatsapp" value="{{old('whatsapp',$training->whatsapp)}}">
                                        </div>
                                        
                                        <div class="form-group col-2">
                                            <label for="start_date">{{trans('home.start_date')}}</label>
                                            <div class="input-group">
                                                <input type='text' class="form-control datepicker" name="start_date" value="{{old('start_date', $training->trainings_schaduals ? \Carbon\Carbon::parse($training->trainings_schaduals->start_date)->format("Y-m-d") : '')}}" placeholder="{{trans('home.start_date')}}"  readonly/>
                                                <div class="input-group-append">
                                                    <span class="input-group-text">
                                                        <i class="fas fa-calendar"></i>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group col-2">
                                            <label for="end_date">{{trans('home.end_date')}}</label>
                                            <div class="input-group">
                                                <input type='text' class="form-control datepicker" name="end_date"  value="{{old('end_date', $training->trainings_schaduals ? \Carbon\Carbon::parse($training->trainings_schaduals->end_date)->format("Y-m-d") : '')}}" placeholder="{{trans('home.end_date')}}"  readonly/>
                                                <div class="input-group-append">
                                                    <span class="input-group-text">
                                                        <i class="fas fa-calendar"></i>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-3 mb-3">
                                            <label for="type">{{trans('home.teachers')}}</label>
                                            <select class="form-control choices-multiple-remove-button" name="teacher_id[]" multiple>
                                                @foreach ($teachers as $teacher)
                                                <option value ="{{$teacher->id}}" @if(json_decode($training->teacher_id)) @selected(in_array($teacher->id,old('point_id',json_decode($training->teacher_id)))) @endif>{{$teacher->name}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label for="type">{{trans('home.learn points')}}</label>
                                            <select class="form-control choices-multiple-remove-button" name="course_point_id[]" multiple>
                                                @foreach ($points as $point)
                                                    <option value ="{{$point->id}}" @if(json_decode($training->course_point_id)) @selected(in_array($point->id,old('course_point_id',json_decode($training->course_point_id)))) @endif>{{$point->{'text_'.$lang} }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="type">{{trans('home.Include material')}}</label>
                                            <select class="form-control choices-multiple-remove-button" name="material_id[]" multiple>
                                                @foreach ($materials as $material)
                                                    <option value ="{{$material->id}}" @if(json_decode($training->course_material_id)) @selected(in_array($material->id,old('course_material_id',json_decode($training->course_material_id)))) @endif>
                                                        {{$material->{'text_'.$lang} }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="type">{{trans('home.requirments')}}</label>
                                            <select class="form-control choices-multiple-remove-button" name="requirment_id[]" multiple>
                                                @foreach ($requirments as $requirment)
                                                    <option value ="{{$requirment->id}}" @if(json_decode($training->course_requirment_id)) @selected(in_array($requirment->id,old('course_requirment_id',json_decode($training->course_requirment_id)))) @endif>
                                                        {{$requirment->{'text_'.$lang} }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="type">{{trans('home.course')}}</label>
                                            <select class="form-control choices-multiple-remove-button" name="course_id" >
                                                <option value ="">{{trans('home.choose_course') }}</option>
                                                @foreach ($courses as $course)
                                                    <option @selected($course->id == old('course_id',$training->course_id)) value="{{$course->id}}">
                                                        {{$course->{'name_'.$lang} }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="type">{{trans('home.course_field')}}</label>
                                            <select class="form-control choices-multiple-remove-button" name="training_field_id" required>
                                                <option value ="">{{trans('home.choose_course_field') }}</option>
                                                @foreach ($fields as $field)
                                                    <option value="{{$field->id}}" @selected($field->id == old('training_field_id',$training->training_field_id)) >
                                                        {{$field->{'name_'.$lang} }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <hr class="mt-3">
                                        <div class="form-group col-4 mb-3">                                            
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="intro_link" id="switch_intro_link" switch="success" {{$intro_link?'checked':''}}/>
                                                <label for="switch_intro_link" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                                <label class="form-check-label mx-3" for="switch_intro_link">{{trans('home.intro_link')}} ({{trans('home.press_to_add')}})</label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label for="intro_link_video">{{trans('home.intro_link_video')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.intro_link_video')}}" name="intro_link_video" value="{{old('intro_link_video',$training->intro_link_video)}}" >
                                        </div>

                                        <div class="col-md-4 mb-3">
                                            <label for="formFile" class="form-label">{{ trans('home.choose_intro_video') }}</label>
                                            <input class="form-control" type="file" id="formFile" name="video">
                                        </div>
                                        @if($intro_link)
                                            @if($training->intro_link_video)
                                                <div class="form-group  col-md-3 m-2 mt-3">
                                                    <iframe width="200" height="150" src="{{ $training->intro_link_video}}"></iframe>
                                                </div>
                                            @else
                                                <div class="form-group  col-md-3 m-2 mt-3">
                                                    <img src="{{url('resources/assets/back/images/noimage.jpg')}}" width="70">
                                                </div>
                                            @endif
                                        @else
                                            @if($training->video)
                                                <div class="form-group  col-md-3 m-2 mt-3">
                                                    <video src="{{ url('uploads/trainings/source/' . $training->video) }}" width="200" height="150" controls></video>
                                                </div>
                                            @else
                                                <div class="form-group  col-md-3 m-2 mt-3">
                                                    <img src="{{url('resources/assets/back/images/noimage.jpg')}}" width="70">
                                                </div>
                                            @endif
                                        @endif
                                            <hr>

                                        
                                        <div class="row mt-3">
                                          
                                            <div class="form-group col-12 mb-3">                                            
                                                <div class="form-check d-flex">
                                                    <input type="checkbox" value="1" name="do_discount" id="switch_discount" switch="success" {{$discount?'checked':''}}/>
                                                    <label for="switch_discount" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                                    <label class="form-check-label mx-3" for="switch_discount">{{trans('home.discount')}} ({{trans('home.press_to_add')}})</label>
                                                </div>
                                            </div>
                                            <div class="col-md-4 mb-3 discount_div {{$discount?0:'d-none'}}" >
                                                <label for="value">{{trans('home.value')}}{{trans('home.discount')}}</label>
                                                <input type="text"  class="form-control" placeholder="{{trans('home.value')}} {{trans('home.discount')}}" name="discount_value" value="{{$discount?$discount->value:0}}" >
                                            </div>
                                            <div class="col-md-4 mb-3 discount_div {{$discount?0:'d-none'}}" >
                                                <label for="end_date">{{trans('home.end_date')}}{{trans('home.discount')}}</label>
                                                <input type="date" id="end_date"  class="form-control" placeholder="{{trans('home.end_date')}} {{trans('home.discount')}}" name="end_date" value="{{$discount?$discount->end_date:''}}" >
                                            </div>
                                        </div>

                                        <div class="col-md-8 mb-3">
                                            <label for="formFile" class="form-label">{{ trans('home.choose_image') }}</label>
                                            <input class="form-control" type="file" id="formFile" name="image">
                                        </div>
                                        @if($training->image)
                                            <div class="form-group  col-md-3 m-2 mt-3">
                                                <img src="{{url('\uploads\courses\source')}}\{{$training->image}}" width="200" height="150">
                                            </div>
                                        @else
                                            <div class="form-group  col-md-3 m-2 mt-3">
                                                <img src="{{url('resources/assets/back/images/noimage.jpg')}}" width="70">
                                            </div>
                                        @endif


                                        <div class="col-md-8 mb-3">
                                            <label for="formFile" class="form-label">{{ trans('home.certificate') }}</label>
                                            <input class="form-control" type="file" id="formFile" name="certificate">
                                        </div>
                                        @if($training->certificate)
                                            <div class="form-group  col-md-3 m-2 mt-3">
                                                <img src="{{url('\uploads\courses\source')}}\{{$training->certificate}}" width="200" height="150">
                                            </div>
                                        @else
                                            <div class="form-group  col-md-3 m-2 mt-3">
                                                <img src="{{url('resources/assets/back/images/noimage.jpg')}}" width="70">
                                            </div>
                                        @endif
                                        <div class="col-md-8 mb-3">
                                            <label for="formFile" class="form-label">{{ trans('home.course_file') }}</label>
                                            <input class="form-control" type="file" id="formFile" name="course_file">
                                        </div>
                                        @if($training->certificate)
                                            <div class="form-group  col-md-3 m-2 mt-3">
                                                <img src="{{url('\uploads\courses\source')}}\{{$training->course_file}}" width="200" height="150">
                                            </div>
                                        @else
                                            <div class="form-group  col-md-3 m-2 mt-3">
                                                <img src="{{url('resources/assets/back/images/noimage.jpg')}}" width="70">
                                            </div>
                                        @endif
                                        
                                         <br>
                                    <hr>
                                    <br>


                                        

                                        <div class="col-md-6 mb-3 ">  
                                            <label for="text_en">{{trans('home.text_en')}}</label>
                                            <textarea class="form-control ckeditor-classic area1" placeholder="{{trans('home.text_en')}}" name="text_en">{{ old('text_en',$training->text_en) }}</textarea>
                                        </div>                                      
                                        <div class="col-md-6 mb-3 ">  
                                            <label for="text_ar">{{trans('home.text_ar')}}</label>
                                            <textarea class="form-control ckeditor-classic area1" placeholder="{{trans('home.text_ar')}}" name="text_ar">{{old('text_en',$training->text_ar)}}</textarea>
                                        </div>

                                        
                                        <hr>
                                        
                                        <h4 class="card-title mt-3 mb-3">{{trans('home.seo_block')}}</h4>
                                        <div class="col-md-12 mb-3">
                                            <label for="redirect_url">{{trans('home.redirect_url')}}</label>
                                            <input type="text" class="form-control" value="{{ old('redirect_url',$training->redirect_url) }}" placeholder="{{trans('home.redirect_url')}}" name="redirect_url">
                                        </div>
                                        <div class="form-group col-md-6">
                                            <span class="badge-soft-primary">{{trans('home.en')}}</span>
                                            <div class="col-md-12 mb-3">
                                                <label for="link_en">{{trans('home.slug')}}</label>
                                                <input type="text" class="form-control" placeholder="{{trans('home.slug').' '.__('home.en')}}" value="{{old('link_en',$training->link_en)}}" name="link_en">
                                            </div>
                                            <div class="col-md-12 mb-3">
                                                <label for="meta_title"> {{trans('home.meta_title')}}</label>
                                                <textarea class="form-control" name="meta_title_en" placeholder="{{trans('home.meta_title')}}">{{old('meta_title_en',$training->meta_title_en)}}</textarea>
                                            </div>
        
                                            <div class="col-md-12 mb-3">
                                                <label for="meta_desc"> {{trans('home.meta_desc')}}</label>
                                                <textarea class="form-control" name="meta_desc_en" placeholder="{{trans('home.meta_desc')}}">{{old('meta_desc_en',$training->meta_desc_en)}}</textarea>
                                            </div>
                                        </div>
    
    
                                        <div class="form-group col-md-6">
                                            <span class="badge-soft-primary">{{trans('home.ar')}}</span>
                                            <div class="col-md-12 mb-3">
                                                <label for="link_ar">{{trans('home.slug')}}</label>
                                                <input type="text" class="form-control" placeholder="{{trans('home.slug').' '.__('home.ar')}}" value="{{old('link_ar',$training->link_ar)}}" name="link_ar">
                                            </div>
                                            <div class="col-md-12 mb-3">
                                                <label for="meta_title"> {{trans('home.meta_title')}}</label>
                                                <textarea class="form-control" name="meta_title_ar" placeholder="{{trans('home.meta_title')}}">{{old('meta_title_ar',$training->meta_title_ar)}}</textarea>
                                            </div>
        
                                            <div class="col-md-12 mb-3">
                                                <label for="meta_desc"> {{trans('home.meta_desc')}}</label>
                                                <textarea class="form-control" name="meta_desc_ar" placeholder="{{trans('home.meta_desc')}}">{{old('meta_desc_ar',$training->meta_desc_ar)}}</textarea>
                                            </div>
                                        </div>


                                   
                                    </div>

                                    <div class="row">
                                        <div class="form-group col-4">                                            
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch" switch="success" {{$training->status?'checked':''}}/>
                                                <label for="switch" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                                <label class="form-check-label mx-3" for="switch"> {{trans('home.publish')}}</label>
                                            </div>
                                        </div>
                                        <div class="form-group col-4">                                            
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="header" id="switch1" switch="success" {{$training->header?'checked':''}}/>
                                                <label for="switch1" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                                <label class="form-check-label mx-3" for="switch1"> {{trans('home.featured')}}</label>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-12">
                                            <p class="mt-4 mb-2">{{trans('home.meta_robots')}}</p>
                                            <label class="custom-switch">
                                                <input type="checkbox" name="meta_robots" value="1" class="custom-switch-input" {{($training->meta_robots == 1)? 'checked':''}}>
                                                <span class="custom-switch-indicator"></span>
                                                <span class="custom-switch-description">{{trans('home.click_to_index')}}</span>
                                            </label>
                                        </div>
                                        <div class="form-group col-4">                                            
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="publish" id="switch2" switch="success"  {{$training->publish?'checked':''}}/>
                                            <label for="switch2" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                            <label class="form-check-label mx-3" for="switch2"> {{trans('home.clickable')}}</label>
                                        </div>
                                    </div>
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                        <a href="{{url('/admin/trainings')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                    </div>


                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
</div>
@endsection


@section('script')
    <script>
        $( ".datepicker" ).datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd'
        });
        
        $(document).ready(function(){
            $('.timepicker').timepicker({
                timeFormat: 'h:mm p',
            });
        });
        
        document.getElementById('switch_discount').addEventListener('change', function() {
            var discountDiv = $('.discount_div') ;
            if (this.checked) {
                $('.discount_div').removeClass('d-none')
            } else {
                $('.discount_div').addClass('d-none')
            }
        });
    </script>
@endsection

