@extends('layouts.app')
@section('meta')
   <title>{{__('home.company_survey')}}</title>
@endsection

@section('style')
    <style>
        .back-wrapper {
            margin-top: -321px;
        }
    </style>
@endsection

@section('content')
<div class="back-wrapper">
    <div class="back-wrapper-inner">
        <!--================= Back Breadcrumbs Section Start Here =================-->
        <div class="back-breadcrumbs">
            <div class="breadcrumbs-wrap">
                <img class="desktop" src="{{ Helper::imageFilesPath('breadcrumbs/1.png')}}" alt="Breadcrumbs">
                <img class="mobile" src="{{ Helper::imageFilesPath('breadcrumbs/1.png')}}" alt="Breadcrumbs">
                <div class="breadcrumbs-inner">
                    <div class="container">
                        <div class="col-md-12 text-center wow fadeInUp mt-n3" data-wow-delay="300ms">
                        <!--<span class="defaultcolor">{{trans('home.wad Forum')}}</span>-->
                        <div class="heading-title bottom25 darkcolor">
                          
                        </div>
                        
                    </div>
                    </div>
                </div>
            </div>
        </div>
        <!--================= Back Breadcrumbs Section End Here =================-->
        </div>
    </div>
    <div class="container back-contact-page pt-120 pb-120">
        @if($training_survey)
            <form method="POST" action="{{route('submit_company_survay')}}" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="survey_id" value="{{$training_survey->survey->id}}">
                <input type="hidden" name="training_id" value="{{$training_survey->training_id}}">
                 <h3>{{$training_survey->survey->{'name_'.$lang} }} </h3>
                <div class="single-week">
                  <ul class="week__top mb-0 border-0" >
                  <div class="col-12">
                    @foreach($training_survey->survey->surveyQuestions as $index_survey => $survey_question)
                    <div class="row mt-4">
                            <li class="mb-2">{{($index_survey + 1).' - '}} {{$survey_question->{'question_'.$lang} }}</li>
                            @if($survey_question->question_type=="file")
                            <input type="hidden" name="attached_questions[]" value="{{$survey_question->id}}" >
                            @else
                            <input type="hidden" name="questions[]" value="{{$survey_question->id}}" >
                            @endif
                        @if($survey_question->question_type=="link")
                            <input class="col-8 col-sm-12" type="text" name="answers[{{$survey_question->id}}]" placeholder="{{__('home.link')}}">
                        @elseif($survey_question->question_type=="notes")
                            <textarea class="col-8 col-sm-12" type="text" name="answers[{{$survey_question->id}}]" placeholder="{{__('home.answer')}}" rows="3"></textarea>
                        
                        @elseif($survey_question->question_type=="rate")
                            <div class="row">
                            <div class="form-check col-2 col-xsm-4">
                                <input class="form-check-input"style="margin-left: 40px;" type="radio" name="answers[{{$survey_question->id}}]" id="flexRadioDefault_Perfect_{{$survey_question->id}}" value="Perfect">
                                <label class="form-check-label" for="flexRadioDefault_Perfect_{{$survey_question->id}}">
                                    {{__('home.Perfect') }}
                                </label>
                            </div>
                            <div class="form-check col-2 col-xsm-4">
                                <input class="form-check-input"style="margin-left: 40px;" type="radio" name="answers[{{$survey_question->id}}]" id="flexRadioDefault_Good_{{$survey_question->id}}" value="Good">
                                <label class="form-check-label" for="flexRadioDefault_Good_{{$survey_question->id}}">
                                    {{__('home.Good') }}
                                </label>
                            </div>
                            <div class="form-check col-3 col-xsm-4">
                                <input class="form-check-input"style="margin-left: 40px;" type="radio" name="answers[{{$survey_question->id}}]" id="flexRadioDefault_Average_{{$survey_question->id}}" value="Average">
                                <label class="form-check-label" for="flexRadioDefault_Average_{{$survey_question->id}}">
                                    {{__('home.Average') }}
                                </label>
                            </div>
                            <div class="form-check col-2 col-xsm-4">
                                <input class="form-check-input"style="margin-left: 40px;" type="radio" name="answers[{{$survey_question->id}}]" id="flexRadioDefault_Poor_{{$survey_question->id}}" value="Poor">
                                <label class="form-check-label" for="flexRadioDefault_Poor_{{$survey_question->id}}">
                                    {{__('home.Poor') }}
                                </label>
                            </div>
                            <div class="form-check col-3 col-xsm-4">
                                <input class="form-check-input"style="margin-left: 40px;" type="radio" name="answers[{{$survey_question->id}}]" id="flexRadioDefault_VeryBad_{{$survey_question->id}}" value="Very Bad">
                                <label class="form-check-label" for="flexRadioDefault_VeryBad_{{$survey_question->id}}">
                                    {{__('home.Very Bad') }}
                                </label>
                            </div>
                        </div>
                        @elseif($survey_question->question_type=="file")
                            <div class="form-group">
                                <input id="pdf_file" class="form-control-file" type="file" name="attached[{{$survey_question->id}}]">
                            </div>
                        @endif
                    </div>
                    @endforeach
                  </div>
                  </ul>
                </div>
                <div class=" pt-3 m-auto">
                        <button type="submit" class="submit btn w-btn-3">{{__('home.submit_exame') }}</button>
                </div>
            </form>
      @endif
            
    </div>

@endsection

@section('script')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.all.min.js"></script>

    @if(session()->has('registerd_before'))
        <script>
            Swal.fire({
                icon: 'error',
                title: '{{ session()->pull("registerd_before") }}',
            });
        </script>
    @endif
    @if(session()->has('request_success_message'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->pull("request_success_message") }}',
            });
        </script>
    @endif
@endsection
