@extends('layouts.admin')
@section('meta')
    <title>{{ trans('home.edit_instructor') }}</title>
@endsection
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.instructors') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('instructors.index') }}">{{ trans('home.instructors') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.edit_instructor') }}</li>
                </ol>
            </div>
        </div>
         <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{trans('home.edit_teacher')}}</h4>
                    </div>
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                {!! Form::open(['method'=>'PATCH','url' => 'admin/teachers/'.$teacher->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
                                    <div class="row">

                                        <div class="col-md-3 mb-3">
                                            <label for="name">{{trans('home.name')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.name')}}" name="name"value="{{$teacher->name}}" required>
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label for="email">{{trans('home.email')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.email')}}" name="email"value="{{$teacher->email}}">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="phone">{{trans('home.phone')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.phone')}}" name="phone"value="{{$teacher->phone}}">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="category">{{trans('home.category speacialization').' en'}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.category speacialization')}}" name="category_en"value="{{$teacher->category_en}}">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="category">{{trans('home.category speacialization').' ar'}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.category speacialization')}}" name="category_ar"value="{{$teacher->category_ar}}">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="position">{{trans('home.position').' en'}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.position')}}" name="position_en"value="{{$teacher->position_en}}">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="position">{{trans('home.position').' ar'}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.position')}}" name="position_ar"value="{{$teacher->position_ar}}">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="facebook">{{trans('home.facebook')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.facebook')}}" name="facebook"value="{{$teacher->facebook}}">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="linkedin">{{trans('home.linkedin')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.linkedin')}}" name="linkedin"value="{{$teacher->linkedin}}">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="instgram">{{trans('home.instgram')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.instgram')}}" name="instgram"value="{{$teacher->instgram}}">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="pintrest">{{trans('home.pintrest')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.pintrest')}}" name="pintrest"value="{{$teacher->pintrest}}">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="youtube">{{trans('home.youtube')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.youtube')}}" name="youtube"value="{{$teacher->youtube}}">
                                        </div>

                                        <div class="col-md-8 mb-3 ">
                                            <label for="formFile" class="form-label">{{ trans('home.choose_image') }}</label>
                                            <input class="form-control" type="file" id="formFile" name="image">
                                        </div>
                                        @if($teacher->image)
                                            <div class="form-group  col-md-8 m-2 mt-3">
                                                <img src="{{url('\uploads\users\source')}}\{{$teacher->image}}" width="200" height="150">
                                            </div>
                                        @else
                                            <div class="form-group  col-md-3 mt-3">
                                                <img src="{{url('resources/assets/back/images/noimage.jpg')}}" width="70">
                                            </div>
                                        @endif

                                        <div class="form-group col-md-6 ">
                                            <label for="text_en">{{trans('home.text_en')}}</label>
                                            <textarea class="form-control ckeditor-classic" placeholder="{{trans('home.text_en')}}" name="text_en">{!! $teacher->text_en !!}</textarea>
                                            <br>
                                        </div>                                       
                                        <div class="form-group col-md-6 ">
                                            <label for="text_ar">{{trans('home.text_ar')}}</label>
                                            <textarea class="form-control ckeditor-classic" placeholder="{{trans('home.text_ar')}}" name="text_ar">{!! $teacher->text_ar !!}</textarea>
                                            <br>
                                        </div>                                       
                                    </div>
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                        <a href="{{url('/admin/teachers')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                    </div>


                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection

@section('script')
    <script>
        $('.country').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getAreas')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    area.html(html);
                }
            });
        });

        $('.area').change(function () {
            var id = $(this).val();
            var region = $('.region');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getRegions')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    region.html(html);
                }
            });
        });
    </script>
    <script>
        $("#datepicker").datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd'
        });
    </script>
@endsection
