@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_teacher')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.teachers')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/teachers')}}">{{trans('home.teachers')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_teacher')}}</li>
            </ol>
        </div>
    </div>

 <!-- End Page Header -->
    {!! Form::open(['route' => 'teachers.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{trans('home.add_teacher')}}</h4>
                    </div>
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                {!! Form::open(['route' => 'teachers.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
                                    <div class="row">

                                        <div class="col-md-3 mb-3">
                                            <label for="name">{{trans('home.name')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.name')}}" name="name" required>
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label for="email">{{trans('home.email')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.email')}}" name="email">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="phone">{{trans('home.phone')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.phone')}}" name="phone">
                                        </div>
                                        
                                        <div class="col-md-3 mb-3">
                                            <label for="category">{{trans('home.category speacialization').' en'}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.category speacialization')}}" name="category_en">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="category">{{trans('home.category speacialization').' ar'}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.category speacialization')}}" name="category_ar">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="position">{{trans('home.position').' en'}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.position')}}" name="position_en">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="position">{{trans('home.position').' ar'}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.position')}}" name="position_ar">
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label for="facebook">{{trans('home.facebook')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.facebook')}}" name="facebook">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="linkedin">{{trans('home.linkedin')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.linkedin')}}" name="linkedin">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="instgram">{{trans('home.instgram')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.instgram')}}" name="instgram">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="pintrest">{{trans('home.pintrest')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.pintrest')}}" name="pintrest">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="youtube">{{trans('home.youtube')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.youtube')}}" name="youtube">
                                        </div>

                                        <div class="col-md-12 mb-3 ">
                                            <label for="formFile" class="form-label">{{ trans('home.choose_image') }}</label>
                                            <input class="form-control" type="file" id="formFile" name="image">
                                        </div>
    

                                        <div class="col-md-6 mb-3 ">  
                                            <label for="text_en">{{trans('home.text_en')}}</label>
                                            <textarea class="form-control ckeditor-classic" placeholder="{{trans('home.text_en')}}" name="text_en"></textarea>
                                        </div>                                      
                                        <div class="col-md-6 mb-3 ">  
                                            <label for="text_ar">{{trans('home.text_ar')}}</label>
                                            <textarea class="form-control ckeditor-classic" placeholder="{{trans('home.text_ar')}}" name="text_ar"></textarea>
                                        </div>

                                    </div>
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                        <a href="{{url('/admin/teachers')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                    </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <!-- End Row -->
</div>

@endsection
