@extends('layouts.admin')

@section('meta')
    <title>{{trans('home.surveys_results')}}</title>
@endsection


@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.surveys_results')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.surveys_results')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.surveys_results')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                            <hr>
                        </div>
                        <div class="d-flex justify-content-left m-3">
                            <input style="width:15px; margin-left:5px" type="checkbox" name="checkbox" class="tableChecked" value="Select All" id="checkAll"/>
                            <label style="font-size:20px; padding-top:10px" for="checkAll">{{trans('home.select_all')}}</label>
                        </div>
                        {!! $dataTable->table(['class' => 'table table-bordered w-100']) !!}
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
     
   
@endsection

@section('script')
    {!! $dataTable->scripts() !!}
@endsection
